/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.admin;

import com.rabbitmq.jms.admin.RMQConnectionFactory;
import com.rabbitmq.jms.admin.RMQDestination;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQObjectFactory
implements ObjectFactory {
    private final Logger logger = LoggerFactory.getLogger(RMQObjectFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable<?, ?> environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        String className = ref.getClassName();
        if (className == null || className.trim().length() == 0) {
            throw new NamingException("Unable to instantiate object: type has not been specified");
        }
        boolean topic = false;
        boolean connectionFactory = false;
        if (QueueConnectionFactory.class.getName().equals(className) || TopicConnectionFactory.class.getName().equals(className) || ConnectionFactory.class.getName().equals(className)) {
            connectionFactory = true;
        } else if (Topic.class.getName().equals(className)) {
            topic = true;
        } else if (!Queue.class.getName().equals(className)) {
            throw new NamingException(String.format("Unknown class [%s]", className));
        }
        if (connectionFactory) {
            return this.createConnectionFactory(ref, name);
        }
        return this.createDestination(ref, name, topic);
    }

    public Object createConnectionFactory(Reference ref, Name name) throws NamingException {
        this.logger.trace("Creating connection factory ref '{}', name '{}'.", (Object)ref, (Object)name);
        RMQConnectionFactory f = new RMQConnectionFactory();
        try {
            f.setUri(this.getStringProperty(ref, "uri", true, f.getUri()));
        }
        catch (JMSException e) {
            this.logger.warn("Failed to set RMQConnectionFactory properties by URI--defaults taken initially.", (Throwable)e);
        }
        f.setHost(this.getStringProperty(ref, "host", true, f.getHost()));
        f.setPassword(this.getStringProperty(ref, "password", true, f.getPassword()));
        f.setPort(this.getIntProperty(ref, "port", true, f.getPort()));
        f.setQueueBrowserReadMax(this.getIntProperty(ref, "queueBrowserReadMax", true, f.getQueueBrowserReadMax()));
        f.setOnMessageTimeoutMs(this.getIntProperty(ref, "onMessageTimeoutMs", true, f.getOnMessageTimeoutMs()));
        f.setSsl(this.getBooleanProperty(ref, "ssl", true, f.isSsl()));
        f.setTerminationTimeout(this.getLongProperty(ref, "terminationTimeout", true, f.getTerminationTimeout()));
        f.setUsername(this.getStringProperty(ref, "username", true, f.getUsername()));
        f.setVirtualHost(this.getStringProperty(ref, "virtualHost", true, f.getVirtualHost()));
        return f;
    }

    public Object createDestination(Reference ref, Name name, boolean topic) throws NamingException {
        this.logger.trace("Creating destination ref '{}', name '{}' (topic={}).", new Object[]{ref, name, topic});
        String dname = this.getStringProperty(ref, "destinationName", false, null);
        boolean amqp = this.getBooleanProperty(ref, "amqp", true, false);
        if (amqp) {
            String amqpExchangeName = this.getStringProperty(ref, "amqpExchangeName", false, null);
            String amqpRoutingKey = this.getStringProperty(ref, "amqpRoutingKey", false, null);
            String amqpQueueName = this.getStringProperty(ref, "amqpQueueName", false, null);
            return new RMQDestination(dname, amqpExchangeName, amqpRoutingKey, amqpQueueName);
        }
        return new RMQDestination(dname, !topic, false);
    }

    private String getStringProperty(Reference ref, String propertyName, boolean mayBeNull, String defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        return content;
    }

    private boolean getBooleanProperty(Reference ref, String propertyName, boolean mayBeNull, boolean defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        return Boolean.valueOf(content);
    }

    private int getIntProperty(Reference ref, String propertyName, boolean mayBeNull, int defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(content);
        }
        catch (Exception x) {
            NamingException nx = new NamingException(String.format("Property [%s] is present but is not an integer value [%s]", propertyName, content));
            nx.setRootCause(x);
            throw nx;
        }
    }

    private long getLongProperty(Reference ref, String propertyName, boolean mayBeNull, long defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(content);
        }
        catch (Exception x) {
            NamingException nx = new NamingException(String.format("Property [%s] is present but is not a long integer value [%s]", propertyName, content));
            nx.setRootCause(x);
            throw nx;
        }
    }

    private static String propertyStringContent(RefAddr ra) {
        return ra == null ? null : (ra.getContent() == null ? null : ra.getContent().toString());
    }

    private static String propertyContent(Reference ref, String propertyName, boolean mayBeNull) throws NamingException {
        RefAddr ra = ref.get(propertyName);
        if (!mayBeNull && ra == null) {
            throw new NamingException(String.format("Property [%s] may not be null.", propertyName));
        }
        String content = RMQObjectFactory.propertyStringContent(ra);
        if (content == null && !mayBeNull) {
            throw new NamingException(String.format("Property [%s] is present but is lacking a value.", propertyName));
        }
        return content;
    }
}

