/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.jms.client.ConnectionParams;
import com.rabbitmq.jms.client.RMQConnectionMetaData;
import com.rabbitmq.jms.client.RMQMessageConsumer;
import com.rabbitmq.jms.client.RMQSession;
import com.rabbitmq.jms.client.SessionParams;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.WhiteListObjectInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQConnection
implements Connection,
QueueConnection,
TopicConnection {
    public static final int NO_CHANNEL_QOS = -1;
    private final Logger logger = LoggerFactory.getLogger(RMQConnection.class);
    private final com.rabbitmq.client.Connection rabbitConnection;
    private static final ConnectionMetaData connectionMetaData = new RMQConnectionMetaData();
    private String clientID;
    private final AtomicReference<ExceptionListener> exceptionListener = new AtomicReference();
    private final List<RMQSession> sessions = Collections.synchronizedList(new ArrayList());
    private volatile boolean closed = false;
    private final AtomicBoolean stopped = new AtomicBoolean(true);
    private final long terminationTimeout;
    private final int queueBrowserReadMax;
    private final int onMessageTimeoutMs;
    private static ConcurrentHashMap<String, String> CLIENT_IDS = new ConcurrentHashMap();
    private final Map<String, RMQMessageConsumer> subscriptions = new ConcurrentHashMap<String, RMQMessageConsumer>();
    private volatile boolean canSetClientID = true;
    private final int channelsQos;
    private boolean preferProducerMessageProperty;
    private boolean requeueOnMessageListenerException;
    private final boolean cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose;
    private List<String> trustedPackages = WhiteListObjectInputStream.DEFAULT_TRUSTED_PACKAGES;
    private static final long FIFTEEN_SECONDS_MS = 15000L;
    private static final int TWO_SECONDS_MS = 2000;

    public RMQConnection(ConnectionParams connectionParams) {
        connectionParams.getRabbitConnection().addShutdownListener((ShutdownListener)new RMQConnectionShutdownListener());
        this.rabbitConnection = connectionParams.getRabbitConnection();
        this.terminationTimeout = connectionParams.getTerminationTimeout();
        this.queueBrowserReadMax = connectionParams.getQueueBrowserReadMax();
        this.onMessageTimeoutMs = connectionParams.getOnMessageTimeoutMs();
        this.channelsQos = connectionParams.getChannelsQos();
        this.preferProducerMessageProperty = connectionParams.willPreferProducerMessageProperty();
        this.requeueOnMessageListenerException = connectionParams.willRequeueOnMessageListenerException();
        this.cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose = connectionParams.isCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose();
    }

    public RMQConnection(com.rabbitmq.client.Connection rabbitConnection, long terminationTimeout, int queueBrowserReadMax, int onMessageTimeoutMs) {
        this(new ConnectionParams().setRabbitConnection(rabbitConnection).setTerminationTimeout(terminationTimeout).setQueueBrowserReadMax(queueBrowserReadMax).setOnMessageTimeoutMs(onMessageTimeoutMs));
    }

    public RMQConnection(com.rabbitmq.client.Connection rabbitConnection) {
        this(rabbitConnection, 15000L, 0, 2000);
    }

    int getQueueBrowserReadMax() {
        return this.queueBrowserReadMax;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.logger.trace("transacted={}, acknowledgeMode={}", (Object)transacted, (Object)acknowledgeMode);
        this.illegalStateExceptionIfClosed();
        this.freezeClientID();
        RMQSession session = new RMQSession(new SessionParams().setConnection(this).setTransacted(transacted).setOnMessageTimeoutMs(this.onMessageTimeoutMs).setMode(acknowledgeMode).setSubscriptions(this.subscriptions).setPreferProducerMessageProperty(this.preferProducerMessageProperty).setRequeueOnMessageListenerException(this.requeueOnMessageListenerException).setCleanUpServerNamedQueuesForNonDurableTopics(this.cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose));
        session.setTrustedPackages(this.trustedPackages);
        this.sessions.add(session);
        return session;
    }

    private void freezeClientID() {
        this.canSetClientID = false;
    }

    private void illegalStateExceptionIfClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    public String getClientID() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        this.logger.trace("set ClientID to '{}'", (Object)clientID);
        this.illegalStateExceptionIfClosed();
        if (!this.canSetClientID) {
            throw new IllegalStateException("Client ID can only be set right after connection creation");
        }
        if (this.clientID == null) {
            if (CLIENT_IDS.putIfAbsent(clientID, clientID) != null) {
                throw new InvalidClientIDException(String.format("A connection with client ID [%s] already exists.", clientID));
            }
        } else {
            throw new IllegalStateException("Client ID already set.");
        }
        this.clientID = clientID;
    }

    public List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    public void setTrustedPackages(List<String> value) {
        this.trustedPackages = value;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.illegalStateExceptionIfClosed();
        this.freezeClientID();
        return connectionMetaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.illegalStateExceptionIfClosed();
        this.freezeClientID();
        return this.exceptionListener.get();
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.logger.trace("set ExceptionListener ({}) on connection ({})", (Object)listener, (Object)this);
        this.illegalStateExceptionIfClosed();
        this.freezeClientID();
        this.exceptionListener.set(listener);
    }

    public void start() throws JMSException {
        this.logger.trace("starting connection ({})", (Object)this);
        this.illegalStateExceptionIfClosed();
        this.freezeClientID();
        if (this.stopped.compareAndSet(true, false)) {
            for (RMQSession session : this.sessions) {
                session.resume();
            }
        }
    }

    public void stop() throws JMSException {
        this.logger.trace("stopping connection ({})", (Object)this);
        this.illegalStateExceptionIfClosed();
        this.freezeClientID();
        if (this.stopped.compareAndSet(false, true)) {
            for (RMQSession session : this.sessions) {
                session.pause();
            }
        }
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public void close() throws JMSException {
        block4: {
            this.logger.trace("closing connection ({})", (Object)this);
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.removeClientID();
            this.exceptionListener.set(null);
            this.closeAllSessions();
            try {
                this.rabbitConnection.close();
            }
            catch (ShutdownSignalException shutdownSignalException) {
            }
            catch (IOException x) {
                if (x.getCause() instanceof ShutdownSignalException) break block4;
                throw new RMQJMSException(x);
            }
        }
    }

    private void removeClientID() throws JMSException {
        String cID = this.clientID;
        if (cID != null) {
            CLIENT_IDS.remove(cID);
        }
    }

    private void closeAllSessions() {
        for (RMQSession session : this.sessions) {
            try {
                session.internalClose();
            }
            catch (Exception e) {
                if (e instanceof ShutdownSignalException) continue;
                this.logger.error("exception closing session ({})", (Object)session, (Object)e);
            }
        }
        this.sessions.clear();
    }

    Channel createRabbitChannel(boolean transactional) throws IOException {
        Channel channel = this.rabbitConnection.createChannel();
        if (this.channelsQos != -1) {
            channel.basicQos(this.channelsQos);
        }
        if (transactional) {
            channel.txSelect();
        }
        return channel;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (TopicSession)this.createSession(transacted, acknowledgeMode);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, acknowledgeMode);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    void sessionClose(RMQSession session) throws JMSException {
        this.logger.trace("internal:sessionClose({})", (Object)session);
        if (this.sessions.remove(session)) {
            session.internalClose();
        }
    }

    long getTerminationTimeout() {
        return this.terminationTimeout;
    }

    public String toString() {
        return "RMQConnection{" + "rabbitConnection=" + this.rabbitConnection + ", stopped=" + this.stopped.get() + ", queueBrowserReadMax=" + this.queueBrowserReadMax + '}';
    }

    private class RMQConnectionShutdownListener
    implements ShutdownListener {
        private RMQConnectionShutdownListener() {
        }

        public void shutdownCompleted(ShutdownSignalException cause) {
            if (null == RMQConnection.this.exceptionListener.get() || cause.isInitiatedByApplication()) {
                return;
            }
            ((ExceptionListener)RMQConnection.this.exceptionListener.get()).onException((JMSException)new RMQJMSException(String.format("error in %s, connection closed, with reason %s", cause.getReference(), cause.getReason()), cause));
        }
    }
}

