/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.jms.admin.RMQDestination;
import com.rabbitmq.jms.client.AmqpPropertiesCustomiser;
import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.RMQSession;
import com.rabbitmq.jms.client.message.RMQBytesMessage;
import com.rabbitmq.jms.client.message.RMQTextMessage;
import com.rabbitmq.jms.util.RMQJMSException;
import java.io.IOException;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private final Logger logger = LoggerFactory.getLogger(RMQMessageProducer.class);
    private final RMQDestination destination;
    private final RMQSession session;
    private int deliveryMode = 2;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int priority = 4;
    private long ttl = 0L;
    private final SendingStrategy sendingStrategy;
    private final AmqpPropertiesCustomiser amqpPropertiesCustomiser;
    private static final long MAX_TTL = 0xFFFFFFFFL;

    public RMQMessageProducer(RMQSession session, RMQDestination destination, boolean preferProducerMessageProperty, AmqpPropertiesCustomiser amqpPropertiesCustomiser) {
        this.session = session;
        this.destination = destination;
        this.sendingStrategy = preferProducerMessageProperty ? new PreferMessageProducerPropertySendingStategy() : new PreferMessagePropertySendingStrategy();
        this.amqpPropertiesCustomiser = amqpPropertiesCustomiser == null ? new NoOpAmqpPropertiesCustomiser() : amqpPropertiesCustomiser;
    }

    public RMQMessageProducer(RMQSession session, RMQDestination destination, boolean preferProducerMessageProperty) {
        this(session, destination, preferProducerMessageProperty, new NoOpAmqpPropertiesCustomiser());
    }

    public RMQMessageProducer(RMQSession session, RMQDestination destination) {
        this(session, destination, true);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.priority = defaultPriority;
    }

    public int getPriority() throws JMSException {
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.ttl = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        return this.ttl;
    }

    public Destination getDestination() throws JMSException {
        return this.destination;
    }

    public void close() throws JMSException {
        this.logger.trace("close producer for destination '{}'", (Object)this.destination);
        this.session.removeProducer(this);
    }

    protected void internalClose() {
    }

    public void send(Message message) throws JMSException {
        this.sendingStrategy.send(this.destination, message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendingStrategy.send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.checkUnidentifiedMessageProducer(destination);
        this.sendingStrategy.send(destination, message);
    }

    private void checkUnidentifiedMessageProducer(Destination destination) {
        if (destination != null && this.destination != null) {
            throw new UnsupportedOperationException("Must not supply a destination unless MessageProducer is unidentified.");
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkUnidentifiedMessageProducer(destination);
        this.sendingStrategy.send(destination, message, deliveryMode, priority, timeToLive);
    }

    private void internalSend(RMQDestination destination, Message message, int deliveryMode, int priority, long timeToLiveOrExpiration, MessageExpirationType messageExpirationType) throws JMSException {
        long ttl;
        long expiration;
        this.logger.trace("send/publish message({}) to destination({}) with properties deliveryMode({}), priority({}), timeToLive({})", new Object[]{message, destination, deliveryMode, priority, timeToLiveOrExpiration});
        if (destination == null) {
            destination = this.destination;
        }
        if (destination == null) {
            throw new InvalidDestinationException("No destination supplied, or implied.");
        }
        if (deliveryMode != 2) {
            deliveryMode = 1;
        }
        RMQMessage rmqMessage = RMQMessage.normalise(message);
        long currentTime = System.currentTimeMillis();
        if (messageExpirationType == MessageExpirationType.TTL) {
            expiration = timeToLiveOrExpiration == 0L ? 0L : currentTime + timeToLiveOrExpiration;
            ttl = timeToLiveOrExpiration;
        } else {
            expiration = timeToLiveOrExpiration;
            ttl = timeToLiveOrExpiration - currentTime;
        }
        rmqMessage.setJMSDeliveryMode(deliveryMode);
        rmqMessage.setJMSPriority(priority);
        rmqMessage.setJMSExpiration(expiration);
        rmqMessage.setJMSDestination(destination);
        rmqMessage.setJMSTimestamp(currentTime);
        rmqMessage.generateInternalID();
        if (destination.isAmqp()) {
            this.sendAMQPMessage(destination, rmqMessage, deliveryMode, priority, ttl);
        } else {
            this.sendJMSMessage(destination, rmqMessage, deliveryMode, priority, ttl);
        }
    }

    private void sendAMQPMessage(RMQDestination destination, RMQMessage msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (!destination.amqpWritable()) {
            this.logger.error("Cannot write to AMQP destination {}", (Object)destination);
            throw new RMQJMSException("Cannot write to AMQP destination", new UnsupportedOperationException("MessageProducer.send to undefined AMQP resource"));
        }
        if (msg instanceof RMQBytesMessage || msg instanceof RMQTextMessage) {
            try {
                AMQP.BasicProperties.Builder bob = new AMQP.BasicProperties.Builder();
                bob.contentType("application/octet-stream");
                bob.deliveryMode(Integer.valueOf(RMQMessage.rmqDeliveryMode(deliveryMode)));
                bob.priority(Integer.valueOf(priority));
                bob.expiration(RMQMessageProducer.rmqExpiration(timeToLive));
                bob.headers(msg.toAmqpHeaders());
                bob = this.amqpPropertiesCustomiser.customise(bob, msg);
                byte[] data = msg.toAmqpByteArray();
                this.session.getChannel().basicPublish(destination.getAmqpExchangeName(), destination.getAmqpRoutingKey(), bob.build(), data);
            }
            catch (IOException x) {
                throw new RMQJMSException(x);
            }
        } else {
            this.logger.error("Unsupported message type {} for AMQP destination {}", (Object)msg.getClass().getName(), (Object)destination);
            throw new RMQJMSException("Unsupported message type for AMQP destination", new UnsupportedOperationException("MessageProducer.send to AMQP resource: Message not Text or Bytes"));
        }
    }

    protected void sendJMSMessage(RMQDestination destination, RMQMessage msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.declareDestinationIfNecessary(destination);
        try {
            AMQP.BasicProperties.Builder bob = new AMQP.BasicProperties.Builder();
            bob.contentType("application/octet-stream");
            bob.deliveryMode(Integer.valueOf(RMQMessage.rmqDeliveryMode(deliveryMode)));
            bob.priority(Integer.valueOf(priority));
            bob.expiration(RMQMessageProducer.rmqExpiration(timeToLive));
            bob.headers(msg.toHeaders());
            byte[] data = msg.toByteArray();
            this.session.getChannel().basicPublish(destination.getAmqpExchangeName(), destination.getAmqpRoutingKey(), bob.build(), data);
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
    }

    private static final String rmqExpiration(long ttl) {
        if (ttl == 0L) {
            return null;
        }
        return String.valueOf(ttl < 0L ? 0L : (ttl > 0xFFFFFFFFL ? 0xFFFFFFFFL : ttl));
    }

    public Queue getQueue() throws JMSException {
        return this.destination;
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendingStrategy.send((Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.sendingStrategy.send((Destination)queue, message);
    }

    public Topic getTopic() throws JMSException {
        return this.destination;
    }

    public void publish(Message message) throws JMSException {
        this.sendingStrategy.send((Destination)this.getTopic(), message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendingStrategy.send((Destination)this.getTopic(), message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.sendingStrategy.send((Destination)topic, message);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendingStrategy.send((Destination)topic, message, deliveryMode, priority, timeToLive);
    }

    private static final class NoOpAmqpPropertiesCustomiser
    implements AmqpPropertiesCustomiser {
        private NoOpAmqpPropertiesCustomiser() {
        }

        @Override
        public AMQP.BasicProperties.Builder customise(AMQP.BasicProperties.Builder builder, Message jmsMessage) {
            return builder;
        }
    }

    private static enum MessageExpirationType {
        TTL,
        EXPIRATION;

    }

    private class PreferMessagePropertySendingStrategy
    implements SendingStrategy {
        private PreferMessagePropertySendingStrategy() {
        }

        @Override
        public void send(Destination destination, Message message) throws JMSException {
            RMQMessageProducer.this.internalSend((RMQDestination)destination, message, message.propertyExists("rmq.jms.message.delivery.mode") ? message.getJMSDeliveryMode() : RMQMessageProducer.this.getDeliveryMode(), message.propertyExists("rmq.jms.message.priority") ? message.getJMSPriority() : RMQMessageProducer.this.getPriority(), message.propertyExists("rmq.jms.message.expiration") ? message.getJMSExpiration() : RMQMessageProducer.this.getTimeToLive(), message.propertyExists("rmq.jms.message.expiration") ? MessageExpirationType.EXPIRATION : MessageExpirationType.TTL);
        }

        @Override
        public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
            RMQMessageProducer.this.internalSend((RMQDestination)destination, message, deliveryMode, priority, timeToLive, MessageExpirationType.TTL);
        }
    }

    private class PreferMessageProducerPropertySendingStategy
    implements SendingStrategy {
        private PreferMessageProducerPropertySendingStategy() {
        }

        @Override
        public void send(Destination destination, Message message) throws JMSException {
            RMQMessageProducer.this.internalSend((RMQDestination)destination, message, RMQMessageProducer.this.getDeliveryMode(), RMQMessageProducer.this.getPriority(), RMQMessageProducer.this.getTimeToLive(), MessageExpirationType.TTL);
        }

        @Override
        public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
            RMQMessageProducer.this.internalSend((RMQDestination)destination, message, deliveryMode, priority, timeToLive, MessageExpirationType.TTL);
        }
    }

    private static interface SendingStrategy {
        public void send(Destination var1, Message var2) throws JMSException;

        public void send(Destination var1, Message var2, int var3, int var4, long var5) throws JMSException;
    }
}

