/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.ParseTree;
import com.rabbitmq.jms.parse.ParseTreeTraverser;
import com.rabbitmq.jms.parse.sql.SqlExpressionType;
import com.rabbitmq.jms.parse.sql.SqlTreeNode;
import com.rabbitmq.jms.parse.sql.SqlTypeSetterVisitor;
import java.util.Collections;
import java.util.Map;

public abstract class SqlTypeChecker {
    private SqlTypeChecker() {
    }

    public static SqlExpressionType deriveExpressionType(ParseTree<SqlTreeNode> tree, Map<String, SqlExpressionType> identifierType) {
        if (tree == null) {
            return SqlExpressionType.NOT_SET;
        }
        ParseTreeTraverser.traverse(tree, new SqlTypeSetterVisitor(identifierType));
        return tree.getNode().getExpValue().getType();
    }

    public static SqlExpressionType deriveExpressionType(ParseTree<SqlTreeNode> tree) {
        return SqlTypeChecker.deriveExpressionType(tree, Collections.emptyMap());
    }
}

