/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.jms.client.ConfirmListener;
import com.rabbitmq.jms.client.PublisherConfirmContext;
import com.rabbitmq.jms.client.PublishingListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.jms.CompletionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PublisherConfirmsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublisherConfirmsUtils.class);

    PublisherConfirmsUtils() {
    }

    static PublishingListener configurePublisherConfirmsSupport(Channel channel, final ConfirmListener confirmListener) {
        final ConcurrentHashMap outstandingConfirms = new ConcurrentHashMap();
        final AtomicLong multipleLowerBound = new AtomicLong(1L);
        PublishingListener publishingListener = (message, completionListener, sequenceNumber) -> outstandingConfirms.put(sequenceNumber, new OutboundMessageContext(message, completionListener));
        channel.addConfirmListener(new com.rabbitmq.client.ConfirmListener(){

            public void handleAck(long deliveryTag, boolean multiple) {
                PublisherConfirmsUtils.cleanPublisherConfirmsCorrelation(outstandingConfirms, multipleLowerBound, deliveryTag, multiple, context -> {
                    PublisherConfirmsUtils.executeSafely(() -> ((OutboundMessageContext)context).completionListener.onCompletion(((OutboundMessageContext)context).message), "CompletionListener");
                    PublisherConfirmsUtils.executeSafely(() -> confirmListener.handle(new PublisherConfirmContext(((OutboundMessageContext)context).message, true)), "ConfirmListener");
                });
            }

            public void handleNack(long deliveryTag, boolean multiple) {
                PublisherConfirmsUtils.cleanPublisherConfirmsCorrelation(outstandingConfirms, multipleLowerBound, deliveryTag, multiple, context -> {
                    PublisherConfirmsUtils.executeSafely(() -> ((OutboundMessageContext)context).completionListener.onException(((OutboundMessageContext)context).message, (Exception)((Object)new JMSException("Outbound message was negatively acknowledged"))), "CompletionListener");
                    PublisherConfirmsUtils.executeSafely(() -> confirmListener.handle(new PublisherConfirmContext(((OutboundMessageContext)context).message, false)), "ConfirmListener");
                });
            }
        });
        return publishingListener;
    }

    private static void executeSafely(VoidCallable callable, String object) {
        try {
            callable.call();
        }
        catch (Exception e) {
            LOGGER.warn("Error while executing {}: {}", (Object)object, (Object)e.getMessage());
        }
    }

    private static void cleanPublisherConfirmsCorrelation(Map<Long, OutboundMessageContext> outstandingConfirms, AtomicLong multipleLowerBound, long deliveryTag, boolean multiple, Consumer<OutboundMessageContext> messageConsumer) {
        Long lowerBound = multipleLowerBound.get();
        if (multiple) {
            for (long i = lowerBound.longValue(); i <= deliveryTag; ++i) {
                OutboundMessageContext context = outstandingConfirms.remove(i);
                if (context == null) continue;
                messageConsumer.accept(context);
            }
        } else {
            OutboundMessageContext context = outstandingConfirms.remove(deliveryTag);
            if (context != null) {
                messageConsumer.accept(context);
            }
            if (deliveryTag == lowerBound + 1L) {
                multipleLowerBound.compareAndSet(lowerBound, deliveryTag);
            }
        }
    }

    @FunctionalInterface
    private static interface VoidCallable {
        public void call() throws Exception;
    }

    private static class OutboundMessageContext {
        private final Message message;
        private final CompletionListener completionListener;

        private OutboundMessageContext(Message message, CompletionListener completionListener) {
            this.message = message;
            this.completionListener = completionListener;
        }
    }
}

