/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.jms.admin.RMQDestination;
import com.rabbitmq.jms.client.RMQNullMessage;
import com.rabbitmq.jms.client.RMQSession;
import com.rabbitmq.jms.client.ReceivingContext;
import com.rabbitmq.jms.client.ReceivingContextConsumer;
import com.rabbitmq.jms.client.Utils;
import com.rabbitmq.jms.client.message.RMQBytesMessage;
import com.rabbitmq.jms.client.message.RMQMapMessage;
import com.rabbitmq.jms.client.message.RMQObjectMessage;
import com.rabbitmq.jms.client.message.RMQStreamMessage;
import com.rabbitmq.jms.client.message.RMQTextMessage;
import com.rabbitmq.jms.util.HexDisplay;
import com.rabbitmq.jms.util.IteratorEnum;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.Util;
import com.rabbitmq.jms.util.WhiteListObjectInputStream;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RMQMessage
implements Message,
Cloneable {
    protected final Logger logger = LoggerFactory.getLogger(RMQMessage.class);
    private static final String DIRECT_REPLY_TO = "amq.rabbitmq.reply-to";
    static final String JMS_TYPE_HEADER = "JMSType";
    static final String TEXT_MESSAGE_HEADER_VALUE = "TextMessage";
    protected static final String NOT_READABLE = "Message not readable";
    protected static final String NOT_WRITEABLE = "Message not writeable";
    protected static final String UNABLE_TO_CAST = "Unable to cast the object, %s, into the specified type %s";
    protected static final String MSG_EOF = "Message EOF";
    private static final String[] RESERVED_NAMES = new String[]{"NULL", "TRUE", "FALSE", "NOT", "AND", "OR", "BETWEEN", "LIKE", "IN", "IS", "ESCAPE"};
    private static final char[] INVALID_STARTS_WITH = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '+', '\'', '\"', '.'};
    private static final char[] MAY_NOT_CONTAIN = new char[]{'\'', '\"'};
    protected static final int DEFAULT_MESSAGE_BODY_SIZE = Integer.getInteger("com.rabbitmq.jms.client.message.size", 512);
    private static final String PREFIX = "rmq.";
    private static final String JMS_MESSAGE_ID = "rmq.jms.message.id";
    private static final String JMS_MESSAGE_TIMESTAMP = "rmq.jms.message.timestamp";
    static final String JMS_MESSAGE_CORR_ID = "rmq.jms.message.correlation.id";
    static final String JMS_MESSAGE_REPLY_TO = "rmq.jms.message.reply.to";
    private static final String JMS_MESSAGE_DESTINATION = "rmq.jms.message.destination";
    private static final String JMS_MESSAGE_REDELIVERED = "rmq.jms.message.redelivered";
    static final String JMS_MESSAGE_TYPE = "rmq.jms.message.type";
    static final String JMS_MESSAGE_DELIVERY_MODE = "rmq.jms.message.delivery.mode";
    static final String JMS_MESSAGE_EXPIRATION = "rmq.jms.message.expiration";
    static final String JMS_MESSAGE_PRIORITY = "rmq.jms.message.priority";
    static final String JMS_MESSAGE_DELIVERY_TIME = "rmq.jms.message.delivery.type";
    private static final String JMS_X_DELIVERY_COUNT = "JMSXDeliveryCount";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final Map<String, Serializable> rmqProperties = new HashMap<String, Serializable>();
    private final Map<String, Serializable> userJmsProperties = new HashMap<String, Serializable>();
    private volatile String internalMessageID = null;
    private volatile boolean readonlyProperties = false;
    private volatile boolean readonlyBody = false;
    private long rabbitDeliveryTag = -1L;
    private volatile transient RMQSession session = null;

    protected void loggerDebugByteArray(String format, byte[] buffer, Object arg) {
        if (this.logger.isDebugEnabled()) {
            StringBuilder bufferOutput = new StringBuilder("Byte array, length ").append(buffer.length).append(" :\n");
            HexDisplay.decodeByteArrayIntoStringBuilder(buffer, bufferOutput);
            this.logger.debug(format, (Object)bufferOutput.append("end of byte array, length ").append(buffer.length).append('.'), arg);
        }
    }

    protected boolean isReadonlyBody() {
        return this.readonlyBody;
    }

    protected boolean isReadOnlyProperties() {
        return this.readonlyProperties;
    }

    protected void setReadonly(boolean readonly) {
        this.readonlyBody = readonly;
        this.readonlyProperties = readonly;
    }

    protected void setReadOnlyBody(boolean readonly) {
        this.readonlyBody = readonly;
    }

    protected void setReadOnlyProperties(boolean readonly) {
        this.readonlyProperties = readonly;
    }

    public long getRabbitDeliveryTag() {
        return this.rabbitDeliveryTag;
    }

    protected void setRabbitDeliveryTag(long rabbitDeliveryTag) {
        this.rabbitDeliveryTag = rabbitDeliveryTag;
    }

    public RMQSession getSession() {
        return this.session;
    }

    protected void setSession(RMQSession session) {
        this.session = session;
    }

    public String getJMSMessageID() throws JMSException {
        return this.getStringProperty(JMS_MESSAGE_ID);
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.setStringProperty(JMS_MESSAGE_ID, id);
    }

    public long getJMSTimestamp() throws JMSException {
        Object timestamp = this.getObjectProperty(JMS_MESSAGE_TIMESTAMP);
        if (timestamp == null) {
            return 0L;
        }
        return Utils.convertToLong(timestamp);
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.setLongProperty(JMS_MESSAGE_TIMESTAMP, timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        String id = this.getStringProperty(JMS_MESSAGE_CORR_ID);
        if (id != null) {
            return id.getBytes(RMQMessage.getCharset());
        }
        return null;
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        String id = correlationID != null ? new String(correlationID, RMQMessage.getCharset()) : null;
        this.setStringProperty(JMS_MESSAGE_CORR_ID, id);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.setStringProperty(JMS_MESSAGE_CORR_ID, correlationID);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.getStringProperty(JMS_MESSAGE_CORR_ID);
    }

    public Destination getJMSReplyTo() throws JMSException {
        return (Destination)this.getObjectProperty(JMS_MESSAGE_REPLY_TO);
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.setObjectProperty(JMS_MESSAGE_REPLY_TO, replyTo);
    }

    public Destination getJMSDestination() throws JMSException {
        return (Destination)this.getObjectProperty(JMS_MESSAGE_DESTINATION);
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.setObjectProperty(JMS_MESSAGE_DESTINATION, destination);
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.getIntProperty(JMS_MESSAGE_DELIVERY_MODE);
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.setIntProperty(JMS_MESSAGE_DELIVERY_MODE, deliveryMode);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.getBooleanProperty(JMS_MESSAGE_REDELIVERED);
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.setBooleanProperty(JMS_MESSAGE_REDELIVERED, redelivered);
    }

    public String getJMSType() throws JMSException {
        return this.getStringProperty(JMS_MESSAGE_TYPE);
    }

    public void setJMSType(String type) throws JMSException {
        this.setStringProperty(JMS_MESSAGE_TYPE, type);
    }

    public long getJMSExpiration() throws JMSException {
        return this.getLongProperty(JMS_MESSAGE_EXPIRATION);
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.setLongProperty(JMS_MESSAGE_EXPIRATION, expiration);
    }

    public int getJMSPriority() throws JMSException {
        return this.getIntProperty(JMS_MESSAGE_PRIORITY);
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.setIntProperty(JMS_MESSAGE_PRIORITY, priority);
    }

    public final void clearProperties() throws JMSException {
        this.userJmsProperties.clear();
        this.setReadOnlyProperties(false);
    }

    public boolean propertyExists(String name) {
        return this.userJmsProperties.containsKey(name) || this.rmqProperties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return Utils.getBooleanProperty(this.propertiesFor(name), name);
    }

    public byte getByteProperty(String name) throws JMSException {
        return Utils.getByteProperty(this.propertiesFor(name), name);
    }

    public short getShortProperty(String name) throws JMSException {
        return Utils.getShortProperty(this.propertiesFor(name), name);
    }

    public int getIntProperty(String name) throws JMSException {
        return Utils.getIntProperty(this.propertiesFor(name), name);
    }

    public long getLongProperty(String name) throws JMSException {
        return Utils.getLongProperty(this.propertiesFor(name), name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return Utils.getFloatProperty(this.propertiesFor(name), name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return Utils.getDoubleProperty(this.propertiesFor(name), name);
    }

    public String getStringProperty(String name) throws JMSException {
        return Utils.getStringProperty(this.propertiesFor(name), name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this.propertiesFor(name).get(name);
    }

    private Map<String, Serializable> propertiesFor(String name) {
        return name.startsWith(PREFIX) ? this.rmqProperties : this.userJmsProperties;
    }

    public Enumeration<?> getPropertyNames() throws JMSException {
        return new IteratorEnum<String>(this.userJmsProperties.keySet().iterator());
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setObjectProperty(name, Float.valueOf(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setObjectProperty(name, value);
    }

    private void checkName(String name) throws JMSException {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid identifier:null");
        }
        char c = name.charAt(0);
        for (char aINVALID_STARTS_WITH : INVALID_STARTS_WITH) {
            if (c != aINVALID_STARTS_WITH) continue;
            throw new JMSException(String.format("Identifier may not start with character [%s]", Character.valueOf(c)));
        }
        for (char aMAY_NOT_CONTAIN : MAY_NOT_CONTAIN) {
            if (name.indexOf(aMAY_NOT_CONTAIN) < 0) continue;
            throw new JMSException(String.format("Identifier may not contain character [%s]", Character.valueOf(aMAY_NOT_CONTAIN)));
        }
        for (String RESERVED_NAME : RESERVED_NAMES) {
            if (!name.equalsIgnoreCase(RESERVED_NAME)) continue;
            throw new JMSException(String.format("Invalid identifier [%s]", RESERVED_NAME));
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        block13: {
            try {
                if ("JMSXGroupSeq".equals(name)) {
                    if (!(value instanceof Integer)) {
                        throw new MessageFormatException(String.format("Property [%s] can only be of type int", "JMSXGroupSeq"));
                    }
                    int val = (Integer)value;
                    if (val <= 0) {
                        throw new JMSException(String.format("Property [%s] must be >0", "JMSXGroupSeq"));
                    }
                } else if ("JMSXGroupID".equals(name) && value != null && !(value instanceof String)) {
                    throw new MessageFormatException(String.format("Property [%s] can only be of type String", "JMSXGroupID"));
                }
                if (name != null && name.startsWith(PREFIX)) {
                    if (value == null) {
                        this.rmqProperties.remove(name);
                    } else {
                        this.rmqProperties.put(name, (Serializable)value);
                    }
                    break block13;
                }
                if (this.isReadOnlyProperties()) {
                    throw new MessageNotWriteableException(NOT_WRITEABLE);
                }
                this.checkName(name);
                if (value == null) {
                    this.userJmsProperties.remove(name);
                    break block13;
                }
                if (this.validPropertyValueType(value)) {
                    this.userJmsProperties.put(name, (Serializable)value);
                    break block13;
                }
                throw new MessageFormatException(String.format("Property [%s] has incorrect value type.", name));
            }
            catch (ClassCastException x) {
                throw new RMQJMSException("Property value not serializable.", x);
            }
        }
    }

    private boolean validPropertyValueType(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double;
    }

    public void acknowledge() throws JMSException {
        this.getSession().acknowledgeMessage(this);
    }

    public final void clearBody() throws JMSException {
        this.setReadOnlyBody(false);
        this.clearBodyInternal();
    }

    protected abstract void clearBodyInternal() throws JMSException;

    static Charset getCharset() {
        return CHARSET;
    }

    protected abstract void writeBody(ObjectOutput var1, ByteArrayOutputStream var2) throws IOException;

    protected abstract void writeAmqpBody(ByteArrayOutputStream var1) throws IOException;

    protected abstract void readBody(ObjectInput var1, ByteArrayInputStream var2) throws IOException, ClassNotFoundException;

    protected abstract void readAmqpBody(byte[] var1);

    Map<String, Object> toHeaders() throws IOException, JMSException {
        HashMap<String, Object> hdrs = new HashMap<String, Object>();
        for (Map.Entry<String, Serializable> e : this.userJmsProperties.entrySet()) {
            RMQMessage.putIfNotNull(hdrs, e.getKey(), e.getValue());
        }
        hdrs.put("JMSDeliveryMode", this.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT");
        RMQMessage.putIfNotNull(hdrs, "JMSMessageID", this.getJMSMessageID());
        hdrs.put("JMSTimestamp", this.getJMSTimestamp());
        hdrs.put("JMSPriority", this.getJMSPriority());
        RMQMessage.putIfNotNull(hdrs, "JMSCorrelationID", this.getJMSCorrelationID());
        RMQMessage.putIfNotNull(hdrs, JMS_TYPE_HEADER, this.getJMSType());
        return hdrs;
    }

    static RMQMessage convertMessage(RMQSession session, RMQDestination dest, GetResponse response, ReceivingContextConsumer receivingContextConsumer) throws JMSException {
        if (response == null) {
            return null;
        }
        if (dest.isAmqp()) {
            return RMQMessage.convertAmqpMessage(session, dest, response, receivingContextConsumer);
        }
        return RMQMessage.convertJmsMessage(session, response, receivingContextConsumer);
    }

    static RMQMessage convertJmsMessage(RMQSession session, GetResponse response, ReceivingContextConsumer receivingContextConsumer) throws JMSException {
        RMQMessage message = RMQMessage.fromMessage(response.getBody(), session.getTrustedPackages());
        message.setSession(session);
        message = RMQMessage.handleJmsRedeliveredAndDeliveryCount(response, message);
        message.setRabbitDeliveryTag(response.getEnvelope().getDeliveryTag());
        message.setReadonly(true);
        RMQMessage.maybeSetupDirectReplyTo(message, response.getProps().getReplyTo());
        receivingContextConsumer.accept(new ReceivingContext(message));
        return message;
    }

    private static RMQMessage convertAmqpMessage(RMQSession session, RMQDestination dest, GetResponse response, ReceivingContextConsumer receivingContextConsumer) throws JMSException {
        try {
            AMQP.BasicProperties props = response.getProps();
            RMQMessage message = RMQMessage.isAmqpTextMessage(props.getHeaders()) ? new RMQTextMessage() : new RMQBytesMessage();
            message = RMQMessage.fromAmqpMessage(response.getBody(), message);
            message.setSession(session);
            message = RMQMessage.handleJmsRedeliveredAndDeliveryCount(response, message);
            message.setRabbitDeliveryTag(response.getEnvelope().getDeliveryTag());
            message.setJMSDestination(dest);
            message.setJMSPropertiesFromAmqpProperties((BasicProperties)props);
            message.setReadonly(true);
            RMQMessage.maybeSetupDirectReplyTo(message, response.getProps().getReplyTo());
            receivingContextConsumer.accept(new ReceivingContext(message));
            return message;
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
    }

    private static RMQMessage handleJmsRedeliveredAndDeliveryCount(GetResponse response, RMQMessage message) throws JMSException {
        boolean redelivered = response.getEnvelope().isRedeliver();
        message.setJMSRedelivered(redelivered);
        if (redelivered) {
            Number deliveryCount = (Number)response.getProps().getHeaders().get("x-delivery-count");
            if (deliveryCount == null) {
                message.setIntProperty(JMS_X_DELIVERY_COUNT, 2);
            } else {
                message.setIntProperty(JMS_X_DELIVERY_COUNT, deliveryCount.intValue() + 1);
            }
        } else {
            message.setIntProperty(JMS_X_DELIVERY_COUNT, 1);
        }
        return message;
    }

    private static void maybeSetupDirectReplyTo(RMQMessage message, String replyTo) throws JMSException {
        if (replyTo != null && replyTo.startsWith(DIRECT_REPLY_TO)) {
            RMQDestination replyToDestination = new RMQDestination(DIRECT_REPLY_TO, "", replyTo, replyTo);
            message.setJMSReplyTo(replyToDestination);
        }
    }

    public static void doNotDeclareReplyToDestination(Message message) throws JMSException {
        if (message instanceof RMQMessage && message.getJMSReplyTo() != null && message.getJMSReplyTo() instanceof RMQDestination) {
            ((RMQDestination)message.getJMSReplyTo()).setDeclared(true);
        }
    }

    Map<String, Object> toAmqpHeaders() throws IOException, JMSException {
        HashMap<String, Object> hdrs = new HashMap<String, Object>();
        for (Map.Entry<String, Serializable> e : this.userJmsProperties.entrySet()) {
            RMQMessage.putIfNotNullAndAmqpType(hdrs, e.getKey(), e.getValue());
        }
        hdrs.put("JMSDeliveryMode", this.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT");
        RMQMessage.putIfNotNull(hdrs, "JMSMessageID", this.getJMSMessageID());
        hdrs.put("JMSTimestamp", this.getJMSTimestamp());
        hdrs.put("JMSPriority", this.getJMSPriority());
        RMQMessage.putIfNotNull(hdrs, "JMSCorrelationID", this.getJMSCorrelationID());
        RMQMessage.putIfNotNull(hdrs, JMS_TYPE_HEADER, this.getJMSType());
        return hdrs;
    }

    private static void putIfNotNullAndAmqpType(Map<String, Object> hdrs, String key, Object val) {
        if (val != null && (val instanceof String || val instanceof Integer || val instanceof Float || val instanceof Double || val instanceof Long || val instanceof Short || val instanceof Byte || val instanceof Boolean)) {
            hdrs.put(key, val);
        }
    }

    private static void putIfNotNull(Map<String, Object> hdrs, String key, Object val) {
        if (val != null) {
            hdrs.put(key, val);
        }
    }

    byte[] toAmqpByteArray() throws IOException, JMSException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(DEFAULT_MESSAGE_BODY_SIZE);
        this.writeAmqpBody(bout);
        bout.flush();
        return bout.toByteArray();
    }

    byte[] toByteArray() throws IOException, JMSException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(DEFAULT_MESSAGE_BODY_SIZE);
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeUTF(this.getClass().getName());
        out.writeUTF(this.internalMessageID);
        out.writeInt(this.rmqProperties.size());
        for (Map.Entry<String, Serializable> entry : this.rmqProperties.entrySet()) {
            out.writeUTF(entry.getKey());
            RMQMessage.writePrimitive(entry.getValue(), out, true);
        }
        out.writeInt(this.userJmsProperties.size());
        for (Map.Entry<String, Serializable> entry : this.userJmsProperties.entrySet()) {
            out.writeUTF(entry.getKey());
            RMQMessage.writePrimitive(entry.getValue(), out, true);
        }
        out.flush();
        this.writeBody(out, bout);
        out.flush();
        return bout.toByteArray();
    }

    static RMQMessage fromMessage(byte[] b, List<String> trustedPackages) throws RMQJMSException {
        try {
            Object value;
            String name;
            int i;
            ByteArrayInputStream bin = new ByteArrayInputStream(b);
            WhiteListObjectInputStream in = new WhiteListObjectInputStream(bin, trustedPackages);
            String clazz = in.readUTF();
            RMQMessage msg = RMQMessage.instantiateRmqMessage(clazz, trustedPackages);
            msg.internalMessageID = in.readUTF();
            int propsize = in.readInt();
            for (i = 0; i < propsize; ++i) {
                name = in.readUTF();
                value = RMQMessage.readPrimitive(in);
                msg.rmqProperties.put(name, (Serializable)value);
            }
            propsize = in.readInt();
            for (i = 0; i < propsize; ++i) {
                name = in.readUTF();
                value = RMQMessage.readPrimitive(in);
                msg.userJmsProperties.put(name, (Serializable)value);
            }
            msg.readBody(in, bin);
            return msg;
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
        catch (ClassNotFoundException x) {
            throw new RMQJMSException(x);
        }
    }

    private static RMQMessage instantiateRmqMessage(String messageClass, List<String> trustedPackages) throws RMQJMSException {
        if (RMQMessage.isRmqObjectMessageClass(messageClass)) {
            return RMQMessage.instantiateRmqObjectMessageWithTrustedPackages(trustedPackages);
        }
        if (RMQMessage.isRmqStreamMessageClass(messageClass)) {
            return RMQMessage.instantiateRmqStreamMessageWithTrustedPackages(trustedPackages);
        }
        try {
            return (RMQMessage)Class.forName(messageClass, true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RMQJMSException(e);
        }
        catch (IllegalAccessException e) {
            throw new RMQJMSException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RMQJMSException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RMQJMSException(e);
        }
        catch (InvocationTargetException e) {
            throw new RMQJMSException(e);
        }
    }

    private static boolean isRmqObjectMessageClass(String clazz) {
        return RMQObjectMessage.class.getName().equals(clazz);
    }

    private static boolean isRmqStreamMessageClass(String clazz) {
        return RMQStreamMessage.class.getName().equals(clazz);
    }

    private static RMQObjectMessage instantiateRmqObjectMessageWithTrustedPackages(List<String> trustedPackages) throws RMQJMSException {
        return (RMQObjectMessage)RMQMessage.instantiateRmqMessageWithTrustedPackages(RMQObjectMessage.class.getName(), trustedPackages);
    }

    private static RMQStreamMessage instantiateRmqStreamMessageWithTrustedPackages(List<String> trustedPackages) throws RMQJMSException {
        return (RMQStreamMessage)RMQMessage.instantiateRmqMessageWithTrustedPackages(RMQStreamMessage.class.getName(), trustedPackages);
    }

    private static RMQMessage instantiateRmqMessageWithTrustedPackages(String messageClazz, List<String> trustedPackages) throws RMQJMSException {
        try {
            Class<?> messageClass = Class.forName(messageClazz, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = messageClass.getConstructor(List.class);
            return (RMQMessage)constructor.newInstance(trustedPackages);
        }
        catch (NoSuchMethodException e) {
            throw new RMQJMSException(e);
        }
        catch (InvocationTargetException e) {
            throw new RMQJMSException(e);
        }
        catch (IllegalAccessException e) {
            throw new RMQJMSException(e);
        }
        catch (InstantiationException e) {
            throw new RMQJMSException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RMQJMSException(e);
        }
    }

    private static RMQMessage fromAmqpMessage(byte[] b, RMQMessage msg) throws IOException {
        msg.readAmqpBody(b);
        return msg;
    }

    static int rmqDeliveryMode(int deliveryMode) {
        return deliveryMode == 2 ? 2 : 1;
    }

    private static int jmsDeliveryMode(Integer rmqDeliveryMode) {
        return rmqDeliveryMode != null && rmqDeliveryMode == 2 ? 2 : 1;
    }

    private static long jmsExpiration(String rmqExpiration, Date da) {
        if (null == da) {
            da = new Date();
        }
        if (null == rmqExpiration) {
            return 0L;
        }
        try {
            return da.getTime() + Long.valueOf(rmqExpiration);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalMessageID == null ? 0 : this.internalMessageID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RMQMessage other = (RMQMessage)obj;
        return !(this.internalMessageID == null ? other.internalMessageID != null : !this.internalMessageID.equals(other.internalMessageID));
    }

    public String getInternalID() {
        return this.internalMessageID;
    }

    void generateInternalID() {
        this.internalMessageID = Util.generateUUID("");
        this.rmqProperties.put(JMS_MESSAGE_ID, (Serializable)((Object)("ID:" + this.internalMessageID)));
    }

    protected static void writePrimitive(Object s, ObjectOutput out) throws IOException, MessageFormatException {
        RMQMessage.writePrimitive(s, out, false);
    }

    protected static void writePrimitive(Object s, ObjectOutput out, boolean allowSerializable) throws IOException, MessageFormatException {
        if (s == null) {
            out.writeByte(-1);
        } else if (s instanceof Boolean) {
            out.writeByte(1);
            out.writeBoolean((Boolean)s);
        } else if (s instanceof Byte) {
            out.writeByte(2);
            out.writeByte(((Byte)s).byteValue());
        } else if (s instanceof Short) {
            out.writeByte(3);
            out.writeShort(((Short)s).shortValue());
        } else if (s instanceof Integer) {
            out.writeByte(4);
            out.writeInt((Integer)s);
        } else if (s instanceof Long) {
            out.writeByte(5);
            out.writeLong((Long)s);
        } else if (s instanceof Float) {
            out.writeByte(6);
            out.writeFloat(((Float)s).floatValue());
        } else if (s instanceof Double) {
            out.writeByte(7);
            out.writeDouble((Double)s);
        } else if (s instanceof String) {
            out.writeByte(8);
            out.writeUTF((String)s);
        } else if (s instanceof Character) {
            out.writeByte(9);
            out.writeChar(((Character)s).charValue());
        } else if (s instanceof byte[]) {
            out.writeByte(10);
            out.writeInt(((byte[])s).length);
            out.write((byte[])s);
        } else if (allowSerializable && s instanceof Serializable) {
            out.writeByte(127);
            out.writeObject(s);
        } else {
            throw new MessageFormatException(s + " is not a recognized primitive type.");
        }
    }

    protected static Object readPrimitive(ObjectInput in) throws IOException, ClassNotFoundException {
        byte b = in.readByte();
        switch (b) {
            case -1: {
                return null;
            }
            case 1: {
                return in.readBoolean();
            }
            case 2: {
                return in.readByte();
            }
            case 3: {
                return in.readShort();
            }
            case 4: {
                return in.readInt();
            }
            case 5: {
                return in.readLong();
            }
            case 6: {
                return Float.valueOf(in.readFloat());
            }
            case 7: {
                return in.readDouble();
            }
            case 8: {
                return in.readUTF();
            }
            case 9: {
                return Character.valueOf(in.readChar());
            }
            case 10: {
                int length = in.readInt();
                byte[] buf = new byte[length];
                in.read(buf);
                return buf;
            }
        }
        return in.readObject();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void setJMSPropertiesFromAmqpProperties(BasicProperties props) throws JMSException {
        String ci;
        String mi;
        this.setJMSDeliveryMode(RMQMessage.jmsDeliveryMode(props.getDeliveryMode()));
        Date da = props.getTimestamp();
        if (null != da) {
            this.setJMSTimestamp(da.getTime() / 1000L);
        }
        String ex = props.getExpiration();
        this.setJMSExpiration(RMQMessage.jmsExpiration(ex, da));
        Integer pr = props.getPriority();
        if (null != pr) {
            this.setJMSPriority(pr);
        }
        if (null != (mi = props.getMessageId())) {
            this.setJMSMessageID(mi);
        }
        if (null != (ci = props.getCorrelationId())) {
            this.setJMSCorrelationID(ci);
        }
        this.setJMSType(RMQMessage.isAmqpTextMessage(props.getHeaders()) ? TEXT_MESSAGE_HEADER_VALUE : "BytesMessage");
        Map hdrs = props.getHeaders();
        if (hdrs != null) {
            for (Map.Entry e : hdrs.entrySet()) {
                String key = (String)e.getKey();
                Object val = e.getValue();
                if (key.equals("JMSExpiration")) {
                    this.setJMSExpiration(RMQMessage.objectToLong(val, 0L));
                    continue;
                }
                if (key.equals("JMSPriority")) {
                    this.setJMSPriority(RMQMessage.objectToInt(val, 4));
                    continue;
                }
                if (key.equals("JMSTimestamp")) {
                    this.setJMSTimestamp(RMQMessage.objectToLong(val, 0L));
                    continue;
                }
                if (key.equals("JMSMessageID")) {
                    this.setJMSMessageID(val.toString());
                    continue;
                }
                if (key.equals("JMSCorrelationID")) {
                    this.setJMSCorrelationID(val.toString());
                    continue;
                }
                if (key.equals(JMS_TYPE_HEADER)) {
                    this.setJMSType(val.toString());
                    continue;
                }
                if (key.startsWith(PREFIX) || key.startsWith("JMS")) continue;
                this.userJmsProperties.put(key, (Serializable)((Object)val.toString()));
            }
        }
    }

    private static boolean isAmqpTextMessage(Map<String, Object> hdrs) {
        boolean isTextMessage = false;
        if (hdrs != null) {
            Object headerJMSType = hdrs.get(JMS_TYPE_HEADER);
            isTextMessage = headerJMSType != null && TEXT_MESSAGE_HEADER_VALUE.equals(headerJMSType.toString());
        }
        return isTextMessage;
    }

    private static long objectToLong(Object val, long dft) {
        if (val == null) {
            return dft;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            if (val instanceof CharSequence) {
                return Long.valueOf(val.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dft;
    }

    private static int objectToInt(Object val, int dft) {
        if (val == null) {
            return dft;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            if (val instanceof CharSequence) {
                return Integer.parseInt(val.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return dft;
    }

    static RMQMessage normalise(Message msg) throws JMSException {
        if (msg instanceof RMQMessage) {
            return (RMQMessage)msg;
        }
        if (msg instanceof BytesMessage) {
            return RMQBytesMessage.recreate((BytesMessage)msg);
        }
        if (msg instanceof MapMessage) {
            return RMQMapMessage.recreate((MapMessage)msg);
        }
        if (msg instanceof ObjectMessage) {
            return RMQObjectMessage.recreate((ObjectMessage)msg);
        }
        if (msg instanceof StreamMessage) {
            return RMQStreamMessage.recreate((StreamMessage)msg);
        }
        if (msg instanceof TextMessage) {
            return RMQTextMessage.recreate((TextMessage)msg);
        }
        return RMQNullMessage.recreate(msg);
    }

    protected static void copyAttributes(RMQMessage rmqMessage, Message message) throws JMSException {
        try {
            rmqMessage.setJMSCorrelationID(message.getJMSCorrelationID());
            rmqMessage.setJMSType(message.getJMSType());
            RMQMessage.copyProperties(rmqMessage, message);
        }
        catch (Exception e) {
            throw new RMQJMSException("Error converting Message to RMQMessage.", e);
        }
    }

    private static void copyProperties(RMQMessage rmqMsg, Message msg) throws JMSException {
        Enumeration propNames = msg.getPropertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            rmqMsg.setObjectProperty(name, msg.getObjectProperty(name));
        }
    }

    public long getJMSDeliveryTime() throws JMSException {
        Object deliveryTimeMs = this.getObjectProperty(JMS_MESSAGE_DELIVERY_TIME);
        if (deliveryTimeMs == null) {
            return 0L;
        }
        return Utils.convertToLong(deliveryTimeMs);
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.setObjectProperty(JMS_MESSAGE_DELIVERY_TIME, deliveryTime);
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        if (this.isBodyAssignableTo(c)) {
            return this.doGetBody(c);
        }
        throw new MessageFormatException("Message body is assignable to " + c);
    }

    protected abstract <T> T doGetBody(Class<T> var1) throws JMSException;
}

