/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.jms.admin.RMQDestination;
import com.rabbitmq.jms.client.BrowsingMessageQueue;
import com.rabbitmq.jms.client.DefaultReplyToStrategy;
import com.rabbitmq.jms.client.DelayedMessageService;
import com.rabbitmq.jms.client.DeliveryExecutor;
import com.rabbitmq.jms.client.GenericVersion;
import com.rabbitmq.jms.client.PublisherConfirmsUtils;
import com.rabbitmq.jms.client.PublishingListener;
import com.rabbitmq.jms.client.RMQConnection;
import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.RMQMessageConsumer;
import com.rabbitmq.jms.client.RMQMessageProducer;
import com.rabbitmq.jms.client.ReceivingContextConsumer;
import com.rabbitmq.jms.client.ReplyToStrategy;
import com.rabbitmq.jms.client.SendingContextConsumer;
import com.rabbitmq.jms.client.SessionParams;
import com.rabbitmq.jms.client.Subscription;
import com.rabbitmq.jms.client.Subscriptions;
import com.rabbitmq.jms.client.Utils;
import com.rabbitmq.jms.client.message.RMQBytesMessage;
import com.rabbitmq.jms.client.message.RMQMapMessage;
import com.rabbitmq.jms.client.message.RMQObjectMessage;
import com.rabbitmq.jms.client.message.RMQStreamMessage;
import com.rabbitmq.jms.client.message.RMQTextMessage;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.Util;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQSession
implements Session,
QueueSession,
TopicSession {
    private final Logger logger = LoggerFactory.getLogger(RMQSession.class);
    private final RMQConnection connection;
    private final boolean transacted;
    public static final int CLIENT_INDIVIDUAL_ACKNOWLEDGE = 4;
    private final int acknowledgeMode;
    private final boolean isIndividualAck;
    private final boolean preferProducerMessageProperty;
    private final boolean requeueOnMessageListenerException;
    private final boolean requeueOnTimeout;
    private final boolean nackOnRollback;
    private final boolean cleanUpServerNamedQueuesForNonDurableTopics;
    private final BiFunction<AMQP.BasicProperties.Builder, Message, AMQP.BasicProperties.Builder> amqpPropertiesCustomiser;
    private final SendingContextConsumer sendingContextConsumer;
    private final ReceivingContextConsumer receivingContextConsumer;
    private final PublishingListener publishingListener;
    private final Channel channel;
    private volatile boolean closed = false;
    private volatile MessageListener messageListener;
    private final ArrayList<RMQMessageProducer> producers = new ArrayList();
    private final ArrayList<RMQMessageConsumer> consumers = new ArrayList();
    private final SortedSet<Long> unackedMessageTags = Collections.synchronizedSortedSet(new TreeSet());
    private final List<Long> uncommittedMessageTags = new ArrayList<Long>();
    private final Subscriptions subscriptions;
    private final Object closeLock = new Object();
    private final Object commitLock = new Object();
    private static final long COMMIT_WAIT_MAX = 2000L;
    private boolean committing = false;
    private static final GenericVersion CLIENT_VERSION = new GenericVersion(RMQSession.class.getPackage().getImplementationVersion());
    static final String RJMS_CLIENT_VERSION = CLIENT_VERSION.toString();
    private volatile String durableTopicSelectorExchange;
    private volatile String nonDurableTopicSelectorExchange;
    private static final String RJMS_VERSION_ARG = "rjms_version";
    private static final Map<String, Object> RJMS_SELECTOR_EXCHANGE_ARGS;
    private static final String JMS_TOPIC_SELECTOR_EXCHANGE_TYPE = "x-jms-topic";
    private final DeliveryExecutor deliveryExecutor;
    private Set<Channel> browsingChannels = new HashSet<Channel>();
    private final Object bcLock = new Object();
    private final List<String> trustedPackages;
    private Map<String, Object> queueDeclareArguments = null;
    private final boolean keepTextMessageType;
    private final SubscriptionNameValidator subscriptionNameValidator;
    private final AtomicBoolean confirmSelectCalledOnChannel = new AtomicBoolean(false);
    private final DelayedMessageService delayedMessageService;
    private final ReplyToStrategy replyToStrategy;

    static boolean validateSessionMode(int sessionMode) {
        return sessionMode >= 0 && sessionMode <= 4;
    }

    public RMQSession(SessionParams sessionParams) throws JMSException {
        if (!RMQSession.validateSessionMode(sessionParams.getMode())) {
            throw new JMSException(String.format("cannot create session with acknowledgement mode = %d.", sessionParams.getMode()));
        }
        if (sessionParams.willRequeueOnTimeout() && !sessionParams.willRequeueOnMessageListenerException()) {
            throw new IllegalArgumentException("requeueOnTimeout can be true only if requeueOnMessageListenerException is true as well");
        }
        this.connection = sessionParams.getConnection();
        this.transacted = sessionParams.isTransacted();
        this.subscriptions = sessionParams.getSubscriptions();
        boolean deliveryExecutorCloseOnTimeout = !sessionParams.willRequeueOnTimeout();
        this.deliveryExecutor = new DeliveryExecutor(sessionParams.getOnMessageTimeoutMs(), deliveryExecutorCloseOnTimeout);
        this.preferProducerMessageProperty = sessionParams.willPreferProducerMessageProperty();
        this.requeueOnMessageListenerException = sessionParams.willRequeueOnMessageListenerException();
        this.nackOnRollback = sessionParams.willNackOnRollback();
        this.cleanUpServerNamedQueuesForNonDurableTopics = sessionParams.isCleanUpServerNamedQueuesForNonDurableTopics();
        this.amqpPropertiesCustomiser = sessionParams.getAmqpPropertiesCustomiser();
        this.sendingContextConsumer = sessionParams.getSendingContextConsumer();
        this.receivingContextConsumer = sessionParams.getReceivingContextConsumer() == null ? ReceivingContextConsumer.NO_OP : sessionParams.getReceivingContextConsumer();
        this.trustedPackages = sessionParams.getTrustedPackages();
        this.requeueOnTimeout = sessionParams.willRequeueOnTimeout();
        this.keepTextMessageType = sessionParams.isKeepTextMessageType();
        this.delayedMessageService = sessionParams.getDelayedMessageService();
        this.subscriptionNameValidator = name -> {
            boolean subscriptionIsValid = Utils.SUBSCRIPTION_NAME_PREDICATE.test(name);
            if (!subscriptionIsValid) {
                throw new JMSException("This subscription name is not valid: " + name + ". It must not be more than 128 characters and should contain only Java letters, digits, '_', '.', and '-'.");
            }
        };
        ReplyToStrategy replyToStrategy = this.replyToStrategy = sessionParams.getReplyToStrategy() == null ? DefaultReplyToStrategy.INSTANCE : sessionParams.getReplyToStrategy();
        if (this.transacted) {
            this.acknowledgeMode = 0;
            this.isIndividualAck = false;
        } else if (sessionParams.getMode() == 4) {
            this.acknowledgeMode = 2;
            this.isIndividualAck = true;
        } else {
            this.acknowledgeMode = sessionParams.getMode();
            this.isIndividualAck = false;
        }
        try {
            this.channel = this.connection.createRabbitChannel(this.transacted);
            this.publishingListener = PublisherConfirmsUtils.configurePublisherConfirmsSupport(this.channel);
        }
        catch (Exception x) {
            throw new RMQJMSException(x);
        }
    }

    public RMQSession(RMQConnection connection, boolean transacted, int onMessageTimeoutMs, int mode, Subscriptions subscriptions, DelayedMessageService delayedMessageService) throws JMSException {
        this(new SessionParams().setConnection(connection).setTransacted(transacted).setOnMessageTimeoutMs(onMessageTimeoutMs).setMode(mode).setSubscriptions(subscriptions).setDelayedMessageService(delayedMessageService).setReplyToStrategy(connection.getReplyToStrategy()));
    }

    void enablePublishConfirmOnChannel() throws IOException {
        if (this.confirmSelectCalledOnChannel.compareAndSet(false, true)) {
            this.channel.confirmSelect();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQBytesMessage();
    }

    private void illegalStateExceptionIfClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Session is closed");
        }
    }

    public MapMessage createMapMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.createTextMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.illegalStateExceptionIfClosed();
        ObjectMessage message = this.createObjectMessage();
        message.setObject(object);
        return message;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.illegalStateExceptionIfClosed();
        TextMessage msg = this.createTextMessage();
        msg.setText(text);
        return msg;
    }

    public boolean getTransacted() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.getTransactedNoException();
    }

    private boolean getTransactedNoException() {
        return this.transacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.getAcknowledgeModeNoException();
    }

    public List<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    public void setQueueDeclareArguments(Map<String, Object> queueDeclareArguments) {
        this.queueDeclareArguments = queueDeclareArguments;
    }

    int getAcknowledgeModeNoException() {
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterCommittingBlock() {
        Object object = this.commitLock;
        synchronized (object) {
            try {
                while (this.committing) {
                    this.commitLock.wait(2000L);
                }
                this.committing = true;
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveCommittingBlock() {
        Object object = this.commitLock;
        synchronized (object) {
            this.committing = false;
            this.commitLock.notifyAll();
        }
    }

    public void commit() throws JMSException {
        this.logger.trace("commit transaction on session {}", (Object)this);
        this.illegalStateExceptionIfClosed();
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        if (this.enterCommittingBlock()) {
            try {
                this.channel.txCommit();
                this.clearUncommittedTags();
            }
            catch (Exception x) {
                this.logger.error("RabbitMQ exception on channel.txCommit() in session {}", (Object)this, (Object)x);
                throw new RMQJMSException(x);
            }
            finally {
                this.leaveCommittingBlock();
            }
        }
    }

    public void rollback() throws JMSException {
        this.logger.trace("rollback transaction on session {}", (Object)this);
        this.illegalStateExceptionIfClosed();
        if (!this.transacted) {
            throw new IllegalStateException("Session is not transacted");
        }
        if (this.enterCommittingBlock()) {
            try {
                this.channel.txRollback();
                if (this.nackOnRollback && this.uncommittedMessageTags.size() > 0) {
                    for (Long dtag : this.uncommittedMessageTags) {
                        this.channel.basicNack(dtag.longValue(), false, false);
                    }
                    this.channel.txCommit();
                    this.clearUncommittedTags();
                }
                this.channel.basicRecover(true);
            }
            catch (IOException x) {
                this.logger.error("RabbitMQ exception on channel.txRollback() or channel.basicRecover(true) in session {}", (Object)this, (Object)x);
                throw new RMQJMSException(x);
            }
            finally {
                this.leaveCommittingBlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void explicitAck(long deliveryTag) {
        if (this.enterCommittingBlock()) {
            try {
                this.channel.basicAck(deliveryTag, false);
            }
            catch (Exception x) {
                this.logger.error("Cannot acknowledge message received (dTag={})", (Object)deliveryTag, (Object)x);
            }
            finally {
                this.leaveCommittingBlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void explicitNack(long deliveryTag) {
        if (this.enterCommittingBlock()) {
            try {
                this.channel.basicNack(deliveryTag, false, true);
            }
            catch (Exception x) {
                this.logger.warn("Cannot reject/requeue message received (dTag={})", (Object)deliveryTag, (Object)x);
            }
            finally {
                this.leaveCommittingBlock();
            }
        }
    }

    public void close() throws JMSException {
        this.getConnection().sessionClose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalClose() throws JMSException {
        if (this.closed) {
            return;
        }
        this.logger.trace("close session {}", (Object)this);
        Object object = this.closeLock;
        synchronized (object) {
            try {
                this.closeAllConsumers();
                if (this.getTransactedNoException()) {
                    this.clearUncommittedTags();
                    this.rollback();
                }
                this.deliveryExecutor.close();
                for (RMQMessageProducer producer : this.producers) {
                    producer.internalClose();
                }
                this.producers.clear();
                if (this.getTransactedNoException()) {
                    this.commit();
                }
                this.closeRabbitChannels();
            }
            finally {
                this.closed = true;
            }
        }
    }

    private void closeAllConsumers() {
        for (RMQMessageConsumer consumer : this.consumers) {
            try {
                consumer.internalClose();
            }
            catch (JMSException x) {
                this.logger.error("Consumer ({}) cannot be closed", (Object)consumer, (Object)x);
            }
        }
        this.consumers.clear();
    }

    void deliverMessage(RMQMessage rmqMessage, MessageListener messageListener) throws JMSException, InterruptedException {
        this.deliveryExecutor.deliverMessageWithProtection(rmqMessage, messageListener);
    }

    private void closeRabbitChannels() throws JMSException {
        this.clearBrowsingChannels();
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.close();
        }
        catch (ShutdownSignalException shutdownSignalException) {
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                IOException ioe = (IOException)x;
                if (!(ioe.getCause() instanceof ShutdownSignalException)) {
                    this.logger.warn("RabbitMQ channel({}) failed to close on session {}", new Object[]{this.channel, this, ioe});
                    throw new RMQJMSException(ioe);
                }
            }
            if (x instanceof TimeoutException) {
                TimeoutException te = (TimeoutException)x;
                this.logger.warn("RabbitMQ channel({}) timed out trying to close session {}", new Object[]{this.channel, this, te});
                throw new RMQJMSException(te);
            }
            throw new RMQJMSException("Unexpected exception from channel.close()", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws JMSException {
        this.illegalStateExceptionIfClosed();
        if (this.getTransactedNoException()) {
            throw new IllegalStateException("Session is transacted.");
        }
        SortedSet<Long> sortedSet = this.unackedMessageTags;
        synchronized (sortedSet) {
            if (!this.unackedMessageTags.isEmpty()) {
                try {
                    this.channel.basicRecover(true);
                }
                catch (IOException x) {
                    this.logger.warn("basicRecover on channel({}) failed", (Object)this.channel, (Object)x);
                    throw new RMQJMSException(x);
                }
                this.unackedMessageTags.clear();
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public void run() {
        throw new UnsupportedOperationException();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.logger.trace("create producer for destination '{}' on session '{}'", (Object)destination, (Object)this);
        this.illegalStateExceptionIfClosed();
        RMQDestination dest = (RMQDestination)destination;
        this.declareDestinationIfNecessary(dest);
        RMQMessageProducer producer = new RMQMessageProducer(this, dest, this.preferProducerMessageProperty, this.amqpPropertiesCustomiser, this.sendingContextConsumer, this.publishingListener, this.keepTextMessageType);
        this.producers.add(producer);
        return producer;
    }

    void declareDestinationIfNecessary(RMQDestination destination) throws JMSException {
        if (destination != null && !destination.isAmqp() && !destination.isDeclared()) {
            if (destination.isQueue()) {
                this.declareRMQQueue(destination, null, false, true);
            } else {
                this.declareTopic(destination);
            }
        }
    }

    String delayMessage(RMQDestination destination, Map<String, Object> messageHeaders, long deliveryDelayMs) {
        return this.delayedMessageService.delayMessage(this.channel, destination, messageHeaders, deliveryDelayMs);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.createConsumerInternal((RMQDestination)destination, null, false, null);
    }

    boolean syncAllowed() {
        for (RMQMessageConsumer mc : this.consumers) {
            if (!mc.messageListenerIsSet()) continue;
            return false;
        }
        return true;
    }

    boolean aSyncAllowed() {
        for (RMQMessageConsumer mc : this.consumers) {
            if (0 == mc.getNumberOfReceives()) continue;
            return false;
        }
        return true;
    }

    private RMQMessageConsumer createConsumerInternal(RMQDestination dest, String uuidTag, boolean durableSubscriber, String jmsSelector) throws JMSException {
        String consumerTag = uuidTag != null ? uuidTag : RMQSession.generateJmsConsumerQueueName();
        this.logger.trace("create consumer for destination '{}' with consumerTag '{}' and selector '{}'", new Object[]{dest, consumerTag, jmsSelector});
        this.declareDestinationIfNecessary(dest);
        if (!dest.isQueue()) {
            String subscriptionName = consumerTag;
            Subscription subscription = this.subscriptions.get(durableSubscriber, subscriptionName);
            if (subscription == null) {
                subscription = new Subscription(subscriptionName, subscriptionName, false, false, jmsSelector, false);
            }
            subscription.createTopology(dest, this, this.channel);
            consumerTag = subscription.queue();
        }
        RMQMessageConsumer consumer = new RMQMessageConsumer(this, dest, consumerTag, this.getConnection().isStopped(), jmsSelector, this.requeueOnMessageListenerException, this.receivingContextConsumer, this.requeueOnTimeout);
        this.consumers.add(consumer);
        return consumer;
    }

    private static String generateJmsConsumerQueueName() {
        return Util.generateUUID("jms-cons-");
    }

    String getSelectionExchange(boolean durableSubscriber) throws IOException {
        if (durableSubscriber) {
            return this.getDurableTopicSelectorExchange();
        }
        return this.getNonDurableTopicSelectorExchange();
    }

    private String getDurableTopicSelectorExchange() throws IOException {
        if (this.durableTopicSelectorExchange == null) {
            this.durableTopicSelectorExchange = Util.generateUUID("jms-dutop-slx-");
        }
        this.channel.exchangeDeclare(this.durableTopicSelectorExchange, JMS_TOPIC_SELECTOR_EXCHANGE_TYPE, true, true, RJMS_SELECTOR_EXCHANGE_ARGS);
        return this.durableTopicSelectorExchange;
    }

    private String getNonDurableTopicSelectorExchange() throws IOException {
        if (this.nonDurableTopicSelectorExchange == null) {
            this.nonDurableTopicSelectorExchange = Util.generateUUID("jms-ndtop-slx-");
        }
        this.channel.exchangeDeclare(this.nonDurableTopicSelectorExchange, JMS_TOPIC_SELECTOR_EXCHANGE_TYPE, false, true, RJMS_SELECTOR_EXCHANGE_ARGS);
        return this.nonDurableTopicSelectorExchange;
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.illegalStateExceptionIfClosed();
        if (RMQSession.nullOrEmpty(messageSelector)) {
            return this.createConsumer(destination);
        }
        if (RMQSession.isTopic(destination)) {
            return this.createConsumerInternal((RMQDestination)destination, null, false, messageSelector);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean nullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    private static boolean isTopic(Destination destination) {
        return !((RMQDestination)destination).isQueue();
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.illegalStateExceptionIfClosed();
        if (RMQSession.nullOrEmpty(messageSelector)) {
            RMQMessageConsumer consumer = (RMQMessageConsumer)this.createConsumer(destination);
            consumer.setNoLocal(noLocal);
            return consumer;
        }
        if (RMQSession.isTopic(destination)) {
            RMQMessageConsumer consumer = this.createConsumerInternal((RMQDestination)destination, null, false, messageSelector);
            consumer.setNoLocal(noLocal);
            return consumer;
        }
        throw new UnsupportedOperationException();
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.illegalStateExceptionIfClosed();
        RMQDestination dest = new RMQDestination(queueName, true, false);
        this.declareRMQQueue(dest, null, false, true);
        return dest;
    }

    void declareRMQQueue(RMQDestination dest, String queueNameOverride, boolean durableSubscriber, boolean bind) throws JMSException {
        boolean exclusive;
        this.logger.trace("declare RabbitMQ queue for destination '{}', explicitName '{}', durableSubscriber={}", new Object[]{dest, queueNameOverride, durableSubscriber});
        String queueName = queueNameOverride != null ? queueNameOverride : dest.getQueueName();
        String exchangeName = dest.getAmqpExchangeName();
        String exchangeType = dest.getAmqpExchangeType();
        boolean durable = durableSubscriber || dest.isQueue() & !dest.isTemporary();
        boolean bl = exclusive = dest.isTemporary() || !dest.isQueue() && !durableSubscriber;
        if (dest.isQueue()) {
            if (dest.noNeedToDeclareExchange()) {
                this.logger.warn("no need to declare built-in exchange for queue destination '{}'", (Object)dest);
            } else {
                this.logger.trace("declare RabbitMQ exchange for queue destinations '{}'", (Object)dest);
                try {
                    this.channel.exchangeDeclare(exchangeName, exchangeType, durable, false, false, null);
                }
                catch (Exception x) {
                    throw new RMQJMSException(x);
                }
            }
        }
        boolean autoDelete = this.cleanUpServerNamedQueuesForNonDurableTopics ? !durable && queueNameOverride != null && !dest.isQueue() : false;
        try {
            this.logger.debug("declare RabbitMQ queue name({}), durable({}), exclusive({}), auto-delete({}), arguments({} + {})", new Object[]{queueName, durable, exclusive, false, this.queueDeclareArguments, dest.getQueueDeclareArguments()});
            Map<String, Object> arguments = RMQSession.merge(this.queueDeclareArguments, dest.getQueueDeclareArguments());
            this.channel.queueDeclare(queueName, durable, exclusive, autoDelete, arguments);
        }
        catch (Exception x) {
            this.logger.error("RabbitMQ exception on queue declare name({}), durable({}), exclusive({}), auto-delete({}), arguments({} + {})", new Object[]{queueName, durable, exclusive, autoDelete, this.queueDeclareArguments, dest.getQueueDeclareArguments(), x});
            throw new RMQJMSException(x);
        }
        if (bind) {
            try {
                this.logger.debug("bind queue name({}), to exchange({}), with r-key({}), no arguments", new Object[]{queueName, exchangeName, queueName});
                this.channel.queueBind(queueName, exchangeName, queueName, null);
            }
            catch (Exception x) {
                this.logger.error("RabbitMQ exception on queue declare name({}), durable({}), exclusive({}), auto-delete({}), properties({})", new Object[]{queueName, durable, exclusive, false, this.queueDeclareArguments, x});
                throw new RMQJMSException(x);
            }
        }
        dest.setDeclared(true);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.illegalStateExceptionIfClosed();
        RMQDestination dest = new RMQDestination(topicName, false, false);
        this.declareTopic(dest);
        return dest;
    }

    private void declareTopic(RMQDestination dest) throws JMSException {
        if (dest.noNeedToDeclareExchange()) {
            this.logger.warn("no need to declare built-in exchange for topic destination '{}'", (Object)dest);
        } else {
            this.logger.trace("declare RabbitMQ exchange for topic destination '{}'", (Object)dest);
            try {
                this.channel.exchangeDeclare(dest.getAmqpExchangeName(), dest.getAmqpExchangeType(), !dest.isTemporary(), false, false, null);
            }
            catch (IOException x) {
                throw new RMQJMSException(x);
            }
        }
        dest.setDeclared(true);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        RMQDestination rmqDest;
        this.illegalStateExceptionIfClosed();
        if (queue instanceof RMQDestination && (rmqDest = (RMQDestination)queue).isQueue()) {
            return new BrowsingMessageQueue(this, rmqDest, messageSelector, this.connection.getQueueBrowserReadMax(), this.receivingContextConsumer);
        }
        throw new UnsupportedOperationException("Unknown destination");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel getBrowsingChannel() throws JMSException {
        try {
            Object object = this.bcLock;
            synchronized (object) {
                Channel chan = this.getConnection().createRabbitChannel(false);
                this.browsingChannels.add(chan);
                return chan;
            }
        }
        catch (Exception e) {
            throw new RMQJMSException("Cannot create browsing channel", e);
        }
    }

    private static Map<String, Object> merge(Map<String, Object> m1, Map<String, Object> m2) {
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(m1);
        merged.putAll(m2);
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBrowsingChannels() {
        Object object = this.bcLock;
        synchronized (object) {
            for (Channel chan : this.browsingChannels) {
                try {
                    if (!chan.isOpen()) continue;
                    chan.close();
                }
                catch (Exception exception) {}
            }
            this.browsingChannels.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeBrowsingChannel(Channel chan) {
        try {
            Object object = this.bcLock;
            synchronized (object) {
                if (this.browsingChannels.remove(chan) && chan.isOpen()) {
                    chan.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQDestination(Util.generateUUID("jms-temp-queue-"), true, true);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.illegalStateExceptionIfClosed();
        return new RMQDestination(Util.generateUUID("jms-temp-topic-"), false, true);
    }

    public void unsubscribe(String name) throws JMSException {
        this.illegalStateExceptionIfClosed();
        try {
            if (name != null && this.subscriptions.remove(true, name) != null) {
                this.channel.queueDelete(name);
            } else {
                this.logger.warn("Cannot unsubscribe subscription named '{}'", (Object)name);
            }
        }
        catch (IOException x) {
            this.logger.error("RabbitMQ Queue delete for queue named '{}' failed", (Object)name, (Object)x);
            throw new RMQJMSException(x);
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (QueueReceiver)this.createConsumer((Destination)queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (QueueReceiver)this.createConsumer((Destination)queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (QueueSender)this.createProducer((Destination)queue);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (TopicSubscriber)this.createConsumer((Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.illegalStateExceptionIfClosed();
        RMQMessageConsumer consumer = this.createConsumerInternal((RMQDestination)topic, null, false, messageSelector);
        consumer.setNoLocal(noLocal);
        return consumer;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.illegalStateExceptionIfClosed();
        return (TopicPublisher)this.createProducer((Destination)topic);
    }

    RMQConnection getConnection() {
        return this.connection;
    }

    Channel getChannel() {
        return this.channel;
    }

    void consumerClose(RMQMessageConsumer consumer) throws JMSException {
        if (this.consumers.remove(consumer)) {
            consumer.internalClose();
        }
    }

    void removeProducer(RMQMessageProducer producer) {
        if (this.producers.remove(producer)) {
            producer.internalClose();
        }
    }

    boolean isAutoAck() {
        return this.getAcknowledgeModeNoException() != 2;
    }

    void pause() throws JMSException {
        for (RMQMessageConsumer consumer : this.consumers) {
            try {
                consumer.pause();
            }
            catch (JMSException e) {
                throw e;
            }
            catch (InterruptedException x) {
                this.logger.error("Consumer({}) pause interrupted", (Object)consumer, (Object)x);
                throw new RMQJMSException(x);
            }
            catch (Exception x) {
                this.logger.error("Error while pausing consumer({})", (Object)consumer, (Object)x);
                throw new RMQJMSException(x);
            }
        }
    }

    void resume() throws JMSException {
        for (RMQMessageConsumer consumer : this.consumers) {
            try {
                consumer.resume();
            }
            catch (IllegalStateException x) {
                throw new RMQJMSException(x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unackedMessageReceived(long dTag) {
        if (!this.getTransactedNoException()) {
            SortedSet<Long> sortedSet = this.unackedMessageTags;
            synchronized (sortedSet) {
                this.unackedMessageTags.add(dTag);
            }
        }
    }

    void acknowledgeMessage(RMQMessage message) throws JMSException {
        this.acknowledge(message.getRabbitDeliveryTag());
    }

    void acknowledgeMessages() throws JMSException {
        try {
            Long lastMessageTag = this.unackedMessageTags.last();
            this.acknowledge(lastMessageTag);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(long messageTag) throws JMSException {
        this.illegalStateExceptionIfClosed();
        boolean individualAck = this.getIndividualAck();
        boolean groupAck = true;
        if (!this.isAutoAck() && !this.unackedMessageTags.isEmpty()) {
            SortedSet<Long> sortedSet = this.unackedMessageTags;
            synchronized (sortedSet) {
                try {
                    if (individualAck) {
                        if (!this.unackedMessageTags.contains(messageTag)) {
                            return;
                        }
                        this.getChannel().basicAck(messageTag, false);
                        this.unackedMessageTags.remove(messageTag);
                    } else if (groupAck) {
                        SortedSet<Long> previousTags = this.unackedMessageTags.headSet(messageTag + 1L);
                        if (previousTags.isEmpty()) {
                            return;
                        }
                        this.getChannel().basicAck(previousTags.last().longValue(), true);
                        previousTags.clear();
                    } else {
                        this.getChannel().basicAck(this.unackedMessageTags.last().longValue(), true);
                        this.unackedMessageTags.clear();
                    }
                }
                catch (IOException x) {
                    this.logger.error("RabbitMQ exception on basicAck of message {}; on session '{}'", new Object[]{messageTag, this, x});
                    throw new RMQJMSException(x);
                }
            }
        }
    }

    private boolean getIndividualAck() {
        return this.isIndividualAck;
    }

    void addUncommittedTag(long deliveryTag) {
        if (this.nackOnRollback && this.getTransactedNoException() && this.enterCommittingBlock()) {
            this.uncommittedMessageTags.add(deliveryTag);
            this.leaveCommittingBlock();
        }
    }

    private void clearUncommittedTags() {
        if (this.nackOnRollback) {
            this.uncommittedMessageTags.clear();
        }
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.createDurableConsumer(topic, name, null, false);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.createTopicConsumer(topic, name, true, false, messageSelector, noLocal);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return RMQSession.wrap(() -> this.createTopicConsumer(topic, sharedSubscriptionName, false, true, null, false));
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        return RMQSession.wrap(() -> this.createTopicConsumer(topic, sharedSubscriptionName, false, true, messageSelector, false));
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) {
        return RMQSession.wrap(() -> this.createTopicConsumer(topic, name, true, true, null, false));
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        return RMQSession.wrap(() -> this.createTopicConsumer(topic, name, true, true, messageSelector, false));
    }

    private static MessageConsumer wrap(Callable<MessageConsumer> action) {
        try {
            return action.call();
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage());
        }
        catch (Exception e) {
            throw new JMSRuntimeException(e.getMessage(), null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageConsumer createTopicConsumer(Topic topic, String name, boolean durable, boolean shared, String messageSelector, boolean noLocal) throws JMSException {
        this.illegalStateExceptionIfClosed();
        this.subscriptionNameValidator.validate(name);
        RMQDestination topicDest = (RMQDestination)topic;
        String queueName = durable ? name : RMQSession.generateJmsConsumerQueueName();
        Subscriptions subscriptions = this.subscriptions;
        synchronized (subscriptions) {
            Subscription subscription = this.subscriptions.register(name, queueName, durable, shared, messageSelector, noLocal);
            Subscription.PostAction postAction = subscription.validateNewConsumer((Destination)topic, durable, shared, messageSelector, noLocal);
            postAction.run(new Subscription.Context(this, this.subscriptions));
            subscription = this.subscriptions.get(durable, name);
            RMQMessageConsumer consumer = this.createConsumerInternal(topicDest, name, durable, messageSelector);
            consumer.setDurable(durable);
            consumer.setNoLocal(noLocal);
            subscription.add(consumer);
            return consumer;
        }
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)this.createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public ReplyToStrategy getReplyToStrategy() {
        return this.replyToStrategy;
    }

    static {
        if (RJMS_CLIENT_VERSION.equals("0.0.0")) {
            System.out.println("WARNING: Running test version of RJMS Client with no version information.");
        }
        RJMS_SELECTOR_EXCHANGE_ARGS = Collections.singletonMap(RJMS_VERSION_ARG, RJMS_CLIENT_VERSION);
    }

    private static interface SubscriptionNameValidator {
        public void validate(String var1) throws JMSException;
    }
}

