/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.admin;

import com.rabbitmq.jms.admin.NamingStrategy;
import com.rabbitmq.jms.admin.RMQConnectionFactory;
import com.rabbitmq.jms.admin.RMQDestination;
import com.rabbitmq.jms.client.AuthenticationMechanism;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQObjectFactory
implements ObjectFactory {
    private static final String ENV_CLASS_NAME = "className";
    private static final Logger LOGGER = LoggerFactory.getLogger(RMQObjectFactory.class);
    private final NamingStrategy namingStrategy = NamingStrategy.DEFAULT;
    private static final Map<String, Function<String, Object>> QUEUE_DECLARE_ARGUMENTS_RULES = new ConcurrentHashMap<String, Function<String, Object>>(){
        {
            this.put("x-expires", Integer::parseInt);
            this.put("x-message-ttl", Integer::parseInt);
            this.put("x-dead-letter-exchange", String::valueOf);
            this.put("x-dead-letter-routing-key", String::valueOf);
            this.put("x-dead-letter-strategy", String::valueOf);
            this.put("x-max-length", Integer::parseInt);
            this.put("x-max-length-bytes", Integer::parseInt);
            this.put("x-max-in-memory-length", Integer::parseInt);
            this.put("x-max-in-memory-bytes", Integer::parseInt);
            this.put("x-max-priority", Integer::parseInt);
            this.put("x-overflow", String::valueOf);
            this.put("x-queue-mode", String::valueOf);
            this.put("x-queue-version", Integer::valueOf);
            this.put("x-single-active-consumer", Boolean::valueOf);
            this.put("x-queue-type", String::valueOf);
            this.put("x-quorum-initial-group-size", Integer::parseInt);
            this.put("x-max-age", String::valueOf);
            this.put("x-stream-max-segment-size-bytes", Integer::parseInt);
            this.put("x-initial-cluster-size", Integer::parseInt);
            this.put("x-queue-leader-locator", String::valueOf);
        }
    };

    @Override
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable<?, ?> environment) throws Exception {
        String className;
        Reference ref;
        if (obj == null) {
            return null;
        }
        Reference reference = ref = obj instanceof Reference ? (Reference)obj : null;
        if (ref == null && (environment == null || environment.isEmpty())) {
            throw new NamingException("Unable to instantiate object: obj is not a Reference instance and environment table is empty");
        }
        String string = className = ref != null ? ref.getClassName() : (String)environment.get(ENV_CLASS_NAME);
        if (className == null || className.trim().length() == 0) {
            throw new NamingException("Unable to instantiate object: type has not been specified");
        }
        boolean topic = false;
        boolean connectionFactory = false;
        if (RMQObjectFactory.isClassNameMatching(className)) {
            connectionFactory = true;
        } else if (Topic.class.getName().equals(className)) {
            topic = true;
        } else if (!Queue.class.getName().equals(className)) {
            if (RMQDestination.class.getName().equals(className)) {
                topic = !RMQObjectFactory.getBooleanProperty(ref, environment, "isQueue", true, false);
            } else {
                throw new NamingException(String.format("Unknown class [%s]", className));
            }
        }
        if (connectionFactory) {
            return this.createConnectionFactory(ref, environment, name);
        }
        return this.createDestination(ref, environment, name, topic);
    }

    public Object createConnectionFactory(Reference ref, Hashtable<?, ?> environment, Name name) throws NamingException {
        LOGGER.trace("Creating connection factory ref '{}', name '{}'.", (Object)ref, (Object)name);
        RMQConnectionFactory f = new RMQConnectionFactory();
        try {
            f.setUri(RMQObjectFactory.getStringProperty(ref, environment, "uri", true, f.getUri()));
        }
        catch (JMSException e) {
            LOGGER.warn("Failed to set RMQConnectionFactory properties by URI--defaults taken initially.", (Throwable)e);
        }
        String urisString = RMQObjectFactory.getStringProperty(ref, environment, "uris", true, null);
        if (urisString != null) {
            try {
                f.setUris(Arrays.stream(urisString.split(",")).map(String::trim).collect(Collectors.toList()));
            }
            catch (JMSException e) {
                LOGGER.warn("Failed to set RMQConnectionFactory properties by URIs.", (Throwable)e);
            }
        }
        f.setHost(RMQObjectFactory.getStringProperty(ref, environment, "host", true, f.getHost()));
        f.setPassword(RMQObjectFactory.getStringProperty(ref, environment, "password", true, f.getPassword()));
        f.setPort(RMQObjectFactory.getIntProperty(ref, environment, "port", true, f.getPort()));
        f.setQueueBrowserReadMax(RMQObjectFactory.getIntProperty(ref, environment, "queueBrowserReadMax", true, f.getQueueBrowserReadMax()));
        f.setOnMessageTimeoutMs(RMQObjectFactory.getIntProperty(ref, environment, "onMessageTimeoutMs", true, f.getOnMessageTimeoutMs()));
        f.setChannelsQos(RMQObjectFactory.getIntProperty(ref, environment, "channelsQos", true, f.getChannelsQos()));
        if (RMQObjectFactory.getBooleanProperty(ref, environment, "ssl", true, f.isSsl())) {
            try {
                f.useSslProtocol();
            }
            catch (NoSuchAlgorithmException e) {
                throw new NamingException("Error while enabling TLS: " + e.getMessage());
            }
        }
        f.setTerminationTimeout(RMQObjectFactory.getLongProperty(ref, environment, "terminationTimeout", true, f.getTerminationTimeout()));
        f.setUsername(RMQObjectFactory.getStringProperty(ref, environment, "username", true, f.getUsername()));
        f.setVirtualHost(RMQObjectFactory.getStringProperty(ref, environment, "virtualHost", true, f.getVirtualHost()));
        f.setCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose(RMQObjectFactory.getBooleanProperty(ref, environment, "cleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose", true, f.isCleanUpServerNamedQueuesForNonDurableTopicsOnSessionClose()));
        f.setDeclareReplyToDestination(RMQObjectFactory.getBooleanProperty(ref, environment, "declareReplyToDestination", true, true));
        f.setKeepTextMessageType(RMQObjectFactory.getBooleanProperty(ref, environment, "keepTextMessageType", true, false));
        f.setNackOnRollback(RMQObjectFactory.getBooleanProperty(ref, environment, "nackOnRollback", true, false));
        String authenticationMechanismString = RMQObjectFactory.getStringProperty(ref, environment, "authenticationMechanism", true, null);
        if (authenticationMechanismString != null) {
            try {
                f.setAuthenticationMechanism(AuthenticationMechanism.valueOf(authenticationMechanismString));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Failed to set AuthenticationMechanism on RMQConnectionFactory.", (Throwable)e);
            }
        }
        return f;
    }

    public Object createDestination(Reference ref, Hashtable<?, ?> environment, Name name, boolean topic) throws NamingException {
        LOGGER.trace("Creating destination ref '{}', name '{}' (topic={}).", new Object[]{ref, name, topic});
        String dname = RMQObjectFactory.getStringProperty(ref, environment, "destinationName", false, null);
        Map<String, Object> queueDeclareArguments = RMQObjectFactory.convertQueueDeclareArguments(RMQObjectFactory.getMapProperty(ref, environment, "queueDeclareArguments", true, null));
        boolean amqp = RMQObjectFactory.getBooleanProperty(ref, environment, "amqp", true, false);
        if (amqp) {
            if (queueDeclareArguments != null) {
                LOGGER.warn("Queue declare arguments are ignored for AMQP destinations");
            }
            String amqpExchangeName = RMQObjectFactory.getStringProperty(ref, environment, "amqpExchangeName", true, null);
            String amqpRoutingKey = RMQObjectFactory.getStringProperty(ref, environment, "amqpRoutingKey", true, null);
            String amqpQueueName = RMQObjectFactory.getStringProperty(ref, environment, "amqpQueueName", true, null);
            return new RMQDestination(dname, amqpExchangeName, amqpRoutingKey, amqpQueueName);
        }
        return new RMQDestination(dname, !topic, false, queueDeclareArguments, this.namingStrategy);
    }

    private static String getStringProperty(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull, String defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, environment, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        return content;
    }

    private static boolean getBooleanProperty(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull, boolean defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, environment, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        return Boolean.valueOf(content);
    }

    private static int getIntProperty(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull, int defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, environment, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(content);
        }
        catch (Exception x) {
            NamingException nx = new NamingException(String.format("Property [%s] is present but is not an integer value [%s]", propertyName, content));
            nx.setRootCause(x);
            throw nx;
        }
    }

    private static long getLongProperty(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull, long defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, environment, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(content);
        }
        catch (Exception x) {
            NamingException nx = new NamingException(String.format("Property [%s] is present but is not a long integer value [%s]", propertyName, content));
            nx.setRootCause(x);
            throw nx;
        }
    }

    private static Map<String, String> getMapProperty(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull, Map<String, String> defaultValue) throws NamingException {
        String content = RMQObjectFactory.propertyContent(ref, environment, propertyName, mayBeNull);
        if (content == null) {
            return defaultValue;
        }
        try {
            String[] entries;
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (String entry : entries = content.split(",")) {
                String[] keyValue = entry.split("=");
                result.put(keyValue[0], keyValue[1]);
            }
            return result;
        }
        catch (Exception x) {
            NamingException nx = new NamingException(String.format("Property [%s] is present but is not a map value [%s]", propertyName, content));
            nx.setRootCause(x);
            throw nx;
        }
    }

    private static String propertyStringContent(RefAddr ra) {
        return ra == null ? null : (ra.getContent() == null ? null : ra.getContent().toString());
    }

    private static String environmentPropertyStringContent(Object propValue) {
        return propValue == null ? null : propValue.toString();
    }

    private static String propertyContent(Reference ref, Hashtable<?, ?> environment, String propertyName, boolean mayBeNull) throws NamingException {
        String content;
        if (!(mayBeNull || ref != null && ref.get(propertyName) != null || environment != null && environment.get(propertyName) != null)) {
            throw new NamingException(String.format("Property [%s] may not be null.", propertyName));
        }
        String string = content = ref != null ? RMQObjectFactory.propertyStringContent(ref.get(propertyName)) : RMQObjectFactory.environmentPropertyStringContent(environment.get(propertyName));
        if (content == null && !mayBeNull) {
            throw new NamingException(String.format("Property [%s] is present but is lacking a value.", propertyName));
        }
        return content;
    }

    private static Map<String, Object> convertQueueDeclareArguments(Map<String, String> queueDeclareArguments) {
        if (queueDeclareArguments == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(queueDeclareArguments.size());
        for (Map.Entry<String, String> entry : queueDeclareArguments.entrySet()) {
            String key = entry.getKey();
            String rawValue = entry.getValue();
            Function<String, Object> conversionRule = QUEUE_DECLARE_ARGUMENTS_RULES.get(key);
            String convertedValue = rawValue;
            try {
                convertedValue = conversionRule == null ? rawValue : conversionRule.apply(rawValue);
            }
            catch (Exception e) {
                LOGGER.info("Could not convert queue declare argument {} = {} to appropriate type, using string value. Error message: {}", new Object[]{key, rawValue, e.getMessage()});
            }
            result.put(key, convertedValue);
        }
        return result;
    }

    private static boolean isClassNameMatching(String className) {
        return QueueConnectionFactory.class.getName().equals(className) || TopicConnectionFactory.class.getName().equals(className) || ConnectionFactory.class.getName().equals(className) || RMQConnectionFactory.class.getName().equals(className);
    }
}

