/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.jms.admin.RMQDestination;
import jakarta.jms.JMSRuntimeException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

class DelayedMessageService {
    static final String X_DELAYED_JMS_EXCHANGE = "x-delayed-jms-message";
    static final String X_DELAY_HEADER = "x-delay";
    static final String X_DELAYED_JMS_EXCHANGE_HEADER = "delayed-exchange";
    private final Map<String, Boolean> delayedDestinations;
    private volatile boolean delayedExchangeDeclared;
    private Semaphore declaring = new Semaphore(1);

    public DelayedMessageService() {
        this.delayedDestinations = new ConcurrentHashMap<String, Boolean>();
    }

    void close() {
        this.delayedDestinations.clear();
    }

    String delayMessage(Channel channel, RMQDestination destination, Map<String, Object> messageHeaders, long deliveryDelayMs) {
        if (deliveryDelayMs <= 0L) {
            return destination.getAmqpExchangeName();
        }
        this.declareDelayedExchange(channel);
        this.delayedDestinations.computeIfAbsent(destination.getAmqpExchangeName(), destination1 -> {
            this.bindDestinationToDelayedExchange(channel, destination);
            return true;
        });
        messageHeaders.put(X_DELAY_HEADER, deliveryDelayMs);
        messageHeaders.put(X_DELAYED_JMS_EXCHANGE_HEADER, destination.getAmqpExchangeName());
        return X_DELAYED_JMS_EXCHANGE;
    }

    private void declareDelayedExchange(Channel channel) {
        if (this.delayedExchangeDeclared) {
            return;
        }
        try {
            this.declaring.acquire();
            if (this.delayedExchangeDeclared) {
                return;
            }
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("x-delayed-type", "headers");
            channel.exchangeDeclare(X_DELAYED_JMS_EXCHANGE, "x-delayed-message", true, false, false, args);
            this.delayedExchangeDeclared = true;
        }
        catch (Exception x) {
            throw new JMSRuntimeException("Failed to declare exchange x-delayed-jms-message", "", (Throwable)x);
        }
        finally {
            this.declaring.release();
        }
    }

    private void bindDestinationToDelayedExchange(Channel channel, RMQDestination destination) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(X_DELAYED_JMS_EXCHANGE_HEADER, destination.getAmqpExchangeName());
        try {
            channel.exchangeBind(destination.getAmqpExchangeName(), X_DELAYED_JMS_EXCHANGE, "", map);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

