/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.rabbitmq.perf.Recovery;
import com.rabbitmq.perf.StartListener;
import com.rabbitmq.perf.TopologyRecording;
import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AgentBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentBase.class);
    private static final AtomicInteger AGENT_ID_SEQUENCE = new AtomicInteger(0);
    private volatile TopologyRecording topologyRecording;
    private final int agentId;
    final StartListener startListener;

    protected AgentBase(StartListener startListener) {
        this.startListener = startListener == null ? StartListener.NO_OP : startListener;
        this.agentId = AGENT_ID_SEQUENCE.getAndIncrement();
    }

    public void setTopologyRecording(TopologyRecording topologyRecording) {
        this.topologyRecording = topologyRecording;
    }

    protected TopologyRecording topologyRecording() {
        return this.topologyRecording;
    }

    protected boolean isConnectionRecoveryTriggered(ShutdownSignalException e) {
        return AutorecoveringConnection.DEFAULT_CONNECTION_RECOVERY_TRIGGERING_CONDITION.test(e);
    }

    protected void handleShutdownSignalExceptionOnWrite(Recovery.RecoveryProcess recoveryProcess, ShutdownSignalException e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Handling write error, recovery process enabled? {}, condition to trigger connection recovery? {}", new Object[]{recoveryProcess.isEnabled(), this.isConnectionRecoveryTriggered(e), e});
        }
        if (this.shouldStop(recoveryProcess, e)) {
            throw e;
        }
    }

    protected boolean shouldStop(Recovery.RecoveryProcess recoveryProcess, ShutdownSignalException e) {
        if (recoveryProcess.isEnabled()) {
            return !this.isConnectionRecoveryTriggered(e);
        }
        return true;
    }

    protected void dealWithWriteOperation(WriteOperation writeOperation, Recovery.RecoveryProcess recoveryProcess) throws IOException {
        try {
            writeOperation.call();
        }
        catch (ShutdownSignalException e) {
            this.handleShutdownSignalExceptionOnWrite(recoveryProcess, e);
        }
        catch (SocketException e) {
            if (recoveryProcess.isEnabled()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Socket exception in write, recovery process is enabled, ignoring to let connection recovery carry on");
                }
            }
            throw e;
        }
    }

    protected void started() {
        this.startListener.started(this.agentId, this.type());
    }

    protected abstract StartListener.Type type();

    public abstract void recover(TopologyRecording var1);

    @FunctionalInterface
    static interface WriteOperation {
        public void call() throws IOException;
    }

    protected static interface AgentState {
        public long getLastStatsTime();

        public int getMsgCount();

        public int incrementMessageCount();
    }
}

