/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.impl.MicrometerMetricsCollector;
import com.rabbitmq.perf.CommandLineProxy;
import com.rabbitmq.perf.Metrics;
import com.rabbitmq.perf.Utils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class BaseMetrics
implements Metrics {
    private final AtomicInteger argumentsGauge = new AtomicInteger(1);

    @Override
    public Options options() {
        Options options = new Options();
        options.addOption(new Option("mt", "metrics-tags", true, "metrics tags as key-value pairs separated by commas"));
        options.addOption(new Option("mcla", "metrics-command-line-arguments", false, "add fixed metrics with command line arguments label"));
        options.addOption(new Option("mpx", "metrics-prefix", true, "prefix for PerfTest metrics, default is perftest_"));
        options.addOption(new Option("mc", "metrics-client", false, "enable client metrics"));
        options.addOption(new Option("mcl", "metrics-class-loader", false, "enable JVM class loader metrics"));
        options.addOption(new Option("mjm", "metrics-jvm-memory", false, "enable JVM memory metrics"));
        options.addOption(new Option("mjgc", "metrics-jvm-gc", false, "enable JVM GC metrics"));
        options.addOption(new Option("mjp", "metrics-processor", false, "enable processor metrics (gathered by JVM)"));
        options.addOption(new Option("mjt", "metrics-jvm-thread", false, "enable JVM thread metrics"));
        return options;
    }

    @Override
    public void configure(Metrics.ConfigurationContext context) {
        CommandLineProxy cmd = context.cmd();
        CompositeMeterRegistry meterRegistry = context.meterRegistry();
        ConnectionFactory factory = context.factory();
        String argumentTags = Utils.strArg(cmd, "mt", null);
        meterRegistry.config().commonTags(BaseMetrics.parseTags(argumentTags));
        if (cmd.hasOption("mcla")) {
            String metricsPrefix = context.metricsPrefix() == null ? "" : context.metricsPrefix();
            String[] args = context.args();
            Tags tags = args == null || args.length == 0 ? Tags.of((String)"command_line", (String)"") : Tags.of((String)"command_line", (String)BaseMetrics.commandLineMetrics(args, context.metricsOptions()));
            meterRegistry.gauge(metricsPrefix + "args", (Iterable)tags, (Number)this.argumentsGauge);
        }
        if (cmd.hasOption("mc")) {
            factory.setMetricsCollector((MetricsCollector)new MicrometerMetricsCollector((MeterRegistry)meterRegistry, "client"));
        }
        if (cmd.hasOption("mcl")) {
            new ClassLoaderMetrics().bindTo((MeterRegistry)meterRegistry);
        }
        if (cmd.hasOption("mjm")) {
            new JvmMemoryMetrics().bindTo((MeterRegistry)meterRegistry);
        }
        if (cmd.hasOption("mjgc")) {
            new JvmGcMetrics().bindTo((MeterRegistry)meterRegistry);
        }
        if (cmd.hasOption("mjp")) {
            new ProcessorMetrics().bindTo((MeterRegistry)meterRegistry);
        }
        if (cmd.hasOption("mjt")) {
            new JvmThreadMetrics().bindTo((MeterRegistry)meterRegistry);
        }
    }

    public String toString() {
        return "Base Metrics";
    }

    static Collection<Tag> parseTags(String argument) {
        if (argument == null || argument.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String tag : argument.split(",")) {
            String[] keyValue = tag.split("=", 2);
            tags.add(Tag.of((String)keyValue[0], (String)keyValue[1]));
        }
        return tags;
    }

    static String commandLineMetrics(String[] args, Options metricsOptions) {
        HashMap<String, Boolean> filteredOptions = new HashMap<String, Boolean>();
        filteredOptions.put("--uri", true);
        filteredOptions.put("-h", true);
        for (Option option : metricsOptions.getOptions()) {
            filteredOptions.put("-" + option.getOpt(), option.hasArg());
            if (!option.hasLongOpt()) continue;
            filteredOptions.put("--" + option.getLongOpt(), option.hasArg());
        }
        ArrayList<String> filtered = new ArrayList<String>();
        Iterator iterator = Arrays.stream(args).iterator();
        while (iterator.hasNext()) {
            String option = (String)iterator.next();
            if (filteredOptions.containsKey(option)) {
                if (!((Boolean)filteredOptions.get(option)).booleanValue()) continue;
                iterator.next();
                continue;
            }
            filtered.add(option);
        }
        return String.join((CharSequence)" ", filtered);
    }
}

