/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CommandLineProxy {
    private final CommandLine delegate;
    private final Function<String, String> argumentLookup;

    public CommandLineProxy(Options options, CommandLine delegate, Function<String, String> argumentLookup) {
        this.delegate = delegate;
        Function<String, String> optionToLongOption = option -> {
            for (Object optObj : options.getOptions()) {
                Option opt = (Option)optObj;
                if (!opt.getOpt().equals(option)) continue;
                return opt.getLongOpt();
            }
            return null;
        };
        this.argumentLookup = optionToLongOption.andThen(longOption -> longOption == null ? null : (String)argumentLookup.apply((String)longOption));
    }

    public boolean hasOption(char opt) {
        return this.override(String.valueOf(opt), () -> this.delegate.hasOption(opt), Boolean.class);
    }

    public boolean hasOption(String opt) {
        return this.override(opt, () -> this.delegate.hasOption(opt), Boolean.class);
    }

    public String getOptionValue(char opt, String def) {
        return this.override(String.valueOf(opt), () -> this.delegate.getOptionValue(opt, def), String.class);
    }

    public String getOptionValue(String opt, String def) {
        return this.override(opt, () -> this.delegate.getOptionValue(opt, def), String.class);
    }

    public String[] getOptionValues(char opt) {
        return this.override(String.valueOf(opt), () -> this.delegate.getOptionValues(opt), String[].class);
    }

    public String[] getOptionValues(String opt) {
        return this.override(String.valueOf(opt), () -> this.delegate.getOptionValues(opt), String[].class);
    }

    public String getOptionValue(char opt) {
        return this.override(String.valueOf(opt), () -> this.delegate.getOptionValue(opt), String.class);
    }

    private <T> T override(String opt, Supplier<T> argumentValue, Class<T> type) {
        String value = this.argumentLookup.apply(opt);
        if (value == null) {
            return argumentValue.get();
        }
        if (Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(value);
        }
        if (String[].class.equals(type)) {
            return (T)value.split(",");
        }
        return (T)value;
    }
}

