/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.perf.MulticastParams;
import com.rabbitmq.perf.StartListener;
import com.rabbitmq.perf.ValueIndicator;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.function.IntToDoubleFunction;

final class ExpectedMetrics {
    static final String METRICS_PUBLISHED = "expected_published";
    static final String METRICS_CONSUMED = "expected_consumed";
    private final AtomicInteger producers = new AtomicInteger(0);
    private final AtomicInteger consumers = new AtomicInteger(0);
    private final DoubleAccumulator expectedPublished;
    private final DoubleAccumulator expectedConsumed;
    private final Map<String, DoubleAccumulator> exposed;
    private final IntToDoubleFunction consumingRateCalculation;
    private volatile IntToDoubleFunction publishingRateCalculation;

    ExpectedMetrics(MulticastParams params, MeterRegistry registry, String prefix, Map<String, Object> exposedMetrics) {
        Object expectedRateValue;
        Map<Object, Object> map = exposedMetrics = exposedMetrics == null ? Collections.emptyMap() : exposedMetrics;
        if (exposedMetrics.containsKey(METRICS_PUBLISHED)) {
            expectedRateValue = exposedMetrics.get(METRICS_PUBLISHED);
            this.expectedPublished = (DoubleAccumulator)registry.gauge(prefix + METRICS_PUBLISHED, (Number)ExpectedMetrics.createDoubleAccumulator(expectedRateValue));
        } else {
            this.expectedPublished = params.getProducerRateLimit() >= 0.0f || params.getPublishingRates() != null && !params.getPublishingRates().isEmpty() || params.getPublishingInterval() != null ? (DoubleAccumulator)registry.gauge(prefix + METRICS_PUBLISHED, (Number)new DoubleAccumulator((previousValue, newValue) -> newValue, 0.0)) : new DoubleAccumulator((left, right) -> 0.0, 0.0);
        }
        if (exposedMetrics.containsKey(METRICS_CONSUMED)) {
            expectedRateValue = exposedMetrics.get(METRICS_CONSUMED);
            this.expectedConsumed = (DoubleAccumulator)registry.gauge(prefix + METRICS_CONSUMED, (Number)ExpectedMetrics.createDoubleAccumulator(expectedRateValue));
            this.consumingRateCalculation = c -> 0.0;
        } else if (params.getConsumerRateLimit() > 0.0f) {
            this.consumingRateCalculation = consumerCount -> (float)consumerCount * params.getConsumerRateLimit();
            this.expectedConsumed = (DoubleAccumulator)registry.gauge(prefix + METRICS_CONSUMED, (Number)new DoubleAccumulator((previousValue, newValue) -> newValue, 0.0));
        } else {
            this.expectedConsumed = new DoubleAccumulator((left, right) -> 0.0, 0.0);
            this.consumingRateCalculation = c -> 0.0;
        }
        exposedMetrics = new LinkedHashMap<String, Object>(exposedMetrics);
        exposedMetrics.remove(METRICS_PUBLISHED);
        exposedMetrics.remove(METRICS_CONSUMED);
        if (exposedMetrics.isEmpty()) {
            this.exposed = Collections.emptyMap();
        } else {
            this.exposed = new ConcurrentHashMap<String, DoubleAccumulator>(exposedMetrics.size());
            for (Map.Entry<String, Object> entry : exposedMetrics.entrySet()) {
                Object expectedValue = entry.getValue();
                DoubleAccumulator gauge = (DoubleAccumulator)registry.gauge(prefix + entry.getKey(), (Number)ExpectedMetrics.createDoubleAccumulator(expectedValue));
                this.exposed.put(entry.getKey(), gauge);
            }
        }
    }

    private static DoubleAccumulator createDoubleAccumulator(Object expectedValue) {
        if (!(expectedValue instanceof Number)) {
            expectedValue = Double.valueOf(expectedValue.toString());
        }
        double expected = ((Number)expectedValue).doubleValue();
        return new DoubleAccumulator((left, right) -> expected, expected);
    }

    void agentStarted(StartListener.Type type) {
        if (type == StartListener.Type.PRODUCER) {
            this.producers.incrementAndGet();
            this.expectedPublished.accumulate(this.publishingRateCalculation.applyAsDouble(this.producers.get()));
        }
        if (type == StartListener.Type.CONSUMER) {
            this.consumers.incrementAndGet();
            this.expectedConsumed.accumulate(this.consumingRateCalculation.applyAsDouble(this.consumers.get()));
        }
        this.exposed.values().forEach(g -> g.accumulate(0.0));
    }

    void register(ValueIndicator<Float> publishingRateIndicator, Duration publishingInterval) {
        if (publishingInterval == null) {
            this.publishingRateCalculation = producers -> (float)producers * ((Float)publishingRateIndicator.getValue()).floatValue();
            publishingRateIndicator.register((oldValue, newValue) -> this.expectedPublished.accumulate(this.publishingRateCalculation.applyAsDouble(this.producers.get())));
        } else {
            this.publishingRateCalculation = producers -> (double)producers / (double)publishingInterval.getSeconds();
        }
    }
}

