/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.perf.CommandLineProxy;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public interface Metrics {
    public Options options();

    default public void configure(ConfigurationContext context) throws Exception {
    }

    default public boolean isEnabled(CommandLineProxy cmd) {
        for (Object optObj : this.options().getOptions()) {
            Option option = (Option)optObj;
            if (!cmd.hasOption(option.getOpt())) continue;
            return true;
        }
        return false;
    }

    default public void close() throws Exception {
    }

    public static class ConfigurationContext {
        private final CommandLineProxy cmd;
        private final CompositeMeterRegistry meterRegistry;
        private final ConnectionFactory factory;
        private final String[] args;
        private final String metricsPrefix;
        private final Options metricsOptions;

        public ConfigurationContext(CommandLineProxy cmd, CompositeMeterRegistry meterRegistry, ConnectionFactory factory, String[] args, String metricsPrefix, Options metricsOptions) {
            this.cmd = cmd;
            this.meterRegistry = meterRegistry;
            this.factory = factory;
            this.args = args;
            this.metricsPrefix = metricsPrefix;
            this.metricsOptions = metricsOptions;
        }

        public CommandLineProxy cmd() {
            return this.cmd;
        }

        public CompositeMeterRegistry meterRegistry() {
            return this.meterRegistry;
        }

        public ConnectionFactory factory() {
            return this.factory;
        }

        public String[] args() {
            return this.args;
        }

        public String metricsPrefix() {
            return this.metricsPrefix;
        }

        public Options metricsOptions() {
            return this.metricsOptions;
        }
    }
}

