/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.perf.PerfTest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PerfUtil {
    public static void setValue(Object obj, Object name, Object value) {
        if (name == null || name.toString().isEmpty()) {
            throw new IllegalArgumentException("Property name must be specified");
        }
        try {
            String setterName = name.toString().length() > 1 ? "set" + name.toString().substring(0, 1).toUpperCase() + name.toString().substring(1) : "set" + name.toString().toUpperCase();
            for (Method method : obj.getClass().getDeclaredMethods()) {
                if (!method.getName().equals(setterName)) continue;
                method.invoke(obj, PerfUtil.convert(method.getParameterTypes()[0], value));
                return;
            }
            throw new RuntimeException("Could not find property " + name + " in " + obj.getClass());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object convert(Class<?> targetType, Object value) {
        if (targetType.equals(value) || targetType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (PerfUtil.isInt(targetType)) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.valueOf(value.toString());
        }
        if (PerfUtil.isFloat(targetType)) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(value.toString());
        }
        if (PerfUtil.isLong(targetType)) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.valueOf(value.toString());
        }
        if (PerfUtil.isBoolean(targetType)) {
            return Boolean.valueOf(value.toString());
        }
        if (PerfUtil.isMap(targetType)) {
            return PerfTest.convertKeyValuePairs(value.toString());
        }
        if (PerfUtil.isList(targetType)) {
            return Arrays.asList(value.toString().split(","));
        }
        return value;
    }

    private static boolean isBoolean(Class<?> targetType) {
        return targetType.equals(Boolean.class) || "boolean".equals(targetType.getSimpleName());
    }

    private static boolean isInt(Class<?> targetType) {
        return targetType.equals(Integer.class) || "int".equals(targetType.getSimpleName());
    }

    private static boolean isFloat(Class<?> targetType) {
        return targetType.equals(Float.class) || "float".equals(targetType.getSimpleName());
    }

    private static boolean isLong(Class<?> targetType) {
        return targetType.equals(Long.class) || "long".equals(targetType.getSimpleName());
    }

    private static boolean isMap(Class<?> targetType) {
        return targetType.isAssignableFrom(Map.class);
    }

    private static boolean isList(Class<?> targetType) {
        return targetType.isAssignableFrom(List.class);
    }
}

