/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.perf.AgentBase;
import com.rabbitmq.perf.MessageBodySource;
import com.rabbitmq.perf.MulticastSet;
import com.rabbitmq.perf.PerfTestException;
import com.rabbitmq.perf.ProducerParameters;
import com.rabbitmq.perf.RateLimiterUtils;
import com.rabbitmq.perf.Recovery;
import com.rabbitmq.perf.StartListener;
import com.rabbitmq.perf.TimestampProvider;
import com.rabbitmq.perf.TopologyRecording;
import com.rabbitmq.perf.ValueIndicator;
import com.rabbitmq.perf.metrics.PerformanceMetrics;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Producer
extends AgentBase
implements Runnable,
ReturnListener,
ConfirmListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Producer.class);
    public static final String TIMESTAMP_PROPERTY = "timestamp";
    public static final String CONTENT_TYPE_PROPERTY = "contentType";
    public static final String CONTENT_ENCODING_PROPERTY = "contentEncoding";
    public static final String DELIVERY_MODE_PROPERTY = "deliveryMode";
    public static final String PRIORITY_PROPERTY = "priority";
    public static final String CORRELATION_ID_PROPERTY = "correlationId";
    public static final String REPLY_TO_PROPERTY = "replyTo";
    public static final String EXPIRATION_PROPERTY = "expiration";
    public static final String MESSAGE_ID_PROPERTY = "messageId";
    public static final String TYPE_PROPERTY = "type";
    public static final String USER_ID_PROPERTY = "userId";
    public static final String APP_ID_PROPERTY = "appId";
    public static final String CLUSTER_ID_PROPERTY = "clusterId";
    public static final String TIMESTAMP_HEADER = "timestamp";
    static final String STOP_REASON_PRODUCER_MESSAGE_LIMIT = "Producer reached message limit";
    static final String STOP_REASON_PRODUCER_THREAD_INTERRUPTED = "Producer thread interrupted";
    static final String STOP_REASON_ERROR_IN_PRODUCER = "Error in producer";
    private final Channel channel;
    private final String exchangeName;
    private final String id;
    private final boolean mandatory;
    private final boolean persistent;
    private final int txSize;
    private final int msgLimit;
    private final PerformanceMetrics performanceMetrics;
    private final MessageBodySource messageBodySource;
    private final Function<AMQP.BasicProperties.Builder, AMQP.BasicProperties.Builder> propertiesBuilderProcessor;
    private final Semaphore confirmPool;
    private final int confirmTimeout;
    private final int maxOutstandingConfirms;
    private final ConcurrentNavigableMap<Long, Long> unconfirmed = new ConcurrentSkipListMap<Long, Long>();
    private final MulticastSet.CompletionHandler completionHandler;
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final Supplier<String> routingKeyGenerator;
    private final int randomStartDelay;
    private final Recovery.RecoveryProcess recoveryProcess;
    private final boolean shouldTrackPublishConfirms;
    private final TimestampProvider timestampProvider;
    private final ValueIndicator<Float> rateIndicator;
    private final Runnable rateLimiterCallback;
    private static final Collection<String> MESSAGE_PROPERTIES_KEYS = Arrays.asList("contentType", "contentEncoding", "headers", "deliveryMode", "priority", "correlationId", "replyTo", "expiration", "messageId", "timestamp", "type", "userId", "appId", "clusterId");

    public Producer(ProducerParameters parameters) {
        super(parameters.getStartListener());
        this.channel = parameters.getChannel();
        this.exchangeName = parameters.getExchangeName();
        this.id = parameters.getId();
        this.mandatory = parameters.getFlags().contains("mandatory");
        this.persistent = parameters.getFlags().contains("persistent");
        Function<AMQP.BasicProperties.Builder, AMQP.BasicProperties.Builder> builderProcessor = Function.identity();
        this.txSize = parameters.getTxSize();
        this.msgLimit = parameters.getMsgLimit();
        this.messageBodySource = parameters.getMessageBodySource();
        this.timestampProvider = parameters.getTsp();
        if (this.timestampProvider.isTimestampInHeader()) {
            builderProcessor = builderProcessor.andThen(builder -> builder.headers(Collections.singletonMap("timestamp", parameters.getTsp().getCurrentTime())));
        }
        if (parameters.getMessageProperties() != null && !parameters.getMessageProperties().isEmpty()) {
            builderProcessor = this.builderProcessorWithMessageProperties(parameters.getMessageProperties(), builderProcessor);
        }
        this.shouldTrackPublishConfirms = this.shouldTrackPublishConfirm(parameters);
        if (parameters.getConfirm() > 0L) {
            this.confirmPool = new Semaphore((int)parameters.getConfirm());
            this.confirmTimeout = parameters.getConfirmTimeout();
            this.maxOutstandingConfirms = (int)parameters.getConfirm();
        } else {
            this.confirmPool = null;
            this.confirmTimeout = -1;
            this.maxOutstandingConfirms = -1;
        }
        this.performanceMetrics = parameters.getPerformanceMetrics();
        this.completionHandler = parameters.getCompletionHandler();
        this.propertiesBuilderProcessor = builderProcessor;
        this.routingKeyGenerator = parameters.isRandomRoutingKey() || parameters.getRoutingKeyCacheSize() > 0 ? (parameters.getRoutingKeyCacheSize() > 0 ? new CachingRoutingKeyGenerator(parameters.getRoutingKeyCacheSize()) : () -> UUID.randomUUID().toString()) : () -> this.id;
        this.randomStartDelay = parameters.getRandomStartDelayInSeconds();
        this.rateIndicator = parameters.getRateIndicator();
        this.recoveryProcess = parameters.getRecoveryProcess();
        this.recoveryProcess.init(this);
        if (this.rateIndicator.getValue().floatValue() >= 0.0f && this.rateIndicator.isVariable()) {
            RateLimiterUtils.RateLimiter rateLimiter = RateLimiterUtils.RateLimiter.create(this.rateIndicator.getValue().floatValue() > 0.0f ? (double)this.rateIndicator.getValue().floatValue() : 1.0);
            AtomicReference<RateLimiterUtils.RateLimiter> rateLimiterReference = new AtomicReference<RateLimiterUtils.RateLimiter>(rateLimiter);
            this.rateIndicator.register((oldValue, newValue) -> {
                if (newValue.floatValue() > 0.0f) {
                    rateLimiterReference.set(RateLimiterUtils.RateLimiter.create(newValue.floatValue()));
                }
            });
            this.rateLimiterCallback = () -> ((RateLimiterUtils.RateLimiter)rateLimiterReference.get()).acquire(1);
        } else if (this.rateIndicator.getValue().floatValue() >= 0.0f && !this.rateIndicator.isVariable()) {
            if (this.rateIndicator.getValue().floatValue() > 0.0f) {
                RateLimiterUtils.RateLimiter rateLimiter = RateLimiterUtils.RateLimiter.create(this.rateIndicator.getValue().floatValue());
                this.rateLimiterCallback = () -> rateLimiter.acquire(1);
            } else {
                this.rateLimiterCallback = () -> {};
            }
        } else {
            this.rateLimiterCallback = () -> {};
        }
    }

    private Function<AMQP.BasicProperties.Builder, AMQP.BasicProperties.Builder> builderProcessorWithMessageProperties(Map<String, Object> messageProperties, Function<AMQP.BasicProperties.Builder, AMQP.BasicProperties.Builder> builderProcessor) {
        Map<String, Object> headers;
        Object value;
        if (messageProperties.containsKey(CONTENT_TYPE_PROPERTY)) {
            value = messageProperties.get(CONTENT_TYPE_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$8((String)value, arg_0));
        }
        if (messageProperties.containsKey(CONTENT_ENCODING_PROPERTY)) {
            value = messageProperties.get(CONTENT_ENCODING_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$9((String)value, arg_0));
        }
        if (messageProperties.containsKey(DELIVERY_MODE_PROPERTY)) {
            value = ((Number)messageProperties.get(DELIVERY_MODE_PROPERTY)).intValue();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$10((Integer)value, arg_0));
        }
        if (messageProperties.containsKey(PRIORITY_PROPERTY)) {
            value = ((Number)messageProperties.get(PRIORITY_PROPERTY)).intValue();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$11((Integer)value, arg_0));
        }
        if (messageProperties.containsKey(CORRELATION_ID_PROPERTY)) {
            value = messageProperties.get(CORRELATION_ID_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$12((String)value, arg_0));
        }
        if (messageProperties.containsKey(REPLY_TO_PROPERTY)) {
            value = messageProperties.get(REPLY_TO_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$13((String)value, arg_0));
        }
        if (messageProperties.containsKey(EXPIRATION_PROPERTY)) {
            value = messageProperties.get(EXPIRATION_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$14((String)value, arg_0));
        }
        if (messageProperties.containsKey(MESSAGE_ID_PROPERTY)) {
            value = messageProperties.get(MESSAGE_ID_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$15((String)value, arg_0));
        }
        if (messageProperties.containsKey("timestamp")) {
            value = messageProperties.get("timestamp").toString();
            Date timestamp = Date.from(OffsetDateTime.parse((CharSequence)value).toInstant());
            builderProcessor = builderProcessor.andThen(builder -> builder.timestamp(timestamp));
        }
        if (messageProperties.containsKey(TYPE_PROPERTY)) {
            value = messageProperties.get(TYPE_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$17((String)value, arg_0));
        }
        if (messageProperties.containsKey(USER_ID_PROPERTY)) {
            value = messageProperties.get(USER_ID_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$18((String)value, arg_0));
        }
        if (messageProperties.containsKey(APP_ID_PROPERTY)) {
            value = messageProperties.get(APP_ID_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$19((String)value, arg_0));
        }
        if (messageProperties.containsKey(CLUSTER_ID_PROPERTY)) {
            value = messageProperties.get(CLUSTER_ID_PROPERTY).toString();
            builderProcessor = builderProcessor.andThen(arg_0 -> Producer.lambda$builderProcessorWithMessageProperties$20((String)value, arg_0));
        }
        if (!(headers = messageProperties.entrySet().stream().filter(entry -> !this.isPropertyKey((String)entry.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()))).isEmpty()) {
            builderProcessor = builderProcessor.andThen(builder -> {
                AMQP.BasicProperties properties = builder.build();
                Map existingHeaders = properties.getHeaders();
                if (existingHeaders != null && !existingHeaders.isEmpty()) {
                    HashMap newHeaders = new HashMap();
                    newHeaders.putAll(existingHeaders);
                    newHeaders.putAll(headers);
                    builder = builder.headers(newHeaders);
                } else {
                    builder = builder.headers(headers);
                }
                return builder;
            });
        }
        return builderProcessor;
    }

    @Override
    protected StartListener.Type type() {
        return StartListener.Type.PRODUCER;
    }

    private boolean isPropertyKey(String key) {
        return MESSAGE_PROPERTIES_KEYS.contains(key);
    }

    private boolean shouldTrackPublishConfirm(ProducerParameters parameters) {
        return parameters.getConfirm() > 0L;
    }

    public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) {
        this.performanceMetrics.returned();
    }

    public void handleAck(long seqNo, boolean multiple) {
        this.handleAckNack(seqNo, multiple, false);
    }

    public void handleNack(long seqNo, boolean multiple) {
        this.handleAckNack(seqNo, multiple, true);
    }

    private void handleAckNack(long seqNo, boolean multiple, boolean nack) {
        int numConfirms = nack ? this.processNack(seqNo, multiple) : this.processAck(seqNo, multiple);
        if (this.confirmPool != null && numConfirms > 0) {
            this.confirmPool.release(numConfirms);
        }
    }

    private int processAck(long seqNo, boolean multiple) {
        long[] latencies;
        int numConfirms;
        long currentTime = this.timestampProvider.getCurrentTime();
        if (multiple) {
            NavigableMap confirmed = this.unconfirmed.headMap((Object)seqNo, true);
            numConfirms = confirmed.size();
            latencies = new long[numConfirms];
            int index = 0;
            for (Map.Entry entry : confirmed.entrySet()) {
                latencies[index] = this.timestampProvider.getDifference(currentTime, (Long)entry.getValue());
                ++index;
            }
            confirmed.clear();
        } else {
            Long messageTimestamp = (Long)this.unconfirmed.remove(seqNo);
            latencies = messageTimestamp != null ? new long[]{this.timestampProvider.getDifference(currentTime, messageTimestamp)} : new long[]{};
            numConfirms = 1;
        }
        this.performanceMetrics.confirmed(numConfirms, latencies);
        return numConfirms;
    }

    private int processNack(long seqNo, boolean multiple) {
        int numConfirms;
        if (multiple) {
            NavigableMap confirmed = this.unconfirmed.headMap((Object)seqNo, true);
            numConfirms = confirmed.size();
            confirmed.clear();
        } else {
            this.unconfirmed.remove(seqNo);
            numConfirms = 1;
        }
        this.performanceMetrics.nacked(numConfirms);
        return numConfirms;
    }

    @Override
    public void run() {
        if (this.randomStartDelay > 0) {
            int delay = new Random().nextInt(this.randomStartDelay * 1000) + 1;
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        long startTime = System.nanoTime();
        ProducerState state = new ProducerState();
        state.setLastStatsTime(startTime);
        state.setMsgCount(0);
        boolean variableRate = this.rateIndicator.isVariable();
        this.started();
        try {
            while (this.keepGoing(state)) {
                this.rateLimiterCallback.run();
                if (variableRate && this.rateIndicator.getValue().floatValue() == 0.0f) {
                    this.waitForOneSecond();
                } else {
                    this.handlePublish(state);
                }
                long now = System.nanoTime();
                if (!variableRate || now - state.getLastStatsTime() <= 1000L) continue;
                state.setLastStatsTime(now);
                state.setMsgCount(0);
            }
        }
        catch (PerfTestException pte) {
            this.countDown(pte.getMessage());
            throw pte;
        }
        catch (Exception e) {
            LOGGER.debug("Error in publisher", (Throwable)e);
            String reason = e.getCause() instanceof InterruptedException && this.rateIndicator.getValue().floatValue() != 0.0f ? STOP_REASON_PRODUCER_THREAD_INTERRUPTED : "Error in producer (" + e.getMessage() + ")";
            this.countDown(reason);
            throw e;
        }
        if (state.getMsgCount() >= this.msgLimit) {
            String reason;
            if (this.msgLimit == 0) {
                reason = STOP_REASON_PRODUCER_THREAD_INTERRUPTED;
            } else {
                reason = STOP_REASON_PRODUCER_MESSAGE_LIMIT;
                LOGGER.debug("Producer reached message limit of {}", (Object)this.msgLimit);
                this.maybeWaitForPublishConfirms();
            }
            this.countDown(reason);
        }
    }

    private void maybeWaitForPublishConfirms() {
        if (this.confirmPool != null) {
            long waited;
            LOGGER.debug("Publish confirms enabled, making sure all messages have been confirmed");
            LOGGER.debug("Outstanding publish confirm(s): {}", (Object)this.unconfirmed.size());
            long timeout = this.confirmTimeout * 1000;
            long waitTime = 100L;
            for (waited = 0L; waited <= timeout; waited += waitTime) {
                if (this.unconfirmed.isEmpty()) {
                    LOGGER.debug("All messages have been confirmed, moving on...");
                    waited = timeout;
                }
                try {
                    Thread.sleep(waitTime);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    waited = timeout;
                }
            }
            if (waited > timeout) {
                LOGGER.debug("Unconfirmed message(s): {}", (Object)this.unconfirmed.size());
            }
        }
    }

    private void waitForOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private boolean keepGoing(AgentBase.AgentState state) {
        return (this.msgLimit == 0 || state.getMsgCount() < this.msgLimit) && !Thread.interrupted();
    }

    public Runnable createRunnableForScheduling() {
        AtomicBoolean initialized = new AtomicBoolean(false);
        ProducerState state = new ProducerState(){
            final AtomicInteger messageCount = new AtomicInteger(0);

            @Override
            protected void setMsgCount(int msgCount) {
                this.messageCount.set(msgCount);
            }

            @Override
            public int getMsgCount() {
                return this.messageCount.get();
            }

            @Override
            public int incrementMessageCount() {
                return this.messageCount.incrementAndGet();
            }
        };
        return () -> {
            if (initialized.compareAndSet(false, true)) {
                state.setLastStatsTime(System.nanoTime());
                state.setMsgCount(0);
                this.started();
            }
            try {
                this.maybeHandlePublish(state);
            }
            catch (PerfTestException pte) {
                this.countDown(pte.getMessage());
                throw pte;
            }
            catch (Exception e) {
                this.countDown("Error in scheduled producer (" + e.getMessage() + ")");
                throw e;
            }
        };
    }

    public void maybeHandlePublish(AgentBase.AgentState state) {
        if (this.keepGoing(state)) {
            this.handlePublish(state);
        } else {
            String reason;
            if (this.messageLimitReached(state)) {
                reason = STOP_REASON_PRODUCER_MESSAGE_LIMIT;
                LOGGER.debug("Producer reached message limit of {}", (Object)this.msgLimit);
                this.maybeWaitForPublishConfirms();
            } else {
                reason = STOP_REASON_PRODUCER_THREAD_INTERRUPTED;
            }
            this.countDown(reason);
        }
    }

    private boolean messageLimitReached(AgentBase.AgentState state) {
        if (this.msgLimit == 0) {
            return false;
        }
        return state.getMsgCount() >= this.msgLimit;
    }

    public void handlePublish(AgentBase.AgentState currentState) {
        if (!this.recoveryProcess.isRecoverying()) {
            try {
                this.maybeWaitIfTooManyOutstandingPublishConfirms();
                this.dealWithWriteOperation(() -> this.publish(this.messageBodySource.create(currentState.getMsgCount())), this.recoveryProcess);
                int messageCount = currentState.incrementMessageCount();
                this.commitTransactionIfNecessary(messageCount);
                this.performanceMetrics.published();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        try {
            LOGGER.debug("Recovery in progress, sleeping for a sec");
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void maybeWaitIfTooManyOutstandingPublishConfirms() throws InterruptedException {
        if (this.confirmPool != null) {
            if (this.confirmTimeout < 0) {
                this.confirmPool.acquire();
            } else {
                boolean acquired = this.confirmPool.tryAcquire(this.confirmTimeout, TimeUnit.SECONDS);
                if (!acquired) {
                    throw new PerfTestException("Waiting for publisher confirms for too long");
                }
            }
        }
    }

    private void commitTransactionIfNecessary(int messageCount) throws IOException {
        if (this.txSize != 0 && messageCount % this.txSize == 0) {
            this.dealWithWriteOperation(() -> this.channel.txCommit(), this.recoveryProcess);
        }
    }

    private void publish(MessageBodySource.MessageEnvelope messageEnvelope) throws IOException {
        AMQP.BasicProperties.Builder propertiesBuilder = new AMQP.BasicProperties.Builder();
        if (this.persistent) {
            propertiesBuilder.deliveryMode(Integer.valueOf(2));
        }
        if (messageEnvelope.getContentType() != null) {
            propertiesBuilder.contentType(messageEnvelope.getContentType());
        }
        propertiesBuilder = this.propertiesBuilderProcessor.apply(propertiesBuilder);
        AMQP.BasicProperties messageProperties = propertiesBuilder.build();
        if (this.shouldTrackPublishConfirms) {
            if (this.timestampProvider.isTimestampInHeader()) {
                Long timestamp = (Long)messageProperties.getHeaders().get("timestamp");
                this.unconfirmed.put(this.channel.getNextPublishSeqNo(), timestamp);
            } else {
                this.unconfirmed.put(this.channel.getNextPublishSeqNo(), messageEnvelope.getTime());
            }
        }
        this.channel.basicPublish(this.exchangeName, this.routingKeyGenerator.get(), this.mandatory, false, messageProperties, messageEnvelope.getBody());
    }

    private void countDown(String reason) {
        if (this.completed.compareAndSet(false, true)) {
            this.completionHandler.countDown(reason);
        }
    }

    @Override
    public void recover(TopologyRecording topologyRecording) {
        this.maybeResetConfirmPool();
    }

    private void maybeResetConfirmPool() {
        if (this.confirmPool != null) {
            int usedPermits = this.maxOutstandingConfirms - this.confirmPool.availablePermits();
            this.confirmPool.release(usedPermits);
            LOGGER.debug("Resetting confirm pool in producer, used permit(s) {}, now {} available", (Object)usedPermits, (Object)this.confirmPool.availablePermits());
        }
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$20(String value, AMQP.BasicProperties.Builder builder) {
        return builder.clusterId(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$19(String value, AMQP.BasicProperties.Builder builder) {
        return builder.appId(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$18(String value, AMQP.BasicProperties.Builder builder) {
        return builder.userId(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$17(String value, AMQP.BasicProperties.Builder builder) {
        return builder.type(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$15(String value, AMQP.BasicProperties.Builder builder) {
        return builder.messageId(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$14(String value, AMQP.BasicProperties.Builder builder) {
        return builder.expiration(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$13(String value, AMQP.BasicProperties.Builder builder) {
        return builder.replyTo(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$12(String value, AMQP.BasicProperties.Builder builder) {
        return builder.correlationId(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$11(Integer value, AMQP.BasicProperties.Builder builder) {
        return builder.priority(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$10(Integer value, AMQP.BasicProperties.Builder builder) {
        return builder.deliveryMode(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$9(String value, AMQP.BasicProperties.Builder builder) {
        return builder.contentEncoding(value);
    }

    private static /* synthetic */ AMQP.BasicProperties.Builder lambda$builderProcessorWithMessageProperties$8(String value, AMQP.BasicProperties.Builder builder) {
        return builder.contentType(value);
    }

    static class CachingRoutingKeyGenerator
    implements Supplier<String> {
        private final String[] keys;
        private int count = 0;

        public CachingRoutingKeyGenerator(int cacheSize) {
            if (cacheSize <= 0) {
                throw new IllegalArgumentException(String.valueOf(cacheSize));
            }
            this.keys = new String[cacheSize];
            for (int i = 0; i < cacheSize; ++i) {
                this.keys[i] = UUID.randomUUID().toString();
            }
        }

        @Override
        public String get() {
            if (this.count == this.keys.length) {
                this.count = 0;
            }
            return this.keys[this.count++ % this.keys.length];
        }
    }

    private static class ProducerState
    implements AgentBase.AgentState {
        private long lastStatsTime;
        private int msgCount = 0;

        private ProducerState() {
        }

        @Override
        public long getLastStatsTime() {
            return this.lastStatsTime;
        }

        protected void setLastStatsTime(long lastStatsTime) {
            this.lastStatsTime = lastStatsTime;
        }

        @Override
        public int getMsgCount() {
            return this.msgCount;
        }

        protected void setMsgCount(int msgCount) {
            this.msgCount = msgCount;
        }

        @Override
        public int incrementMessageCount() {
            return ++this.msgCount;
        }
    }
}

