/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.perf.CommandLineProxy;
import com.rabbitmq.perf.Metrics;
import com.rabbitmq.perf.PerfTest;
import com.rabbitmq.perf.Utils;
import com.sun.net.httpserver.HttpServer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class PrometheusMetrics
implements Metrics {
    private volatile HttpServer server;
    private volatile PrometheusMeterRegistry registry;

    @Override
    public Options options() {
        Options options = new Options();
        options.addOption(new Option("mpr", "metrics-prometheus", false, "enable Prometheus metrics"));
        options.addOption(new Option("mpe", "metrics-prometheus-endpoint", true, "the HTTP metrics endpoint, default is /metrics"));
        options.addOption(new Option("mpp", "metrics-prometheus-port", true, "the port to launch the HTTP metrics endpoint on, default is 8080"));
        return options;
    }

    @Override
    public void configure(Metrics.ConfigurationContext context) throws Exception {
        CommandLineProxy cmd = context.cmd();
        CompositeMeterRegistry meterRegistry = context.meterRegistry();
        if (this.isEnabled(cmd)) {
            this.registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            meterRegistry.add((MeterRegistry)this.registry);
            int prometheusHttpEndpointPort = PerfTest.intArg(cmd, "mpp", 8080);
            String prometheusHttpEndpoint = Utils.strArg(cmd, "mpe", "metrics");
            prometheusHttpEndpoint = prometheusHttpEndpoint.startsWith("/") ? prometheusHttpEndpoint : "/" + prometheusHttpEndpoint;
            this.server = HttpServer.create(new InetSocketAddress(prometheusHttpEndpointPort), 0);
            this.server.createContext(prometheusHttpEndpoint, exchange -> {
                exchange.getResponseHeaders().set("Content-Type", "text/plain");
                byte[] content = this.registry.scrape().getBytes(StandardCharsets.UTF_8);
                exchange.sendResponseHeaders(200, content.length);
                try (OutputStream out = exchange.getResponseBody();){
                    out.write(content);
                }
            });
            this.server.start();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.server != null) {
            this.server.stop(0);
        }
        if (this.registry != null) {
            this.registry.close();
        }
    }

    public String toString() {
        return "Prometheus Metrics";
    }
}

