/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.perf.MessageBodySource;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;

class RandomJsonMessageBodySource
implements MessageBodySource {
    public static final String DIGITS = "0123456789";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final long ZERO = 0L;
    private static final String CONTENT_TYPE = "application/json";
    private static final String UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LOWER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase(Locale.ROOT);
    public static final String ALPHANUM = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" + LOWER + "0123456789";
    private final byte[][] bodies;

    RandomJsonMessageBodySource(int bodySize, int fieldValueCount, int bodyCount) {
        this.bodies = new byte[bodyCount][];
        ArrayList fields = new ArrayList(fieldValueCount);
        ArrayList values = new ArrayList(fieldValueCount);
        Random random = new Random();
        int maxSize = 200;
        char[] buf = new char[maxSize];
        char[] fieldsSymbols = LOWER.toCharArray();
        char[] valuesSymbols = ALPHANUM.toCharArray();
        IntStream.range(0, fieldValueCount).forEach(i -> {
            fields.add(RandomJsonMessageBodySource.random(random, buf, 30, fieldsSymbols));
            values.add(RandomJsonMessageBodySource.random(random, buf, maxSize, valuesSymbols));
        });
        ArrayList shuffledFields = new ArrayList(fields);
        IntStream.range(0, bodyCount).forEach(i -> {
            StringBuilder builder = new StringBuilder("{ ");
            Collections.shuffle(shuffledFields);
            Iterator fieldsIterator = shuffledFields.iterator();
            while (true) {
                if (!fieldsIterator.hasNext()) {
                    fieldsIterator = shuffledFields.iterator();
                }
                builder.append("\"").append((String)fieldsIterator.next()).append("\" : ");
                builder.append("\"").append((String)values.get(random.nextInt(values.size()))).append("\"");
                if (builder.length() >= bodySize) break;
                builder.append(",");
            }
            builder.append(" }");
            this.bodies[i] = builder.toString().getBytes(CHARSET);
        });
    }

    private static String random(Random random, char[] buf, int maxSize, char[] symbols) {
        int size = random.nextInt(maxSize - 4) + 5;
        for (int idx = 0; idx < size; ++idx) {
            buf[idx] = symbols[random.nextInt(symbols.length)];
        }
        return new String(buf, 0, size);
    }

    @Override
    public MessageBodySource.MessageEnvelope create(int sequenceNumber) {
        return new MessageBodySource.MessageEnvelope(this.bodies[ThreadLocalRandom.current().nextInt(this.bodies.length)], CONTENT_TYPE, 0L);
    }

    byte[][] bodies() {
        return this.bodies;
    }
}

