/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class RateLimiterUtils {
    private RateLimiterUtils() {
    }

    static class GuavaPreconditions {
        GuavaPreconditions() {
        }

        static <T> T checkNotNull(T reference, Object errorMessage) {
            if (reference == null) {
                throw new NullPointerException(String.valueOf(errorMessage));
            }
            return reference;
        }

        static void checkState(boolean expression, Object errorMessage) {
            if (!expression) {
                throw new IllegalStateException(String.valueOf(errorMessage));
            }
        }

        static void checkArgument(boolean b, String errorMessageTemplate, long p1) {
            if (!b) {
                throw new IllegalArgumentException(GuavaPreconditions.lenientFormat(errorMessageTemplate, p1));
            }
        }

        static String lenientFormat(String template, Object ... args) {
            int placeholderStart;
            template = String.valueOf(template);
            if (args == null) {
                args = new Object[]{"(Object[])null"};
            } else {
                for (int i = 0; i < args.length; ++i) {
                    args[i] = GuavaPreconditions.lenientToString(args[i]);
                }
            }
            StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
            int templateStart = 0;
            int i = 0;
            while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
                builder.append(template, templateStart, placeholderStart);
                builder.append(args[i++]);
                templateStart = placeholderStart + 2;
            }
            builder.append(template, templateStart, template.length());
            if (i < args.length) {
                builder.append(" [");
                builder.append(args[i++]);
                while (i < args.length) {
                    builder.append(", ");
                    builder.append(args[i++]);
                }
                builder.append(']');
            }
            return builder.toString();
        }

        private static String lenientToString(Object o) {
            if (o == null) {
                return "null";
            }
            try {
                return o.toString();
            }
            catch (Exception e) {
                String objectToString = o.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(o));
                Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, "Exception during lenientFormat for " + objectToString, e);
                return "<" + objectToString + " threw " + e.getClass().getName() + ">";
            }
        }

        static <T> T checkNotNull(T reference) {
            if (reference == null) {
                throw new NullPointerException();
            }
            return reference;
        }

        static void checkArgument(boolean expression, Object errorMessage) {
            if (!expression) {
                throw new IllegalArgumentException(String.valueOf(errorMessage));
            }
        }
    }

    static abstract class Ticker {
        private static final Ticker SYSTEM_TICKER = new Ticker(){

            @Override
            public long read() {
                return System.nanoTime();
            }
        };

        protected Ticker() {
        }

        abstract long read();

        static Ticker systemTicker() {
            return SYSTEM_TICKER;
        }
    }

    static final class Stopwatch {
        private final Ticker ticker;
        private boolean isRunning;
        private long elapsedNanos;
        private long startTick;

        static Stopwatch createUnstarted() {
            return new Stopwatch();
        }

        static Stopwatch createUnstarted(Ticker ticker) {
            return new Stopwatch(ticker);
        }

        static Stopwatch createStarted() {
            return new Stopwatch().start();
        }

        static Stopwatch createStarted(Ticker ticker) {
            return new Stopwatch(ticker).start();
        }

        Stopwatch() {
            this.ticker = Ticker.systemTicker();
        }

        Stopwatch(Ticker ticker) {
            this.ticker = GuavaPreconditions.checkNotNull(ticker, "ticker");
        }

        boolean isRunning() {
            return this.isRunning;
        }

        Stopwatch start() {
            GuavaPreconditions.checkState(!this.isRunning, "This stopwatch is already running.");
            this.isRunning = true;
            this.startTick = this.ticker.read();
            return this;
        }

        Stopwatch stop() {
            long tick = this.ticker.read();
            GuavaPreconditions.checkState(this.isRunning, "This stopwatch is already stopped.");
            this.isRunning = false;
            this.elapsedNanos += tick - this.startTick;
            return this;
        }

        Stopwatch reset() {
            this.elapsedNanos = 0L;
            this.isRunning = false;
            return this;
        }

        private long elapsedNanos() {
            return this.isRunning ? this.ticker.read() - this.startTick + this.elapsedNanos : this.elapsedNanos;
        }

        long elapsed(TimeUnit desiredUnit) {
            return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
        }

        Duration elapsed() {
            return Duration.ofNanos(this.elapsedNanos());
        }

        public String toString() {
            long nanos = this.elapsedNanos();
            TimeUnit unit = Stopwatch.chooseUnit(nanos);
            double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
            return String.format(Locale.ROOT, "%.4g", value) + " " + Stopwatch.abbreviate(unit);
        }

        private static TimeUnit chooseUnit(long nanos) {
            if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.DAYS;
            }
            if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.HOURS;
            }
            if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.MINUTES;
            }
            if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.SECONDS;
            }
            if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.MILLISECONDS;
            }
            if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
                return TimeUnit.MICROSECONDS;
            }
            return TimeUnit.NANOSECONDS;
        }

        private static String abbreviate(TimeUnit unit) {
            switch (unit) {
                case NANOSECONDS: {
                    return "ns";
                }
                case MICROSECONDS: {
                    return "\u03bcs";
                }
                case MILLISECONDS: {
                    return "ms";
                }
                case SECONDS: {
                    return "s";
                }
                case MINUTES: {
                    return "min";
                }
                case HOURS: {
                    return "h";
                }
                case DAYS: {
                    return "d";
                }
            }
            throw new AssertionError();
        }
    }

    static abstract class SmoothRateLimiter
    extends RateLimiter {
        double storedPermits;
        double maxPermits;
        double stableIntervalMicros;
        private long nextFreeTicketMicros = 0L;

        private SmoothRateLimiter(RateLimiter.SleepingStopwatch stopwatch) {
            super(stopwatch);
        }

        @Override
        final void doSetRate(double permitsPerSecond, long nowMicros) {
            double stableIntervalMicros;
            this.resync(nowMicros);
            this.stableIntervalMicros = stableIntervalMicros = (double)TimeUnit.SECONDS.toMicros(1L) / permitsPerSecond;
            this.doSetRate(permitsPerSecond, stableIntervalMicros);
        }

        abstract void doSetRate(double var1, double var3);

        @Override
        final double doGetRate() {
            return (double)TimeUnit.SECONDS.toMicros(1L) / this.stableIntervalMicros;
        }

        @Override
        final long queryEarliestAvailable(long nowMicros) {
            return this.nextFreeTicketMicros;
        }

        @Override
        final long reserveEarliestAvailable(int requiredPermits, long nowMicros) {
            this.resync(nowMicros);
            long returnValue = this.nextFreeTicketMicros;
            double storedPermitsToSpend = Math.min((double)requiredPermits, this.storedPermits);
            double freshPermits = (double)requiredPermits - storedPermitsToSpend;
            long waitMicros = this.storedPermitsToWaitTime(this.storedPermits, storedPermitsToSpend) + (long)(freshPermits * this.stableIntervalMicros);
            this.nextFreeTicketMicros = SmoothRateLimiter.saturatedAdd(this.nextFreeTicketMicros, waitMicros);
            this.storedPermits -= storedPermitsToSpend;
            return returnValue;
        }

        abstract long storedPermitsToWaitTime(double var1, double var3);

        abstract double coolDownIntervalMicros();

        void resync(long nowMicros) {
            if (nowMicros > this.nextFreeTicketMicros) {
                double newPermits = (double)(nowMicros - this.nextFreeTicketMicros) / this.coolDownIntervalMicros();
                this.storedPermits = Math.min(this.maxPermits, this.storedPermits + newPermits);
                this.nextFreeTicketMicros = nowMicros;
            }
        }

        private static long saturatedAdd(long a, long b) {
            long naiveSum;
            if ((a ^ b) < 0L | (a ^ (naiveSum = a + b)) >= 0L) {
                return naiveSum;
            }
            return Long.MAX_VALUE + (naiveSum >>> 63 ^ 1L);
        }

        static final class SmoothBursty
        extends SmoothRateLimiter {
            final double maxBurstSeconds;

            SmoothBursty(RateLimiter.SleepingStopwatch stopwatch, double maxBurstSeconds) {
                super(stopwatch);
                this.maxBurstSeconds = maxBurstSeconds;
            }

            @Override
            void doSetRate(double permitsPerSecond, double stableIntervalMicros) {
                double oldMaxPermits = this.maxPermits;
                this.maxPermits = this.maxBurstSeconds * permitsPerSecond;
                this.storedPermits = oldMaxPermits == Double.POSITIVE_INFINITY ? this.maxPermits : (oldMaxPermits == 0.0 ? 0.0 : this.storedPermits * this.maxPermits / oldMaxPermits);
            }

            @Override
            long storedPermitsToWaitTime(double storedPermits, double permitsToTake) {
                return 0L;
            }

            @Override
            double coolDownIntervalMicros() {
                return this.stableIntervalMicros;
            }
        }

        static final class SmoothWarmingUp
        extends SmoothRateLimiter {
            private final long warmupPeriodMicros;
            private double slope;
            private double thresholdPermits;
            private double coldFactor;

            SmoothWarmingUp(RateLimiter.SleepingStopwatch stopwatch, long warmupPeriod, TimeUnit timeUnit, double coldFactor) {
                super(stopwatch);
                this.warmupPeriodMicros = timeUnit.toMicros(warmupPeriod);
                this.coldFactor = coldFactor;
            }

            @Override
            void doSetRate(double permitsPerSecond, double stableIntervalMicros) {
                double oldMaxPermits = this.maxPermits;
                double coldIntervalMicros = stableIntervalMicros * this.coldFactor;
                this.thresholdPermits = 0.5 * (double)this.warmupPeriodMicros / stableIntervalMicros;
                this.maxPermits = this.thresholdPermits + 2.0 * (double)this.warmupPeriodMicros / (stableIntervalMicros + coldIntervalMicros);
                this.slope = (coldIntervalMicros - stableIntervalMicros) / (this.maxPermits - this.thresholdPermits);
                this.storedPermits = oldMaxPermits == Double.POSITIVE_INFINITY ? 0.0 : (oldMaxPermits == 0.0 ? this.maxPermits : this.storedPermits * this.maxPermits / oldMaxPermits);
            }

            @Override
            long storedPermitsToWaitTime(double storedPermits, double permitsToTake) {
                double availablePermitsAboveThreshold = storedPermits - this.thresholdPermits;
                long micros = 0L;
                if (availablePermitsAboveThreshold > 0.0) {
                    double permitsAboveThresholdToTake = Math.min(availablePermitsAboveThreshold, permitsToTake);
                    double length = this.permitsToTime(availablePermitsAboveThreshold) + this.permitsToTime(availablePermitsAboveThreshold - permitsAboveThresholdToTake);
                    micros = (long)(permitsAboveThresholdToTake * length / 2.0);
                    permitsToTake -= permitsAboveThresholdToTake;
                }
                return micros += (long)(this.stableIntervalMicros * permitsToTake);
            }

            private double permitsToTime(double permits) {
                return this.stableIntervalMicros + permits * this.slope;
            }

            @Override
            double coolDownIntervalMicros() {
                return (double)this.warmupPeriodMicros / this.maxPermits;
            }
        }
    }

    static abstract class RateLimiter {
        private final SleepingStopwatch stopwatch;
        private volatile Object mutexDoNotUseDirectly;

        static RateLimiter create(double permitsPerSecond) {
            return RateLimiter.create(permitsPerSecond, SleepingStopwatch.createFromSystemTimer());
        }

        static RateLimiter create(double permitsPerSecond, SleepingStopwatch stopwatch) {
            SmoothRateLimiter.SmoothBursty rateLimiter = new SmoothRateLimiter.SmoothBursty(stopwatch, 1.0);
            rateLimiter.setRate(permitsPerSecond);
            return rateLimiter;
        }

        static RateLimiter create(double permitsPerSecond, Duration warmupPeriod) {
            return RateLimiter.create(permitsPerSecond, RateLimiter.toNanosSaturated(warmupPeriod), TimeUnit.NANOSECONDS);
        }

        static RateLimiter create(double permitsPerSecond, long warmupPeriod, TimeUnit unit) {
            GuavaPreconditions.checkArgument(warmupPeriod >= 0L, "warmupPeriod must not be negative: %s", warmupPeriod);
            return RateLimiter.create(permitsPerSecond, warmupPeriod, unit, 3.0, SleepingStopwatch.createFromSystemTimer());
        }

        static RateLimiter create(double permitsPerSecond, long warmupPeriod, TimeUnit unit, double coldFactor, SleepingStopwatch stopwatch) {
            SmoothRateLimiter.SmoothWarmingUp rateLimiter = new SmoothRateLimiter.SmoothWarmingUp(stopwatch, warmupPeriod, unit, coldFactor);
            rateLimiter.setRate(permitsPerSecond);
            return rateLimiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object mutex() {
            Object mutex = this.mutexDoNotUseDirectly;
            if (mutex == null) {
                RateLimiter rateLimiter = this;
                synchronized (rateLimiter) {
                    mutex = this.mutexDoNotUseDirectly;
                    if (mutex == null) {
                        this.mutexDoNotUseDirectly = mutex = new Object();
                    }
                }
            }
            return mutex;
        }

        RateLimiter(SleepingStopwatch stopwatch) {
            this.stopwatch = GuavaPreconditions.checkNotNull(stopwatch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setRate(double permitsPerSecond) {
            GuavaPreconditions.checkArgument(permitsPerSecond > 0.0 && !Double.isNaN(permitsPerSecond), "rate must be positive");
            Object object = this.mutex();
            synchronized (object) {
                this.doSetRate(permitsPerSecond, this.stopwatch.readMicros());
            }
        }

        abstract void doSetRate(double var1, long var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final double getRate() {
            Object object = this.mutex();
            synchronized (object) {
                return this.doGetRate();
            }
        }

        abstract double doGetRate();

        double acquire() {
            return this.acquire(1);
        }

        double acquire(int permits) {
            long microsToWait = this.reserve(permits);
            this.stopwatch.sleepMicrosUninterruptibly(microsToWait);
            return 1.0 * (double)microsToWait / (double)TimeUnit.SECONDS.toMicros(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final long reserve(int permits) {
            RateLimiter.checkPermits(permits);
            Object object = this.mutex();
            synchronized (object) {
                return this.reserveAndGetWaitLength(permits, this.stopwatch.readMicros());
            }
        }

        boolean tryAcquire(Duration timeout) {
            return this.tryAcquire(1, RateLimiter.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
        }

        boolean tryAcquire(long timeout, TimeUnit unit) {
            return this.tryAcquire(1, timeout, unit);
        }

        boolean tryAcquire(int permits) {
            return this.tryAcquire(permits, 0L, TimeUnit.MICROSECONDS);
        }

        boolean tryAcquire() {
            return this.tryAcquire(1, 0L, TimeUnit.MICROSECONDS);
        }

        boolean tryAcquire(int permits, Duration timeout) {
            return this.tryAcquire(permits, RateLimiter.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
            long microsToWait;
            long timeoutMicros = Math.max(unit.toMicros(timeout), 0L);
            RateLimiter.checkPermits(permits);
            Object object = this.mutex();
            synchronized (object) {
                long nowMicros = this.stopwatch.readMicros();
                if (!this.canAcquire(nowMicros, timeoutMicros)) {
                    return false;
                }
                microsToWait = this.reserveAndGetWaitLength(permits, nowMicros);
            }
            this.stopwatch.sleepMicrosUninterruptibly(microsToWait);
            return true;
        }

        private boolean canAcquire(long nowMicros, long timeoutMicros) {
            return this.queryEarliestAvailable(nowMicros) - timeoutMicros <= nowMicros;
        }

        final long reserveAndGetWaitLength(int permits, long nowMicros) {
            long momentAvailable = this.reserveEarliestAvailable(permits, nowMicros);
            return Math.max(momentAvailable - nowMicros, 0L);
        }

        abstract long queryEarliestAvailable(long var1);

        abstract long reserveEarliestAvailable(int var1, long var2);

        public String toString() {
            return String.format(Locale.ROOT, "RateLimiter[stableRate=%3.1fqps]", this.getRate());
        }

        static void sleepUninterruptibly(long sleepFor, TimeUnit unit) {
            boolean interrupted = false;
            try {
                long remainingNanos = unit.toNanos(sleepFor);
                long end = System.nanoTime() + remainingNanos;
                while (true) {
                    try {
                        TimeUnit.NANOSECONDS.sleep(remainingNanos);
                        return;
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        remainingNanos = end - System.nanoTime();
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private static void checkPermits(int permits) {
            GuavaPreconditions.checkArgument(permits > 0, "Requested permits (%s) must be positive", permits);
        }

        private static long toNanosSaturated(Duration duration) {
            try {
                return duration.toNanos();
            }
            catch (ArithmeticException tooBig) {
                return duration.isNegative() ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
        }

        static abstract class SleepingStopwatch {
            protected SleepingStopwatch() {
            }

            protected abstract long readMicros();

            protected abstract void sleepMicrosUninterruptibly(long var1);

            static SleepingStopwatch createFromSystemTimer() {
                return new SleepingStopwatch(){
                    final Stopwatch stopwatch = Stopwatch.createStarted();

                    @Override
                    protected long readMicros() {
                        return this.stopwatch.elapsed(TimeUnit.MICROSECONDS);
                    }

                    @Override
                    protected void sleepMicrosUninterruptibly(long micros) {
                        if (micros > 0L) {
                            RateLimiter.sleepUninterruptibly(micros, TimeUnit.MICROSECONDS);
                        }
                    }
                };
            }
        }
    }
}

