/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.rabbitmq.perf.AgentBase;
import com.rabbitmq.perf.TopologyRecording;
import com.rabbitmq.perf.Utils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recovery {
    public static final RecoveryProcess NO_OP_RECOVERY_PROCESS = new RecoveryProcess(){

        @Override
        public void init(AgentBase agent) {
        }

        @Override
        public boolean isRecoverying() {
            return false;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(Recovery.class);

    static RecoveryProcess setupRecoveryProcess(final Connection connection, final TopologyRecording topologyRecording) {
        if (Utils.isRecoverable(connection)) {
            final AtomicBoolean recoveryInProgress = new AtomicBoolean(false);
            final AtomicReference agentReference = new AtomicReference();
            RecoveryProcess recoveryProcess = new RecoveryProcess(){

                @Override
                public void init(AgentBase agent) {
                    agentReference.set(agent);
                    agent.setTopologyRecording(topologyRecording);
                }

                @Override
                public boolean isRecoverying() {
                    return recoveryInProgress.get();
                }

                @Override
                public boolean isEnabled() {
                    return true;
                }
            };
            ((AutorecoveringConnection)connection).addRecoveryListener(new RecoveryListener(){

                public void handleRecoveryStarted(Recoverable recoverable) {
                    recoveryInProgress.set(true);
                }

                public void handleRecovery(Recoverable recoverable) {
                    LOGGER.debug("Starting topology recovery for connection {}", (Object)connection.getClientProvidedName());
                    topologyRecording.recover(connection);
                    LOGGER.debug("Topology recovery done for connection {}, starting agent recovery", (Object)connection.getClientProvidedName());
                    ((AgentBase)agentReference.get()).recover(topologyRecording);
                    recoveryInProgress.set(false);
                    LOGGER.debug("Connection recovery done for connection {}", (Object)connection.getClientProvidedName());
                }
            });
            connection.addShutdownListener(cause -> {
                if (AutorecoveringConnection.DEFAULT_CONNECTION_RECOVERY_TRIGGERING_CONDITION.test(cause)) {
                    LOGGER.debug("Setting recovery in progress flag for connection {}", (Object)connection.getClientProvidedName());
                    recoveryInProgress.set(true);
                }
            });
            return recoveryProcess;
        }
        return NO_OP_RECOVERY_PROCESS;
    }

    static interface RecoveryProcess {
        public void init(AgentBase var1);

        public boolean isRecoverying();

        public boolean isEnabled();
    }
}

