/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.perf.MulticastParams;
import com.rabbitmq.perf.ScenarioStats;
import com.rabbitmq.perf.Stats;
import com.rabbitmq.perf.metrics.PerformanceMetrics;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SimpleScenarioStats
extends Stats
implements ScenarioStats,
PerformanceMetrics {
    private static final int IGNORE_FIRST = 3;
    private final List<Map<String, Object>> samples = new ArrayList<Map<String, Object>>();
    private long elapsedTotalToIgnore;
    private long minMsgSize;

    public SimpleScenarioStats(long interval) {
        super(Duration.ofMillis(interval));
    }

    @Override
    protected synchronized void report(long now) {
        if (this.samples.size() == 3) {
            this.cumulativeLatencyTotal.set(0L);
            this.latencyCountTotal.set(0L);
            this.sendCountTotal.set(0L);
            this.recvCountTotal.set(0L);
            this.elapsedTotalToIgnore = this.elapsedTotal.get();
        }
        HashMap<String, Number> sample = new HashMap<String, Number>();
        long elapsedTime = Duration.ofNanos(this.elapsedInterval.get()).toMillis();
        sample.put("send-msg-rate", this.rate(this.sendCountInterval.get(), elapsedTime));
        sample.put("send-bytes-rate", this.rate(this.sendCountInterval.get(), elapsedTime) * (double)this.minMsgSize);
        sample.put("recv-msg-rate", this.rate(this.recvCountInterval.get(), elapsedTime));
        sample.put("recv-bytes-rate", this.rate(this.recvCountInterval.get(), elapsedTime) * (double)this.minMsgSize);
        sample.put("elapsed", this.elapsedTotal.get() / 1000000L);
        if (this.latencyCountInterval.get() > 0L) {
            sample.put("avg-latency", this.intervalAverageLatency());
            sample.put("min-latency", this.minLatency.get() / 1000L);
            sample.put("max-latency", this.maxLatency.get() / 1000L);
        }
        this.samples.add(sample);
    }

    @Override
    public Map<String, Object> results() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("send-msg-rate", this.getSendRate());
        map.put("send-bytes-rate", this.getSendRate() * (double)this.minMsgSize);
        map.put("recv-msg-rate", this.getRecvRate());
        map.put("recv-bytes-rate", this.getRecvRate() * (double)this.minMsgSize);
        if (this.latencyCountTotal.get() > 0L) {
            map.put("avg-latency", this.overallAverageLatency());
        }
        map.put("samples", this.samples);
        return map;
    }

    public void setup(MulticastParams params) {
        this.minMsgSize = params.getMinMsgSize();
    }

    public double getSendRate() {
        return this.rate(this.sendCountTotal.get(), this.elapsedTotal.get() - this.elapsedTotalToIgnore);
    }

    public double getRecvRate() {
        return this.rate(this.recvCountTotal.get(), this.elapsedTotal.get() - this.elapsedTotalToIgnore);
    }

    private double rate(long count, long elapsed) {
        return elapsed == 0L ? 0.0 : (double)(1.0E9f * (float)count / (float)elapsed);
    }

    private long overallAverageLatency() {
        return this.cumulativeLatencyTotal.get() / (1000L * this.latencyCountTotal.get());
    }

    private long intervalAverageLatency() {
        return this.cumulativeLatencyInterval.get() / (1000L * this.latencyCountInterval.get());
    }

    @Override
    public void start() {
    }

    @Override
    public void published() {
        this.handleSend();
    }

    @Override
    public void confirmed(int count, long[] latencies) {
        this.handleConfirm(count, latencies);
    }

    @Override
    public void nacked(int count) {
        this.handleNack(count);
    }

    @Override
    public void returned() {
        this.handleReturn();
    }

    @Override
    public void received(long latency) {
        this.handleRecv(latency);
    }

    @Override
    public Duration interval() {
        return this.interval();
    }

    @Override
    public void maybeResetGauges() {
        super.maybeResetGauges();
    }

    @Override
    public void resetGlobals() {
        super.resetGlobals();
    }
}

