/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.rabbitmq.perf.metrics.PerformanceMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;

public abstract class Stats {
    protected static final float NANO_TO_SECOND = 1.0E9f;
    private final AtomicBoolean ongoingReport = new AtomicBoolean(false);
    private final long intervalInNanoSeconds;
    protected final long startTime;
    protected final AtomicLong startTimeForGlobals = new AtomicLong(0L);
    private final DoubleAccumulator published;
    private final DoubleAccumulator returned;
    private final DoubleAccumulator confirmed;
    private final DoubleAccumulator nacked;
    private final DoubleAccumulator consumed;
    private final Consumer<Long> updateLatency;
    private final Consumer<Long> updateConfirmLatency;
    private AtomicLong lastPublishedCount = new AtomicLong(0L);
    private AtomicLong lastReturnedCount = new AtomicLong(0L);
    private AtomicLong lastConfirmedCount = new AtomicLong(0L);
    private AtomicLong lastNackedCount = new AtomicLong(0L);
    private AtomicLong lastConsumedCount = new AtomicLong(0L);
    protected AtomicLong lastStatsTime = new AtomicLong(0L);
    protected AtomicLong sendCountInterval = new AtomicLong(0L);
    protected AtomicLong returnCountInterval = new AtomicLong(0L);
    protected AtomicLong confirmCountInterval = new AtomicLong(0L);
    protected AtomicLong nackCountInterval = new AtomicLong(0L);
    protected AtomicLong recvCountInterval = new AtomicLong(0L);
    protected AtomicLong sendCountTotal = new AtomicLong(0L);
    protected AtomicLong recvCountTotal = new AtomicLong(0L);
    protected AtomicLong latencyCountInterval = new AtomicLong(0L);
    protected AtomicLong latencyCountTotal = new AtomicLong(0L);
    protected AtomicLong minLatency = new AtomicLong(0L);
    protected AtomicLong maxLatency = new AtomicLong(0L);
    protected AtomicLong cumulativeLatencyInterval = new AtomicLong(0L);
    protected AtomicLong cumulativeLatencyTotal = new AtomicLong(0L);
    protected AtomicLong elapsedInterval = new AtomicLong(0L);
    protected AtomicLong elapsedTotal = new AtomicLong(0L);
    protected Histogram latency = new MetricRegistry().histogram("latency");
    protected Histogram confirmLatency = new MetricRegistry().histogram("confirm-latency");
    protected final AtomicReference<Histogram> globalLatency = new AtomicReference<Histogram>(new MetricRegistry().histogram("latency"));
    protected final AtomicReference<Histogram> globalConfirmLatency = new AtomicReference<Histogram>(new MetricRegistry().histogram("confirm-latency"));
    private final PerformanceMetrics performanceMetrics;

    public Stats(Duration interval) {
        this(interval, false, (MeterRegistry)new SimpleMeterRegistry(), null, PerformanceMetrics.NO_OP);
    }

    public Stats(Duration interval, boolean useMs, MeterRegistry registry, String metricsPrefix) {
        this(interval, useMs, registry, metricsPrefix, PerformanceMetrics.NO_OP);
    }

    public Stats(Duration interval, boolean useMs, MeterRegistry registry, String metricsPrefix, PerformanceMetrics performanceMetrics) {
        this.intervalInNanoSeconds = interval.toNanos();
        this.startTime = System.nanoTime();
        this.startTimeForGlobals.set(this.startTime);
        this.performanceMetrics = performanceMetrics;
        this.performanceMetrics.start();
        metricsPrefix = metricsPrefix == null ? "" : metricsPrefix;
        Timer latencyTimer = Timer.builder((String)(metricsPrefix + "latency")).description("message latency").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).distributionStatisticExpiry(Duration.ofNanos(this.intervalInNanoSeconds)).serviceLevelObjectives(new Duration[0]).register(registry);
        Timer confirmLatencyTimer = Timer.builder((String)(metricsPrefix + "confirm.latency")).description("confirm latency").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).distributionStatisticExpiry(Duration.ofNanos(this.intervalInNanoSeconds)).serviceLevelObjectives(new Duration[0]).register(registry);
        DoubleBinaryOperator accumulatorFunction = (x, y) -> y;
        this.published = (DoubleAccumulator)registry.gauge(metricsPrefix + "published", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.returned = (DoubleAccumulator)registry.gauge(metricsPrefix + "returned", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.confirmed = (DoubleAccumulator)registry.gauge(metricsPrefix + "confirmed", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.nacked = (DoubleAccumulator)registry.gauge(metricsPrefix + "nacked", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.consumed = (DoubleAccumulator)registry.gauge(metricsPrefix + "consumed", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.updateLatency = useMs ? latency -> latencyTimer.record(latency.longValue(), TimeUnit.MILLISECONDS) : latency -> latencyTimer.record(latency.longValue(), TimeUnit.NANOSECONDS);
        this.updateConfirmLatency = useMs ? latency -> confirmLatencyTimer.record(latency.longValue(), TimeUnit.MILLISECONDS) : latency -> confirmLatencyTimer.record(latency.longValue(), TimeUnit.NANOSECONDS);
        this.reset(this.startTime);
    }

    private void reset(long t) {
        this.lastStatsTime.set(t);
        this.resetLastCounts();
        this.sendCountInterval.set(0L);
        this.returnCountInterval.set(0L);
        this.confirmCountInterval.set(0L);
        this.nackCountInterval.set(0L);
        this.recvCountInterval.set(0L);
        this.minLatency.set(Long.MAX_VALUE);
        this.maxLatency.set(Long.MIN_VALUE);
        this.latencyCountInterval.set(0L);
        this.cumulativeLatencyInterval.set(0L);
        this.latency = new MetricRegistry().histogram("latency");
        this.confirmLatency = new MetricRegistry().histogram("confirm-latency");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report() {
        long now = System.nanoTime();
        this.elapsedInterval.set(now - this.lastStatsTime.get());
        if (this.elapsedInterval.get() >= this.intervalInNanoSeconds) {
            this.elapsedTotal.addAndGet(this.elapsedInterval.get());
            if (this.ongoingReport.compareAndSet(false, true)) {
                Stats stats = this;
                synchronized (stats) {
                    this.report(now);
                    this.reset(now);
                }
                this.ongoingReport.set(false);
            }
        }
    }

    protected abstract void report(long var1);

    public void handleSend() {
        this.performanceMetrics.published();
        this.sendCountInterval.incrementAndGet();
        this.sendCountTotal.incrementAndGet();
        this.report();
    }

    public void handleReturn() {
        this.returnCountInterval.incrementAndGet();
        this.report();
    }

    public void handleConfirm(int numConfirms, long[] latencies) {
        this.confirmCountInterval.addAndGet(numConfirms);
        for (long latency : latencies) {
            this.confirmLatency.update(latency);
            this.globalConfirmLatency.get().update(latency);
            this.updateConfirmLatency.accept(latency);
        }
        this.report();
    }

    public void handleNack(int numAcks) {
        this.nackCountInterval.addAndGet(numAcks);
        this.report();
    }

    public void handleRecv(long latency) {
        this.recvCountInterval.incrementAndGet();
        this.recvCountTotal.incrementAndGet();
        if (latency > 0L) {
            this.latency.update(latency);
            this.globalLatency.get().update(latency);
            this.updateLatency.accept(latency);
            this.minLatency.set(Math.min(this.minLatency.get(), latency));
            this.maxLatency.set(Math.max(this.maxLatency.get(), latency));
            this.cumulativeLatencyInterval.addAndGet(latency);
            this.cumulativeLatencyTotal.addAndGet(latency);
            this.latencyCountInterval.incrementAndGet();
            this.latencyCountTotal.incrementAndGet();
        }
        this.report();
    }

    protected void published(double rate) {
        this.published.accumulate(rate);
    }

    protected void returned(double rate) {
        this.returned.accumulate(rate);
    }

    protected void confirmed(double rate) {
        this.confirmed.accumulate(rate);
    }

    protected void nacked(double rate) {
        this.nacked.accumulate(rate);
    }

    protected void received(double rate) {
        this.consumed.accumulate(rate);
    }

    synchronized void maybeResetGauges() {
        if (this.noActivity()) {
            long now = System.nanoTime();
            this.elapsedInterval.set(now - this.lastStatsTime.get());
            if (this.elapsedInterval.get() >= 2L * this.intervalInNanoSeconds) {
                this.published.accumulate(0.0);
                this.returned.accumulate(0.0);
                this.confirmed.accumulate(0.0);
                this.nacked.accumulate(0.0);
                this.consumed.accumulate(0.0);
            }
        } else {
            this.resetLastCounts();
        }
    }

    private boolean noActivity() {
        return this.lastPublishedCount.get() == this.sendCountInterval.get() && this.lastReturnedCount.get() == this.returnCountInterval.get() && this.lastConfirmedCount.get() == this.confirmCountInterval.get() && this.lastNackedCount.get() == this.nackCountInterval.get() && this.lastConsumedCount.get() == this.recvCountInterval.get();
    }

    private void resetLastCounts() {
        this.lastPublishedCount.set(this.sendCountInterval.get());
        this.lastReturnedCount.set(this.returnCountInterval.get());
        this.lastConfirmedCount.set(this.confirmCountInterval.get());
        this.lastNackedCount.set(this.nackCountInterval.get());
        this.lastConsumedCount.set(this.recvCountInterval.get());
    }

    void resetGlobals() {
        this.sendCountTotal.set(0L);
        this.recvCountTotal.set(0L);
        this.startTimeForGlobals.set(System.nanoTime());
    }

    Duration interval() {
        return Duration.ofNanos(this.intervalInNanoSeconds);
    }
}

