/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.perf.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyRecording {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopologyRecording.class);
    private final ConcurrentMap<String, RecordedExchange> exchanges = new ConcurrentHashMap<String, RecordedExchange>();
    private final ConcurrentMap<String, RecordedQueue> queues = new ConcurrentHashMap<String, RecordedQueue>();
    private final Collection<RecordedBinding> bindings = new CopyOnWriteArrayList<RecordedBinding>();
    private final Collection<TopologyRecording> children = new CopyOnWriteArrayList<TopologyRecording>();
    private final boolean polling;
    private final boolean cluster;

    public TopologyRecording(boolean polling, boolean cluster) {
        this.polling = polling;
        this.cluster = cluster;
    }

    private static Channel reliableWrite(Connection connection, Channel channel, WriteOperation operation) throws IOException {
        return TopologyRecording.reliableWrite(connection, channel, operation, () -> "");
    }

    private static Channel reliableWrite(Connection connection, Channel channel, WriteOperation operation, Supplier<String> message) throws IOException {
        try {
            operation.write(channel);
            return channel;
        }
        catch (Exception e) {
            LOGGER.warn("Error during topology recovery: {}", (Object)e.getMessage());
            String msg = message.get();
            if (msg != null && !msg.isEmpty()) {
                LOGGER.debug(msg);
            }
            return connection.createChannel();
        }
    }

    TopologyRecording child() {
        TopologyRecording child = new TopologyRecording(this.polling, this.cluster);
        this.children.add(child);
        return child;
    }

    Collection<RecordedQueue> queues() {
        ArrayList<RecordedQueue> queues = new ArrayList<RecordedQueue>(this.queues.values());
        for (TopologyRecording child : this.children) {
            queues.addAll(child.queues());
        }
        return queues;
    }

    public RecordedExchange recordExchange(String name, String type) {
        this.exchanges.putIfAbsent(name, new RecordedExchange(name, type));
        return (RecordedExchange)this.exchanges.get(name);
    }

    public RecordedQueue recordQueue(String name, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments, boolean serverNamed) {
        this.queues.putIfAbsent(name, new RecordedQueue(name, durable, exclusive, autoDelete, arguments, serverNamed));
        return (RecordedQueue)this.queues.get(name);
    }

    public RecordedBinding recordBinding(String queue, String exchange, String routingKey) {
        RecordedBinding binding = new RecordedBinding(queue, exchange, routingKey);
        this.bindings.add(binding);
        return binding;
    }

    public RecordedQueue queue(String name) {
        return (RecordedQueue)this.queues.get(name);
    }

    public RecordedExchange exchange(String name) {
        return (RecordedExchange)this.exchanges.get(name);
    }

    private Collection<RecordedBinding> getBindingsFor(String queue) {
        return this.bindings.stream().filter(b -> ((RecordedBinding)b).queue.equals(queue)).collect(Collectors.toList());
    }

    public TopologyRecording subRecording(Collection<String> queues) {
        TopologyRecording clientTopologyRecording = this.child();
        for (String queue : queues) {
            RecordedQueue recordedQueue = this.lookupQueueInHierarchy(queue);
            if (recordedQueue == null) {
                throw new IllegalArgumentException("Not able to sub-record queue " + queue + ", it is not in the parent recording");
            }
            clientTopologyRecording.queues.putIfAbsent(queue, recordedQueue);
            for (RecordedBinding binding : this.getBindingsFor(queue)) {
                clientTopologyRecording.bindings.add(binding);
                clientTopologyRecording.exchanges.put(binding.getExchange(), (RecordedExchange)this.exchanges.get(binding.getExchange()));
            }
        }
        return clientTopologyRecording;
    }

    private RecordedQueue lookupQueueInHierarchy(String queue) {
        RecordedQueue recordedQueue;
        block1: {
            TopologyRecording child;
            recordedQueue = (RecordedQueue)this.queues.get(queue);
            if (recordedQueue != null) break block1;
            Iterator<TopologyRecording> iterator = this.children.iterator();
            while (iterator.hasNext() && (recordedQueue = (child = iterator.next()).lookupQueueInHierarchy(queue)) == null) {
            }
        }
        return recordedQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(Connection connection) {
        try {
            RecordedQueue queue;
            Channel channel = connection.createChannel();
            for (Map.Entry entry : this.queues.entrySet()) {
                queue = (RecordedQueue)entry.getValue();
                channel = this.recoverQueue(channel, queue);
            }
            for (RecordedExchange exchange : this.exchanges.values()) {
                LOGGER.debug("Connection {}, recovering exchange {}", (Object)connection.getClientProvidedName(), (Object)exchange);
                channel = TopologyRecording.reliableWrite(connection, channel, ch -> Utils.exchangeDeclare(ch, exchange.name, exchange.type));
                LOGGER.debug("Connection {}, recovered exchange {}", (Object)connection.getClientProvidedName(), (Object)exchange);
            }
            for (RecordedBinding binding : this.bindings) {
                Object lock;
                String queueName;
                LOGGER.debug("Connection {}, recovering binding {}", (Object)connection.getClientProvidedName(), (Object)binding);
                queue = (RecordedQueue)this.queues.get(binding.queue);
                if (queue == null) {
                    queueName = binding.queue;
                    lock = new Object();
                } else {
                    queueName = queue.name;
                    lock = queue;
                }
                RecordedQueue recordedQueue = lock;
                synchronized (recordedQueue) {
                    channel = TopologyRecording.reliableWrite(connection, channel, ch -> ch.queueBind(queueName, binding.exchange, binding.routingKeyIsQueue() ? queueName : binding.routingKey));
                }
                LOGGER.debug("Connection {}, recovered binding {}", (Object)connection.getClientProvidedName(), (Object)binding);
            }
            channel.close();
        }
        catch (Exception e) {
            LOGGER.warn("Error during topology recovery for connection {}: {}", (Object)connection.getClientProvidedName(), (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel recoverQueue(Channel channel, RecordedQueue queue) throws IOException {
        Connection connection = channel.getConnection();
        RecordedQueue recordedQueue = queue;
        synchronized (recordedQueue) {
            String originalName = queue.name;
            LOGGER.debug("Connection {}, recovering queue {}", (Object)connection.getClientProvidedName(), (Object)queue);
            boolean redeclare = true;
            if (queue.durable && queue.serverNamed && !queue.autoDelete && !queue.exclusive) {
                try {
                    channel.queueDeclarePassive(queue.name);
                    redeclare = false;
                }
                catch (IOException e) {
                    redeclare = true;
                    channel = connection.createChannel();
                }
            }
            if (redeclare) {
                LOGGER.debug("Trying to re-declare queue {}", (Object)originalName);
                channel = TopologyRecording.reliableWrite(connection, channel, ch -> {
                    String newName = ch.queueDeclare(queue.serverNamed ? "" : queue.name, queue.durable, queue.exclusive, queue.autoDelete, queue.arguments).getQueue();
                    LOGGER.debug("Re-declared queue {}", (Object)originalName);
                    queue.name = newName;
                    if (queue.serverNamed) {
                        LOGGER.debug("Queue {} was server-named, it is now {}", (Object)originalName, (Object)newName);
                    }
                }, () -> "Error while trying to re-declare queue " + originalName);
            }
            LOGGER.debug("Connection {}, recovered queue {}", (Object)connection.getClientProvidedName(), (Object)queue);
            if (this.polling && queue.autoDelete && queue.serverNamed && !queue.exclusive) {
                channel = TopologyRecording.reliableWrite(connection, channel, ch -> ch.queueDelete(originalName));
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverQueueAndBindings(Connection connection, RecordedQueue queueRecord) {
        Channel ch = null;
        try {
            ch = connection.createChannel();
            String oldQueueName = queueRecord.name();
            ch = this.recoverQueue(ch, queueRecord);
            String newQueueName = queueRecord.name();
            Collection<RecordedBinding> bindingsForQ = this.getBindingsFor(oldQueueName);
            for (RecordedBinding binding : bindingsForQ) {
                ch.queueBind(newQueueName, binding.getExchange(), binding.routingKeyIsQueue() ? newQueueName : binding.routingKey);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception during Queue and Binding recovery for connection {}: {}", (Object)connection.getClientProvidedName(), (Object)e.getMessage());
        }
        finally {
            if (ch != null) {
                try {
                    ch.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    boolean isCluster() {
        return this.cluster;
    }

    class RecordedBinding {
        private final String queue;
        private final String exchange;
        private final String routingKey;

        RecordedBinding(String queue, String exchange, String routingKey) {
            this.queue = queue;
            this.exchange = exchange;
            this.routingKey = routingKey;
        }

        public String getExchange() {
            return this.exchange;
        }

        public boolean routingKeyIsQueue() {
            return this.queue.equals(this.routingKey);
        }

        public String toString() {
            return "RecordedBinding{queue='" + this.queue + '\'' + ", exchange='" + this.exchange + '\'' + ", routingKey='" + this.routingKey + '\'' + '}';
        }
    }

    class RecordedQueue {
        private final boolean durable;
        private final boolean exclusive;
        private final boolean autoDelete;
        private final Map<String, Object> arguments;
        private final boolean serverNamed;
        private String name;

        private RecordedQueue(String name, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments, boolean serverNamed) {
            this.name = name;
            this.durable = durable;
            this.exclusive = exclusive;
            this.autoDelete = autoDelete;
            this.arguments = arguments == null ? Collections.emptyMap() : arguments;
            this.serverNamed = serverNamed;
        }

        public String name() {
            return this.name;
        }

        public boolean isAutoDelete() {
            return this.autoDelete;
        }

        public boolean isServerNamed() {
            return this.serverNamed;
        }

        public boolean isExclusive() {
            return this.exclusive;
        }

        boolean isQuorum() {
            return "quorum".equals(this.arguments.get("x-queue-type"));
        }

        boolean isStream() {
            return "stream".equals(this.arguments.get("x-queue-type"));
        }

        boolean isClassic() {
            return !this.isQuorum() && !this.isStream();
        }

        boolean isDurable() {
            return this.durable;
        }

        public Map<String, Object> getArguments() {
            return this.arguments;
        }

        public String toString() {
            return "RecordedQueue{name='" + this.name + '\'' + ", durable=" + this.durable + ", exclusive=" + this.exclusive + ", autoDelete=" + this.autoDelete + ", arguments=" + this.arguments + ", serverNamed=" + this.serverNamed + '}';
        }
    }

    class RecordedExchange {
        private final String name;
        private final String type;

        RecordedExchange(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return "RecordedExchange{name='" + this.name + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }

    @FunctionalInterface
    private static interface WriteOperation {
        public void write(Channel var1) throws IOException;
    }
}

