/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.RecoveryDelayHandler;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.SocketConfigurator;
import com.rabbitmq.client.SocketConfigurators;
import com.rabbitmq.client.SslEngineConfigurator;
import com.rabbitmq.client.SslEngineConfigurators;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import com.rabbitmq.perf.CommandLineProxy;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Utils {
    static final Future<?> NO_OP_FUTURE = new Future<Object>(){

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final ConnectionFactory CF = new ConnectionFactory();

    Utils() {
    }

    static boolean isRecoverable(Connection connection) {
        return connection instanceof AutorecoveringConnection;
    }

    static synchronized Address extract(String uri) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        CF.setUri(uri);
        return new Address(CF.getHost(), CF.getPort());
    }

    static RecoveryDelayHandler getRecoveryDelayHandler(String argument) {
        RecoveryDelayHandler handler;
        if (argument == null || argument.trim().isEmpty()) {
            return null;
        }
        argument = argument.trim();
        Pattern pattern = Pattern.compile("(\\d+)(-(\\d+))?");
        Matcher matcher = pattern.matcher(argument);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Incorrect argument for connection recovery interval. Must be e.g. 30 or 30-60.");
        }
        long delay = Long.parseLong(matcher.group(1)) * 1000L;
        if (matcher.group(2) == null) {
            handler = recoveryAttempts -> delay;
        } else {
            long maxInput = Long.parseLong(matcher.group(2).replace("-", "")) * 1000L;
            if (maxInput <= delay) {
                throw new IllegalArgumentException("Wrong interval min-max values: " + argument);
            }
            long maxDelay = maxInput + 1000L;
            handler = recoveryAttempts -> ThreadLocalRandom.current().nextLong(delay, maxDelay);
        }
        return handler;
    }

    static List<SNIServerName> sniServerNames(String argumentValue) {
        if (argumentValue != null && !argumentValue.trim().isEmpty()) {
            return Arrays.stream(argumentValue.split(",")).map(s -> s.trim()).map(s -> new SNIHostName((String)s)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static SocketConfigurator socketConfigurator(CommandLineProxy cmd) {
        List<SNIServerName> serverNames = Utils.sniServerNames(Utils.strArg(cmd, "sni", null));
        if (serverNames.isEmpty()) {
            return SocketConfigurators.defaultConfigurator();
        }
        SocketConfigurator socketConfigurator = socket -> {
            if (socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)socket;
                SSLParameters sslParameters = sslSocket.getSSLParameters() == null ? new SSLParameters() : sslSocket.getSSLParameters();
                sslParameters.setServerNames(serverNames);
                sslSocket.setSSLParameters(sslParameters);
            } else {
                LOGGER.warn("SNI parameter set on a non-TLS connection");
            }
        };
        return SocketConfigurators.defaultConfigurator().andThen(socketConfigurator);
    }

    static SslEngineConfigurator sslEngineConfigurator(CommandLineProxy cmd) {
        List<SNIServerName> serverNames = Utils.sniServerNames(Utils.strArg(cmd, "sni", null));
        if (serverNames.isEmpty()) {
            return SslEngineConfigurators.DEFAULT;
        }
        SslEngineConfigurator sslEngineConfigurator = sslEngine -> {
            SSLParameters sslParameters = sslEngine.getSSLParameters() == null ? new SSLParameters() : sslEngine.getSSLParameters();
            sslParameters.setServerNames(serverNames);
            sslEngine.setSSLParameters(sslParameters);
        };
        return SslEngineConfigurators.defaultConfigurator().andThen(sslEngineConfigurator);
    }

    static String strArg(CommandLineProxy cmd, String opt, String def) {
        return cmd.getOptionValue(opt, def);
    }

    static String strArg(CommandLineProxy cmd, char opt, String def) {
        return cmd.getOptionValue(opt, def);
    }

    static void exchangeDeclare(Channel channel, String exchange, String type) throws IOException {
        if ("".equals(exchange) || exchange.startsWith("amq.")) {
            LOGGER.info("Skipping creation of exchange {}", (Object)exchange);
        }
        channel.exchangeDeclare(exchange, type);
    }

    static boolean exists(Connection connection, Checker checker) throws IOException {
        try {
            Channel ch = connection.createChannel();
            checker.check(ch);
            ch.abort();
            return true;
        }
        catch (IOException e) {
            AMQP.Channel.Close closeMethod;
            ShutdownSignalException sse = (ShutdownSignalException)e.getCause();
            if (!sse.isHardError() && (closeMethod = (AMQP.Channel.Close)sse.getReason()).getReplyCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    static interface Checker {
        public void check(Channel var1) throws IOException;
    }
}

