/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.perf.MulticastParams;
import com.rabbitmq.perf.MulticastSet;
import com.rabbitmq.perf.PerfTest;
import com.rabbitmq.perf.Scenario;
import com.rabbitmq.perf.ScenarioStats;
import com.rabbitmq.perf.SimpleScenarioStats;
import com.rabbitmq.perf.Variable;
import com.rabbitmq.perf.VariableValue;
import com.rabbitmq.perf.VaryingScenarioStats;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class VaryingScenario
implements Scenario {
    private final String name;
    private final ConnectionFactory factory;
    private final MulticastParams[] params;
    private final VaryingScenarioStats stats = new VaryingScenarioStats();
    private final Variable[] variables;

    public VaryingScenario(String name, ConnectionFactory factory, MulticastParams params, Variable ... variables) {
        this(name, factory, new MulticastParams[]{params}, variables);
    }

    public VaryingScenario(String name, ConnectionFactory factory, MulticastParams[] params, Variable ... variables) {
        this.name = name;
        this.factory = factory;
        this.params = params;
        this.variables = variables;
    }

    @Override
    public void run() throws Exception {
        this.run(this.variables, new ArrayList<VariableValue>());
    }

    /*
     * WARNING - void declaration
     */
    private void run(Variable[] variables, List<VariableValue> values) throws Exception {
        if (variables.length > 0) {
            Variable variable = variables[0];
            Variable[] rest = this.rest(variables);
            for (VariableValue variableValue : variable.getValues()) {
                ArrayList<VariableValue> values2 = new ArrayList<VariableValue>(values);
                values2.add(variableValue);
                this.run(rest, values2);
            }
        } else {
            void var6_11;
            SimpleScenarioStats stats0 = this.stats.next(values);
            MulticastParams[] multicastParamsArray = this.params;
            int n = multicastParamsArray.length;
            boolean bl = false;
            while (var6_11 < n) {
                MulticastParams p = multicastParamsArray[var6_11];
                for (VariableValue value : values) {
                    value.setup(p);
                }
                MulticastSet set = new MulticastSet(stats0, this.factory, p, null, PerfTest.getCompletionHandler(p, new ConcurrentHashMap<String, Integer>()));
                stats0.setup(p);
                set.run();
                for (VariableValue value : values) {
                    value.teardown(p);
                }
                ++var6_11;
            }
            System.out.print("#");
            System.out.flush();
        }
    }

    private Variable[] rest(Variable[] variables) {
        Variable[] tail = new Variable[variables.length - 1];
        System.arraycopy(variables, 1, tail, 0, tail.length);
        return tail;
    }

    @Override
    public ScenarioStats getStats() {
        return this.stats;
    }

    @Override
    public String getName() {
        return this.name;
    }

    Variable[] getVariables() {
        return this.variables;
    }
}

