/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf.metrics;

import com.rabbitmq.perf.metrics.MetricsFormatter;
import com.rabbitmq.perf.metrics.MetricsFormatterUtils;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

abstract class BaseMetricsFormatter
implements MetricsFormatter {
    protected final boolean publishedEnabled;
    protected final boolean receivedEnabled;
    protected final boolean returnedEnabled;
    protected final boolean confirmedEnabled;

    BaseMetricsFormatter(boolean publishedEnabled, boolean receivedEnabled, boolean returnedEnabled, boolean confirmedEnabled) {
        this.publishedEnabled = publishedEnabled;
        this.receivedEnabled = receivedEnabled;
        this.returnedEnabled = returnedEnabled;
        this.confirmedEnabled = confirmedEnabled;
    }

    protected boolean shouldDisplayConsumerLatency() {
        return this.receivedEnabled;
    }

    protected boolean shouldDisplayConfirmLatency() {
        return this.publishedEnabled && this.confirmedEnabled;
    }

    protected String summary(Duration elapsed, double ratePublished, double rateReceived, long[] consumedLatencyTotal, long[] confirmedLatencyTotal, String testId, TimeUnit latencyCollectionTimeUnit) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder summary = new StringBuilder();
        String lineBeginning = "";
        if (testId != null) {
            lineBeginning = "id: " + testId + ", ";
        }
        summary.append(lineBeginning).append("sending rate avg: " + MetricsFormatterUtils.formatRate(ratePublished) + " " + "msg/s");
        summary.append(lineSeparator);
        if (elapsed.toMillis() > 0L) {
            summary.append(lineBeginning).append("receiving rate avg: " + MetricsFormatterUtils.formatRate(rateReceived) + " " + "msg/s").append(lineSeparator);
            if (this.shouldDisplayConsumerLatency()) {
                summary.append(lineBeginning).append(String.format("consumer latency %s %s", "min/median/75th/95th/99th", MetricsFormatterUtils.formatLatency(consumedLatencyTotal, latencyCollectionTimeUnit))).append(lineSeparator);
            }
            if (this.shouldDisplayConfirmLatency()) {
                summary.append(lineBeginning).append(String.format("confirm latency %s %s", "min/median/75th/95th/99th", MetricsFormatterUtils.formatLatency(confirmedLatencyTotal, latencyCollectionTimeUnit))).append(lineSeparator);
            }
        }
        return summary.toString();
    }
}

