/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf.metrics;

import com.rabbitmq.perf.metrics.BaseMetricsFormatter;
import com.rabbitmq.perf.metrics.MetricsFormatter;
import com.rabbitmq.perf.metrics.MetricsFormatterUtils;
import java.io.PrintStream;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

class CompactPrintStreamMetricsFormatter
extends BaseMetricsFormatter
implements MetricsFormatter {
    private static final String TIME_FORMAT = "%-10s";
    private static final String RATE_FORMAT = "%13s";
    private static final String LATENCY_FORMAT = "%23s";
    private static final int MAX_ALIGNED_LATENCY = 22;
    private final PrintStream out;
    private final TimeUnit latencyCollectionTimeUnit;

    CompactPrintStreamMetricsFormatter(PrintStream out, boolean publishedEnabled, boolean receivedEnabled, boolean returnedEnabled, boolean confirmedEnabled, TimeUnit latencyCollectionTimeUnit) {
        super(publishedEnabled, receivedEnabled, returnedEnabled, confirmedEnabled);
        if (latencyCollectionTimeUnit != TimeUnit.MILLISECONDS && latencyCollectionTimeUnit != TimeUnit.NANOSECONDS) {
            throw new IllegalArgumentException("Latency collection unit must be ms or ns, not " + (Object)((Object)latencyCollectionTimeUnit));
        }
        this.latencyCollectionTimeUnit = latencyCollectionTimeUnit;
        this.out = out;
    }

    @Override
    public void header() {
        StringBuilder builder = new StringBuilder().append(String.format(TIME_FORMAT, "time"));
        if (this.publishedEnabled) {
            builder.append(String.format(RATE_FORMAT, "sent"));
        }
        if (this.returnedEnabled) {
            builder.append(String.format(RATE_FORMAT, "returned"));
        }
        if (this.publishedEnabled && this.confirmedEnabled) {
            builder.append(String.format(RATE_FORMAT, "confirmed"));
            builder.append(String.format(RATE_FORMAT, "nacked"));
        }
        if (this.receivedEnabled) {
            builder.append(String.format(RATE_FORMAT, "received"));
        }
        if (this.shouldDisplayConsumerLatency()) {
            builder.append(String.format(LATENCY_FORMAT, "consumer latency"));
        }
        if (this.shouldDisplayConfirmLatency()) {
            builder.append(String.format(LATENCY_FORMAT, "confirm latency"));
        }
        this.out.println(builder);
    }

    @Override
    public void report(Duration durationSinceStart, double publishedRate, double confirmedRate, double nackedRate, double returnedRate, double receivedRate, long[] confirmedLatencyStats, long[] consumerLatencyStats) {
        String latency;
        StringBuilder builder = new StringBuilder().append(String.format(TIME_FORMAT, MetricsFormatterUtils.formatTime(durationSinceStart) + "s"));
        if (this.publishedEnabled) {
            builder.append(String.format(RATE_FORMAT, MetricsFormatterUtils.formatRate(publishedRate) + " " + "msg/s"));
        }
        if (this.returnedEnabled) {
            builder.append(String.format(RATE_FORMAT, MetricsFormatterUtils.formatRate(returnedRate) + " " + "msg/s"));
        }
        if (this.publishedEnabled && this.confirmedEnabled) {
            builder.append(String.format(RATE_FORMAT, MetricsFormatterUtils.formatRate(confirmedRate) + " " + "msg/s"));
            builder.append(String.format(RATE_FORMAT, MetricsFormatterUtils.formatRate(nackedRate) + " " + "msg/s"));
        }
        if (this.receivedEnabled) {
            builder.append(String.format(RATE_FORMAT, MetricsFormatterUtils.formatRate(receivedRate) + " " + "msg/s"));
        }
        boolean latencyOverflow = false;
        if (this.shouldDisplayConsumerLatency()) {
            latency = MetricsFormatterUtils.formatLatency(consumerLatencyStats, this.latencyCollectionTimeUnit);
            if (latency.length() > 22) {
                builder.append(" ").append(latency);
                latencyOverflow = true;
            } else {
                builder.append(String.format(LATENCY_FORMAT, latency));
            }
        }
        if (this.shouldDisplayConfirmLatency()) {
            latency = MetricsFormatterUtils.formatLatency(confirmedLatencyStats, this.latencyCollectionTimeUnit);
            if (latency.length() > 22 || latencyOverflow) {
                builder.append(" ").append(latency);
            } else {
                builder.append(String.format(LATENCY_FORMAT, latency));
            }
        }
        this.out.println(builder);
    }

    @Override
    public void summary(Duration elapsed, double ratePublished, double rateReceived, long[] consumedLatencyTotal, long[] confirmedLatencyTotal) {
        this.out.print(this.summary(elapsed, ratePublished, rateReceived, consumedLatencyTotal, confirmedLatencyTotal, null, this.latencyCollectionTimeUnit));
    }
}

