/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf.metrics;

import com.rabbitmq.perf.metrics.MetricsFormatter;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeMetricsFormatter
implements MetricsFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeMetricsFormatter.class);
    private final List<MetricsFormatter> delegates = new CopyOnWriteArrayList<MetricsFormatter>();

    public CompositeMetricsFormatter(MetricsFormatter ... formatters) {
        this.delegates.addAll(Arrays.asList(formatters));
    }

    private static <T> void iterate(List<T> delegates, Consumer<T> action, String description) {
        for (T delegate : delegates) {
            try {
                action.accept(delegate);
            }
            catch (Exception e) {
                LOGGER.warn("Error while executing '{}' on '{}' metrics collector: {}", new Object[]{description, delegate.getClass().getSimpleName(), e.getMessage()});
            }
        }
    }

    @Override
    public void header() {
        CompositeMetricsFormatter.iterate(this.delegates, MetricsFormatter::header, "header");
    }

    @Override
    public void report(Duration durationSinceStart, double publishedRate, double confirmedRate, double nackedRate, double returnedRate, double receivedRate, long[] confirmedLatencyStats, long[] consumerLatencyStats) {
        CompositeMetricsFormatter.iterate(this.delegates, f -> f.report(durationSinceStart, publishedRate, confirmedRate, nackedRate, returnedRate, receivedRate, confirmedLatencyStats, consumerLatencyStats), "report");
    }

    @Override
    public void summary(Duration elapsed, double ratePublished, double rateReceived, long[] consumedLatencyTotal, long[] confirmedLatencyTotal) {
        CompositeMetricsFormatter.iterate(this.delegates, f -> f.summary(elapsed, ratePublished, rateReceived, consumedLatencyTotal, confirmedLatencyTotal), "summary");
    }
}

