/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf.metrics;

import com.rabbitmq.perf.metrics.BaseMetricsFormatter;
import com.rabbitmq.perf.metrics.MetricsFormatter;
import com.rabbitmq.perf.metrics.MetricsFormatterUtils;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class CsvMetricsFormatter
extends BaseMetricsFormatter
implements MetricsFormatter {
    private final PrintWriter out;
    private final String testId;
    private final String unit;

    public CsvMetricsFormatter(PrintWriter out, String testId, boolean publishedEnabled, boolean receivedEnabled, boolean returnedEnabled, boolean confirmedEnabled, TimeUnit latencyCollectionTimeUnit) {
        super(publishedEnabled, receivedEnabled, returnedEnabled, confirmedEnabled);
        if (latencyCollectionTimeUnit != TimeUnit.MILLISECONDS && latencyCollectionTimeUnit != TimeUnit.NANOSECONDS) {
            throw new IllegalArgumentException("Latency collection unit must be ms or ns, not " + (Object)((Object)latencyCollectionTimeUnit));
        }
        this.unit = latencyCollectionTimeUnit == TimeUnit.MILLISECONDS ? "ms" : "\u00b5s";
        this.out = out;
        this.testId = testId;
    }

    private static String rate(double rate, boolean display) {
        if (display) {
            return MetricsFormatterUtils.formatRate(rate);
        }
        return "";
    }

    @Override
    public void header() {
        this.out.printf("id,time (s),published (msg/s),returned (msg/s),confirmed (msg/s),nacked (msg/s),received (msg/s),min consumer latency (%s),median consumer latency (%s),75th p. consumer latency (%s),95th p. consumer latency (%s),99th p. consumer latency (%s),min confirm latency (%s),median confirm latency (%s),75th p. confirm latency (%s),95th p. confirm latency (%s),99th p. confirm latency (%s)%n", this.unit, this.unit, this.unit, this.unit, this.unit, this.unit, this.unit, this.unit, this.unit, this.unit);
    }

    @Override
    public void report(Duration durationSinceStart, double publishedRate, double confirmedRate, double nackedRate, double returnedRate, double receivedRate, long[] confirmedLatencyStats, long[] consumerLatencyStats) {
        this.out.println(this.testId + "," + MetricsFormatterUtils.formatTime(durationSinceStart) + "," + CsvMetricsFormatter.rate(publishedRate, this.publishedEnabled) + "," + CsvMetricsFormatter.rate(returnedRate, this.publishedEnabled && this.returnedEnabled) + "," + CsvMetricsFormatter.rate(confirmedRate, this.publishedEnabled && this.confirmedEnabled) + "," + CsvMetricsFormatter.rate(nackedRate, this.publishedEnabled && this.confirmedEnabled) + "," + CsvMetricsFormatter.rate(receivedRate, this.receivedEnabled) + "," + (this.shouldDisplayConsumerLatency() ? consumerLatencyStats[0] + "," + consumerLatencyStats[1] + "," + consumerLatencyStats[2] + "," + consumerLatencyStats[3] + "," + consumerLatencyStats[4] + "," : ",,,,,") + (this.shouldDisplayConfirmLatency() ? confirmedLatencyStats[0] + "," + confirmedLatencyStats[1] + "," + confirmedLatencyStats[2] + "," + confirmedLatencyStats[3] + "," + confirmedLatencyStats[4] : ",,,,"));
    }

    @Override
    public void summary(Duration elapsed, double ratePublished, double rateReceived, long[] consumedLatencyTotal, long[] confirmedLatencyTotal) {
    }
}

