/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf.metrics;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.rabbitmq.perf.NamedThreadFactory;
import com.rabbitmq.perf.metrics.MetricsFormatter;
import com.rabbitmq.perf.metrics.PerformanceMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.function.DoubleBinaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPerformanceMetrics
implements PerformanceMetrics,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPerformanceMetrics.class);
    private static final float MS_TO_SECOND = 1000.0f;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicLong lastTick = new AtomicLong(-1L);
    private final AtomicLong startTime = new AtomicLong(-1L);
    private final AtomicLong published = new AtomicLong(0L);
    private final AtomicLong confirmed = new AtomicLong(0L);
    private final AtomicLong nacked = new AtomicLong(0L);
    private final AtomicLong returned = new AtomicLong(0L);
    private final AtomicLong received = new AtomicLong(0L);
    private final AtomicLong lastPublished = new AtomicLong(0L);
    private final AtomicLong lastConfirmed = new AtomicLong(0L);
    private final AtomicLong lastNacked = new AtomicLong(0L);
    private final AtomicLong lastReturned = new AtomicLong(0L);
    private final AtomicLong lastReceived = new AtomicLong(0L);
    private final AtomicLong startTimeForTotal = new AtomicLong(-1L);
    private final AtomicLong publishedTotal = new AtomicLong(0L);
    private final AtomicLong receivedTotal = new AtomicLong(0L);
    private final AtomicReference<Histogram> consumedLatencyTotal;
    private final AtomicReference<Histogram> confirmedLatencyTotal;
    private final DoubleAccumulator publishedRate;
    private final DoubleAccumulator confirmedRate;
    private final DoubleAccumulator nackedRate;
    private final DoubleAccumulator returnedRate;
    private final DoubleAccumulator receivedRate;
    private final Timer consumedLatencyTimer;
    private final Timer confirmedLatencyTimer;
    private final Duration interval;
    private final TimeUnit latencyCollectionTimeUnit;
    private final AtomicBoolean firstReport = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicReference<Histogram> consumedLatency;
    private final AtomicReference<Histogram> confirmedLatency;
    private final MetricsFormatter formatter;

    public DefaultPerformanceMetrics(Duration interval, TimeUnit latencyCollectionTimeUnit, MeterRegistry registry, String metricsPrefix, MetricsFormatter formatter) {
        this.interval = interval;
        if (latencyCollectionTimeUnit != TimeUnit.MILLISECONDS && latencyCollectionTimeUnit != TimeUnit.NANOSECONDS) {
            throw new IllegalArgumentException("Latency collection unit must be ms or ns, not " + (Object)((Object)latencyCollectionTimeUnit));
        }
        this.latencyCollectionTimeUnit = latencyCollectionTimeUnit;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new NamedThreadFactory("perf-test-metrics-scheduling-"));
        this.formatter = formatter;
        metricsPrefix = metricsPrefix == null ? "" : metricsPrefix;
        DoubleBinaryOperator accumulatorFunction = (x, y) -> y;
        this.publishedRate = (DoubleAccumulator)registry.gauge(metricsPrefix + "published", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.confirmedRate = (DoubleAccumulator)registry.gauge(metricsPrefix + "confirmed", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.nackedRate = (DoubleAccumulator)registry.gauge(metricsPrefix + "nacked", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.returnedRate = (DoubleAccumulator)registry.gauge(metricsPrefix + "returned", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.receivedRate = (DoubleAccumulator)registry.gauge(metricsPrefix + "consumed", (Number)new DoubleAccumulator(accumulatorFunction, 0.0));
        this.consumedLatencyTimer = DefaultPerformanceMetrics.timer(metricsPrefix + "latency", "message latency", this.interval, registry);
        this.confirmedLatencyTimer = DefaultPerformanceMetrics.timer(metricsPrefix + "confirm.latency", "confirm latency", this.interval, registry);
        this.consumedLatency = new AtomicReference<Histogram>(DefaultPerformanceMetrics.histogram());
        this.confirmedLatency = new AtomicReference<Histogram>(DefaultPerformanceMetrics.histogram());
        this.consumedLatencyTotal = new AtomicReference<Histogram>(DefaultPerformanceMetrics.histogram());
        this.confirmedLatencyTotal = new AtomicReference<Histogram>(DefaultPerformanceMetrics.histogram());
        this.startTime.set(System.nanoTime());
        this.lastTick.set(this.startTime.get());
        this.startTimeForTotal.set(this.startTime.get());
    }

    private static Histogram histogram() {
        return new Histogram((Reservoir)new ExponentiallyDecayingReservoir());
    }

    private static Timer timer(String name, String description, Duration expiry, MeterRegistry registry) {
        return Timer.builder((String)name).description(description).publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).distributionStatisticExpiry(expiry).serviceLevelObjectives(new Duration[0]).register(registry);
    }

    private static double rate(long count, long elapsedInMs) {
        return 1000.0f * (float)count / (float)elapsedInMs;
    }

    private static double swapAndCalculateRate(AtomicLong current, AtomicLong last, long elapsedTimeInMs) {
        long currentValue = current.get();
        long count = currentValue - last.get();
        last.set(currentValue);
        return DefaultPerformanceMetrics.rate(count, elapsedTimeInMs);
    }

    private static Runnable wrapInCatch(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.warn("Error while processing metrics", (Throwable)e);
            }
        };
    }

    @Override
    public void start() {
        this.startTime.set(System.nanoTime());
        this.lastTick.set(this.startTime.get());
        this.startTimeForTotal.set(this.startTime.get());
        this.scheduledExecutorService.scheduleAtFixedRate(DefaultPerformanceMetrics.wrapInCatch(() -> {
            if (this.closed.get()) {
                return;
            }
            if (this.noActivity()) {
                this.publishedRate.accumulate(0.0);
                this.confirmedRate.accumulate(0.0);
                this.nackedRate.accumulate(0.0);
                this.returnedRate.accumulate(0.0);
                this.receivedRate.accumulate(0.0);
                this.confirmedLatency.set(DefaultPerformanceMetrics.histogram());
                this.consumedLatency.set(DefaultPerformanceMetrics.histogram());
            } else {
                this.metrics(System.nanoTime());
            }
        }), this.interval.getSeconds(), this.interval.getSeconds(), TimeUnit.SECONDS);
    }

    void metrics(long currentTime) {
        Duration duration = Duration.ofNanos(currentTime - this.lastTick.get());
        this.lastTick.set(currentTime);
        Duration durationSinceStart = Duration.ofNanos(currentTime - this.startTime.get());
        long elapsedTimeInMs = duration.toMillis();
        double ratePublished = DefaultPerformanceMetrics.swapAndCalculateRate(this.published, this.lastPublished, elapsedTimeInMs);
        double rateConfirmed = DefaultPerformanceMetrics.swapAndCalculateRate(this.confirmed, this.lastConfirmed, elapsedTimeInMs);
        double rateNacked = DefaultPerformanceMetrics.swapAndCalculateRate(this.nacked, this.lastNacked, elapsedTimeInMs);
        double rateReturned = DefaultPerformanceMetrics.swapAndCalculateRate(this.returned, this.lastReturned, elapsedTimeInMs);
        double rateReceived = DefaultPerformanceMetrics.swapAndCalculateRate(this.received, this.lastReceived, elapsedTimeInMs);
        this.publishedRate.accumulate(ratePublished);
        this.confirmedRate.accumulate(rateConfirmed);
        this.nackedRate.accumulate(rateNacked);
        this.returnedRate.accumulate(rateReturned);
        this.receivedRate.accumulate(rateReceived);
        long[] confirmedLatencyStats = this.getStats(this.confirmedLatency.get());
        long[] consumedLatencyStats = this.getStats(this.consumedLatency.get());
        this.confirmedLatency.set(DefaultPerformanceMetrics.histogram());
        this.consumedLatency.set(DefaultPerformanceMetrics.histogram());
        if (!this.closed.get()) {
            if (this.firstReport.compareAndSet(false, true)) {
                this.formatter.header();
            }
            this.formatter.report(durationSinceStart, ratePublished, rateConfirmed, rateNacked, rateReturned, rateReceived, confirmedLatencyStats, consumedLatencyStats);
        }
    }

    private long[] getStats(Histogram histogram) {
        return new long[]{this.div(histogram.getSnapshot().getMin()), this.div(histogram.getSnapshot().getMedian()), this.div(histogram.getSnapshot().get75thPercentile()), this.div(histogram.getSnapshot().get95thPercentile()), this.div(histogram.getSnapshot().get99thPercentile())};
    }

    private long div(double p) {
        if (this.latencyCollectionTimeUnit == TimeUnit.MILLISECONDS) {
            return (long)p;
        }
        return (long)(p / 1000.0);
    }

    @Override
    public void published() {
        this.published.incrementAndGet();
        this.publishedTotal.incrementAndGet();
    }

    @Override
    public void confirmed(int count, long[] latencies) {
        this.confirmed.addAndGet(count);
        for (long latency : latencies) {
            this.confirmedLatencyTimer.record(latency, this.latencyCollectionTimeUnit);
            this.confirmedLatency.get().update(latency);
            this.confirmedLatencyTotal.get().update(latency);
        }
    }

    @Override
    public void nacked(int count) {
        this.nacked.addAndGet(count);
    }

    @Override
    public void returned() {
        this.returned.incrementAndGet();
    }

    @Override
    public void received(long latency) {
        this.received.incrementAndGet();
        this.receivedTotal.incrementAndGet();
        if (latency > 0L) {
            this.consumedLatencyTimer.record(latency, this.latencyCollectionTimeUnit);
            this.consumedLatency.get().update(latency);
            this.consumedLatencyTotal.get().update(latency);
        }
    }

    @Override
    public Duration interval() {
        return this.interval;
    }

    private boolean noActivity() {
        return this.published.get() == this.lastPublished.get() && this.confirmed.get() == this.lastConfirmed.get() && this.nacked.get() == this.lastNacked.get() && this.returned.get() == this.lastReturned.get() && this.received.get() == this.lastReceived.get();
    }

    private void printFinal() {
        long now = System.nanoTime();
        long st = this.startTimeForTotal.get();
        Duration elapsedDuration = Duration.ofNanos(now - st);
        long elapsed = elapsedDuration.toMillis();
        double ratePublished = (float)this.publishedTotal.get() * 1000.0f / (float)elapsed;
        double rateReceived = (float)this.receivedTotal.get() * 1000.0f / (float)elapsed;
        long[] consumeLatencyTotal = this.getStats(this.consumedLatencyTotal.get());
        long[] confirmedLatencyTotal = this.getStats(this.confirmedLatencyTotal.get());
        this.formatter.summary(elapsedDuration, ratePublished, rateReceived, consumeLatencyTotal, confirmedLatencyTotal);
    }

    @Override
    public void resetGlobals() {
        this.publishedTotal.set(0L);
        this.receivedTotal.set(0L);
        this.consumedLatencyTotal.set(DefaultPerformanceMetrics.histogram());
        this.confirmedLatencyTotal.set(DefaultPerformanceMetrics.histogram());
        this.startTimeForTotal.set(System.nanoTime());
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduledExecutorService.shutdownNow();
            this.printFinal();
        }
    }
}

