/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf.metrics;

import com.rabbitmq.perf.metrics.BaseMetricsFormatter;
import com.rabbitmq.perf.metrics.MetricsFormatter;
import com.rabbitmq.perf.metrics.MetricsFormatterUtils;
import java.io.PrintStream;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

class DefaultPrintStreamMetricsFormatter
extends BaseMetricsFormatter
implements MetricsFormatter {
    private final PrintStream out;
    private final String testId;
    private final TimeUnit latencyCollectionTimeUnit;

    DefaultPrintStreamMetricsFormatter(PrintStream out, String testId, boolean publishedEnabled, boolean receivedEnabled, boolean returnedEnabled, boolean confirmedEnabled, TimeUnit latencyCollectionTimeUnit) {
        super(publishedEnabled, receivedEnabled, returnedEnabled, confirmedEnabled);
        if (latencyCollectionTimeUnit != TimeUnit.MILLISECONDS && latencyCollectionTimeUnit != TimeUnit.NANOSECONDS) {
            throw new IllegalArgumentException("Latency collection unit must be ms or ns, not " + (Object)((Object)latencyCollectionTimeUnit));
        }
        this.latencyCollectionTimeUnit = latencyCollectionTimeUnit;
        this.out = out;
        this.testId = testId;
    }

    private static String formatRate(String label, double rate) {
        return ", " + label + ": " + MetricsFormatterUtils.formatRate(rate) + " " + "msg/s";
    }

    @Override
    public void header() {
    }

    @Override
    public void report(Duration durationSinceStart, double publishedRate, double confirmedRate, double nackedRate, double returnedRate, double receivedRate, long[] confirmedLatencyStats, long[] consumerLatencyStats) {
        StringBuilder builder = new StringBuilder().append(String.format("id: %s, ", this.testId)).append(String.format("time %s s", MetricsFormatterUtils.formatTime(durationSinceStart)));
        if (this.publishedEnabled) {
            builder.append(DefaultPrintStreamMetricsFormatter.formatRate("sent", publishedRate));
        }
        if (this.returnedEnabled) {
            builder.append(DefaultPrintStreamMetricsFormatter.formatRate("returned", returnedRate));
        }
        if (this.publishedEnabled && this.confirmedEnabled) {
            builder.append(DefaultPrintStreamMetricsFormatter.formatRate("confirmed", confirmedRate));
            builder.append(DefaultPrintStreamMetricsFormatter.formatRate("nacked", nackedRate));
        }
        if (this.receivedEnabled) {
            builder.append(DefaultPrintStreamMetricsFormatter.formatRate("received", receivedRate));
        }
        if (this.shouldDisplayConsumerLatency() || this.shouldDisplayConfirmLatency()) {
            builder.append(String.format(", %s ", "min/median/75th/95th/99th"));
        }
        if (this.shouldDisplayConsumerLatency()) {
            builder.append("consumer latency: " + this.formatLatency(consumerLatencyStats));
        }
        if (this.shouldDisplayConsumerLatency() && this.shouldDisplayConfirmLatency()) {
            builder.append(", ");
        }
        if (this.shouldDisplayConfirmLatency()) {
            builder.append("confirm latency: " + this.formatLatency(confirmedLatencyStats));
        }
        this.out.println(builder);
    }

    @Override
    public void summary(Duration elapsed, double ratePublished, double rateReceived, long[] consumedLatencyTotal, long[] confirmedLatencyTotal) {
        this.out.print(this.summary(elapsed, ratePublished, rateReceived, consumedLatencyTotal, confirmedLatencyTotal, this.testId, this.latencyCollectionTimeUnit));
    }

    private String formatLatency(long[] stats) {
        return MetricsFormatterUtils.formatLatency(stats, this.latencyCollectionTimeUnit);
    }
}

