/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf.metrics;

import com.rabbitmq.perf.metrics.CompactPrintStreamMetricsFormatter;
import com.rabbitmq.perf.metrics.DefaultPrintStreamMetricsFormatter;
import com.rabbitmq.perf.metrics.MetricsFormatter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MetricsFormatterFactory {
    private static final Map<String, Function<Context, MetricsFormatter>> FACTORIES = new ConcurrentHashMap<String, Function<Context, MetricsFormatter>>(){
        {
            this.put("default", context -> new DefaultPrintStreamMetricsFormatter(((Context)context).out, ((Context)context).testId, ((Context)context).publishedEnabled, ((Context)context).receivedEnabled, ((Context)context).returnedEnabled, ((Context)context).confirmedEnabled, ((Context)context).latencyCollectionTimeUnit));
            this.put("compact", context -> new CompactPrintStreamMetricsFormatter(((Context)context).out, ((Context)context).publishedEnabled, ((Context)context).receivedEnabled, ((Context)context).returnedEnabled, ((Context)context).confirmedEnabled, ((Context)context).latencyCollectionTimeUnit));
        }
    };

    public static List<String> types() {
        ArrayList<String> types = new ArrayList<String>(FACTORIES.keySet());
        Collections.sort(types);
        return types;
    }

    public static MetricsFormatter create(String type, Context context) {
        Function<Context, MetricsFormatter> factory = FACTORIES.get(type);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Unknown metrics formatter: %s. Possible values are %s.", type, MetricsFormatterFactory.types().stream().collect(Collectors.joining(", "))));
        }
        return factory.apply(context);
    }

    public static class Context {
        private final PrintStream out;
        private final String testId;
        private final boolean publishedEnabled;
        private final boolean receivedEnabled;
        private final boolean returnedEnabled;
        private final boolean confirmedEnabled;
        private final TimeUnit latencyCollectionTimeUnit;

        public Context(PrintStream out, String testId, boolean publishedEnabled, boolean receivedEnabled, boolean returnedEnabled, boolean confirmedEnabled, TimeUnit latencyCollectionTimeUnit) {
            this.out = out;
            this.testId = testId;
            this.publishedEnabled = publishedEnabled;
            this.receivedEnabled = receivedEnabled;
            this.returnedEnabled = returnedEnabled;
            this.confirmedEnabled = confirmedEnabled;
            this.latencyCollectionTimeUnit = latencyCollectionTimeUnit;
        }
    }
}

