/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.perf.metrics;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

abstract class MetricsFormatterUtils {
    static final String LATENCY_HEADER = "min/median/75th/95th/99th";
    static final String MESSAGE_RATE_LABEL = "msg/s";
    static final float NANO_TO_SECOND = 1.0E9f;

    private MetricsFormatterUtils() {
    }

    static String formatTime(Duration time) {
        return String.format("%.3f", Float.valueOf((float)time.toNanos() / 1.0E9f));
    }

    static String formatRate(double rate) {
        if (rate == 0.0) {
            return String.format("%d", (long)rate);
        }
        if (rate < 1.0) {
            return String.format("%1.2f", rate);
        }
        if (rate < 10.0) {
            return String.format("%1.1f", rate);
        }
        return String.format("%d", (long)rate);
    }

    static String formatLatency(long[] stats, TimeUnit latencyCollectionTimeUnit) {
        return String.format("%d/%d/%d/%d/%d %s", stats[0], stats[1], stats[2], stats[3], stats[4], MetricsFormatterUtils.unit(latencyCollectionTimeUnit));
    }

    private static String unit(TimeUnit latencyCollectionTimeUnit) {
        if (latencyCollectionTimeUnit == TimeUnit.MILLISECONDS) {
            return "ms";
        }
        if (latencyCollectionTimeUnit == TimeUnit.NANOSECONDS) {
            return "\u00b5s";
        }
        throw new IllegalArgumentException("Time unit not supported: " + (Object)((Object)latencyCollectionTimeUnit));
    }
}

