/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.Command;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.Frame;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.utility.BlockingValueOrException;
import com.rabbitmq.utility.SingleShotLinearTimer;
import java.io.IOException;

public abstract class AMQChannel {
    public final AMQConnection _connection;
    public final int _channelNumber;
    public AMQCommand.Assembler _commandAssembler = AMQCommand.newAssembler();
    public RpcContinuation _activeRpc = null;
    public volatile boolean _isOpen = true;

    public AMQChannel(AMQConnection connection, int channelNumber) {
        this._connection = connection;
        this._channelNumber = channelNumber;
    }

    public int getChannelNumber() {
        return this._channelNumber;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void handleFrame(Frame frame) throws IOException {
        AMQCommand command = this._commandAssembler.handleFrame(frame);
        if (command != null) {
            this._commandAssembler = AMQCommand.newAssembler();
            this.handleCompleteInboundCommand(command);
        }
    }

    public static IOException wrap(ShutdownSignalException ex) {
        IOException ioe = new IOException();
        ioe.initCause(ex);
        return ioe;
    }

    public AMQCommand exnWrappingRpc(Method m) throws IOException {
        try {
            return this.rpc(m);
        }
        catch (ShutdownSignalException ex) {
            throw AMQChannel.wrap(ex);
        }
    }

    public void handleCompleteInboundCommand(AMQCommand command) throws IOException {
        if (!this.processAsync(command)) {
            this.nextOutstandingRpc().handleCommand(command);
        }
    }

    public synchronized void enqueueRpc(RpcContinuation k) {
        if (this._activeRpc != null) {
            throw new IllegalStateException("cannot execute more than one synchronous AMQP command at a time");
        }
        this._activeRpc = k;
    }

    public synchronized void transmitAndEnqueue(Method m, RpcContinuation k) throws IOException {
        this.enqueueRpc(k);
        this.transmit(m);
    }

    public synchronized RpcContinuation nextOutstandingRpc() {
        RpcContinuation result = this._activeRpc;
        this._activeRpc = null;
        return result;
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public void ensureIsOpen() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("Attempt to use closed channel");
        }
    }

    public AMQCommand rpc(Method m) throws IOException, ShutdownSignalException {
        SimpleBlockingRpcContinuation k = new SimpleBlockingRpcContinuation();
        this.rpc(m, k);
        return (AMQCommand)k.getReply();
    }

    public synchronized void rpc(Method m, RpcContinuation k) throws IOException {
        this.ensureIsOpen();
        this.transmitAndEnqueue(m, k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQCommand quiescingRpc(Method m, int timeoutMillisec, final AMQCommand timeoutReply) throws IOException, ShutdownSignalException {
        SimpleBlockingRpcContinuation k = new SimpleBlockingRpcContinuation();
        this.transmitAndEnqueue(m, k);
        if (timeoutMillisec != 0) {
            SingleShotLinearTimer timer = new SingleShotLinearTimer();
            Runnable task = new Runnable(){

                public void run() {
                    try {
                        AMQChannel.this.handleCompleteInboundCommand(timeoutReply);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            timer.schedule(task, timeoutMillisec);
            try {
                AMQCommand aMQCommand = (AMQCommand)k.getReply();
                return aMQCommand;
            }
            finally {
                timer.cancel();
            }
        }
        return (AMQCommand)k.getReply();
    }

    public abstract boolean processAsync(Command var1) throws IOException;

    public String toString() {
        return "AMQChannel(" + this._connection + "," + this._channelNumber + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processShutdownSignal(ShutdownSignalException signal) {
        AMQChannel aMQChannel = this;
        synchronized (aMQChannel) {
            this.ensureIsOpen();
            this._isOpen = false;
        }
        RpcContinuation k = this.nextOutstandingRpc();
        if (k != null) {
            k.handleShutdownSignal(signal);
        }
    }

    public void transmit(Method m) throws IOException {
        new AMQCommand(m).transmit(this);
    }

    public AMQConnection getAMQConnection() {
        return this._connection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleBlockingRpcContinuation
    extends BlockingRpcContinuation<AMQCommand> {
        @Override
        public AMQCommand transformReply(AMQCommand command) {
            return command;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BlockingRpcContinuation<T>
    implements RpcContinuation {
        public final BlockingValueOrException<T, ShutdownSignalException> _blocker = new BlockingValueOrException();

        @Override
        public void handleCommand(AMQCommand command) {
            this._blocker.setValue(this.transformReply(command));
        }

        @Override
        public void handleShutdownSignal(ShutdownSignalException signal) {
            this._blocker.setException(signal);
        }

        public T getReply() throws ShutdownSignalException {
            return this._blocker.uninterruptibleGetValue();
        }

        public abstract T transformReply(AMQCommand var1);
    }

    public static interface RpcContinuation {
        public void handleCommand(AMQCommand var1);

        public void handleShutdownSignal(ShutdownSignalException var1);
    }
}

