/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.BackOffDelayPolicy;
import com.rabbitmq.stream.StreamDoesNotExistException;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.StreamNotAvailableException;
import com.rabbitmq.stream.impl.AsyncRetry;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.ConnectionStreamException;
import com.rabbitmq.stream.impl.DefaultExecutorServiceFactory;
import com.rabbitmq.stream.impl.ExecutorServiceFactory;
import com.rabbitmq.stream.impl.StreamConsumer;
import com.rabbitmq.stream.impl.StreamEnvironment;
import com.rabbitmq.stream.impl.StreamProducer;
import com.rabbitmq.stream.impl.TimeoutStreamException;
import com.rabbitmq.stream.impl.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProducersCoordinator {
    static final int MAX_PRODUCERS_PER_CLIENT = 256;
    static final int MAX_TRACKING_CONSUMERS_PER_CLIENT = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducersCoordinator.class);
    private final StreamEnvironment environment;
    private final Utils.ClientFactory clientFactory;
    private final int maxProducersByClient;
    private final int maxTrackingConsumersByClient;
    private final Function<Utils.ClientConnectionType, String> connectionNamingStrategy;
    private final AtomicLong managerIdSequence = new AtomicLong(0L);
    private final NavigableSet<ClientProducersManager> managers = new ConcurrentSkipListSet<ClientProducersManager>();
    private final AtomicLong trackerIdSequence = new AtomicLong(0L);
    private final boolean debug = false;
    private final List<ProducerTracker> producerTrackers = new CopyOnWriteArrayList<ProducerTracker>();
    private final ExecutorServiceFactory executorServiceFactory = new DefaultExecutorServiceFactory(Runtime.getRuntime().availableProcessors(), 10, "rabbitmq-stream-producer-connection-");
    private static final Predicate<Exception> RETRY_ON_TIMEOUT = e -> e instanceof TimeoutStreamException;

    ProducersCoordinator(StreamEnvironment environment, int maxProducersByClient, int maxTrackingConsumersByClient, Function<Utils.ClientConnectionType, String> connectionNamingStrategy, Utils.ClientFactory clientFactory) {
        this.environment = environment;
        this.clientFactory = clientFactory;
        this.maxProducersByClient = maxProducersByClient;
        this.maxTrackingConsumersByClient = maxTrackingConsumersByClient;
        this.connectionNamingStrategy = connectionNamingStrategy;
    }

    private static String keyForNode(Client.Broker broker) {
        return broker.getHost() + ":" + broker.getPort();
    }

    Runnable registerProducer(StreamProducer producer, String reference, String stream) {
        ProducerTracker tracker = new ProducerTracker(this.trackerIdSequence.getAndIncrement(), reference, stream, producer);
        return this.registerAgentTracker(tracker, stream);
    }

    Runnable registerTrackingConsumer(StreamConsumer consumer) {
        return this.registerAgentTracker(new TrackingConsumerTracker(this.trackerIdSequence.getAndIncrement(), consumer.stream(), consumer), consumer.stream());
    }

    private Runnable registerAgentTracker(AgentTracker tracker, String stream) {
        Client.Broker broker = this.getBrokerForProducer(stream);
        this.addToManager(broker, tracker);
        return tracker::cancel;
    }

    private void addToManager(Client.Broker node, AgentTracker tracker) {
        Client.ClientParameters clientParameters = this.environment.clientParametersCopy().host(node.getHost()).port(node.getPort()).executorServiceFactory(this.executorServiceFactory).dispatchingExecutorServiceFactory(Utils.NO_OP_EXECUTOR_SERVICE_FACTORY);
        ClientProducersManager pickedManager = null;
        while (pickedManager == null) {
            Iterator<ClientProducersManager> iterator = this.managers.iterator();
            while (iterator.hasNext()) {
                pickedManager = iterator.next();
                if (pickedManager.isClosed()) {
                    iterator.remove();
                    pickedManager = null;
                    continue;
                }
                if (node.equals(pickedManager.node) && !pickedManager.isFullFor(tracker)) break;
                pickedManager = null;
            }
            if (pickedManager == null) {
                String name = ProducersCoordinator.keyForNode(node);
                LOGGER.debug("Creating producer manager on {}", (Object)name);
                pickedManager = new ClientProducersManager(node, this.clientFactory, clientParameters);
                LOGGER.debug("Created producer manager on {}, id {}", (Object)name, (Object)pickedManager.id);
            }
            try {
                pickedManager.register(tracker);
                LOGGER.debug("Assigned {} tracker {} (stream '{}') to manager {} (node {}), subscription ID {}", new Object[]{tracker.type(), tracker.uniqueId(), tracker.stream(), pickedManager.id, pickedManager.name, tracker.identifiable() ? Byte.valueOf(tracker.id()) : "N/A"});
                this.managers.add(pickedManager);
            }
            catch (IllegalStateException e) {
                pickedManager = null;
            }
            catch (StreamNotAvailableException | ConnectionStreamException | ClientClosedException e) {
                if (pickedManager.isEmpty()) {
                    ClientProducersManager manager = pickedManager;
                    this.environment.execute(() -> manager.closeIfEmpty(), "Producer manager closing after timeout, producer %d on stream '%s'", tracker.uniqueId(), tracker.stream());
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (pickedManager != null) {
                    pickedManager.closeIfEmpty();
                }
                throw e;
            }
        }
    }

    private Client.Broker getBrokerForProducer(String stream) {
        Map metadata = this.environment.locatorOperation(Utils.namedFunction(c -> c.metadata(stream), "Candidate lookup to publish to '%s'", stream));
        if (metadata.size() == 0 || metadata.get(stream) == null) {
            throw new StreamDoesNotExistException(stream);
        }
        Client.StreamMetadata streamMetadata = (Client.StreamMetadata)metadata.get(stream);
        if (!streamMetadata.isResponseOk()) {
            if (streamMetadata.getResponseCode() == 2) {
                throw new StreamDoesNotExistException(stream);
            }
            throw new IllegalStateException("Could not get stream metadata, response code: " + streamMetadata.getResponseCode());
        }
        Client.Broker leader = streamMetadata.getLeader();
        if (leader == null) {
            throw new IllegalStateException("Not leader available for stream " + stream);
        }
        LOGGER.debug("Using client on {}:{} to publish to {}", new Object[]{leader.getHost(), leader.getPort(), stream});
        return leader;
    }

    void close() {
        Iterator<ClientProducersManager> iterator = this.managers.iterator();
        while (iterator.hasNext()) {
            ClientProducersManager manager = iterator.next();
            try {
                iterator.remove();
                manager.close();
            }
            catch (Exception e) {
                LOGGER.info("Error while closing manager {} connected to node {}: {}", new Object[]{manager.id, manager.name, e.getMessage()});
            }
        }
        try {
            this.executorServiceFactory.close();
        }
        catch (Exception e) {
            LOGGER.info("Error while closing executor service factory: {}", (Object)e.getMessage());
        }
    }

    int clientCount() {
        return this.managers.size();
    }

    int nodesConnected() {
        return this.managers.stream().map(m -> ((ClientProducersManager)m).name).collect(Collectors.toSet()).size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append(Utils.jsonField("client_count", this.managers.size())).append(",");
        builder.append(Utils.jsonField("producer_count", this.managers.stream().mapToInt(m -> ((ClientProducersManager)m).producers.size()).sum())).append(",");
        builder.append(Utils.jsonField("tracking_consumer_count", this.managers.stream().mapToInt(m -> ((ClientProducersManager)m).trackingConsumerTrackers.size()).sum())).append(",");
        builder.append(Utils.quote("clients")).append(" : [");
        builder.append(this.managers.stream().map(m -> {
            StringBuilder managerBuilder = new StringBuilder("{");
            managerBuilder.append(Utils.jsonField("id", ((ClientProducersManager)m).id)).append(",").append(Utils.jsonField("node", ((ClientProducersManager)m).name)).append(",").append(Utils.jsonField("producer_count", ((ClientProducersManager)m).producers.size())).append(",").append(Utils.jsonField("tracking_consumer_count", ((ClientProducersManager)m).trackingConsumerTrackers.size())).append(",");
            managerBuilder.append("\"producers\" : [");
            managerBuilder.append(((ClientProducersManager)m).producers.values().stream().map(p -> {
                StringBuilder producerBuilder = new StringBuilder("{");
                producerBuilder.append(Utils.jsonField("stream", p.stream())).append(",");
                producerBuilder.append(Utils.jsonField("producer_id", ((ProducerTracker)p).publisherId));
                return producerBuilder.append("}").toString();
            }).collect(Collectors.joining(",")));
            managerBuilder.append("],");
            managerBuilder.append("\"tracking_consumers\" : [");
            managerBuilder.append(((ClientProducersManager)m).trackingConsumerTrackers.stream().map(t -> {
                StringBuilder trackerBuilder = new StringBuilder("{");
                trackerBuilder.append(Utils.jsonField("stream", t.stream()));
                return trackerBuilder.append("}").toString();
            }).collect(Collectors.joining(",")));
            managerBuilder.append("]");
            return managerBuilder.append("}").toString();
        }).collect(Collectors.joining(",")));
        builder.append("]");
        return builder.append("}").toString();
    }

    private static /* synthetic */ String lambda$toString$9(ProducerTracker t) {
        StringBuilder b = new StringBuilder("{");
        b.append(Utils.quote("stream")).append(":").append(Utils.quote(t.stream)).append(",");
        b.append(Utils.quote("node")).append(":");
        Client client = null;
        ClientProducersManager manager = t.clientProducersManager;
        if (manager != null) {
            client = manager.client;
        }
        if (client == null) {
            b.append("null");
        } else {
            b.append(Utils.quote(client.getHost() + ":" + client.getPort()));
        }
        return b.append("}").toString();
    }

    private /* synthetic */ void lambda$registerAgentTracker$0(AgentTracker tracker) {
        if (tracker instanceof ProducerTracker) {
            try {
                this.producerTrackers.remove(tracker);
            }
            catch (Exception e) {
                LOGGER.debug("Error while removing producer tracker from list");
            }
        }
        tracker.cancel();
    }

    private static class ClientClosedException
    extends StreamException {
        public ClientClosedException() {
            super("Client already closed");
        }
    }

    private class ClientProducersManager
    implements Comparable<ClientProducersManager> {
        private final long id;
        private final String name;
        private final Client.Broker node;
        private final ConcurrentMap<Byte, ProducerTracker> producers;
        private final Set<AgentTracker> trackingConsumerTrackers;
        private final Map<String, Set<AgentTracker>> streamToTrackers;
        private final Client client;
        private final AtomicBoolean closed;

        private ClientProducersManager(Client.Broker node, Utils.ClientFactory cf, Client.ClientParameters clientParameters) {
            this.producers = new ConcurrentHashMap<Byte, ProducerTracker>(ProducersCoordinator.this.maxProducersByClient);
            this.trackingConsumerTrackers = ConcurrentHashMap.newKeySet(ProducersCoordinator.this.maxTrackingConsumersByClient);
            this.streamToTrackers = new ConcurrentHashMap<String, Set<AgentTracker>>();
            this.closed = new AtomicBoolean(false);
            this.id = ProducersCoordinator.this.managerIdSequence.getAndIncrement();
            this.name = ProducersCoordinator.keyForNode(node);
            this.node = node;
            AtomicReference<Client> ref = new AtomicReference<Client>();
            AtomicBoolean clientInitializedInManager = new AtomicBoolean(false);
            Client.PublishConfirmListener publishConfirmListener = (publisherId, publishingId) -> {
                ProducerTracker producerTracker = (ProducerTracker)this.producers.get(publisherId);
                if (producerTracker == null) {
                    LOGGER.info("Received publish confirm for unknown producer: {}", (Object)publisherId);
                } else {
                    producerTracker.producer.confirm(publishingId);
                }
            };
            Client.PublishErrorListener publishErrorListener = (publisherId, publishingId, errorCode) -> {
                ProducerTracker producerTracker = (ProducerTracker)this.producers.get(publisherId);
                if (producerTracker == null) {
                    LOGGER.info("Received publish error for unknown producer: {}, error code {}", (Object)publisherId, (Object)Utils.formatConstant(errorCode));
                } else {
                    producerTracker.producer.error(publishingId, errorCode);
                }
            };
            Client.ShutdownListener shutdownListener = shutdownContext -> {
                ProducersCoordinator.this.managers.remove(this);
                if (shutdownContext.isShutdownUnexpected()) {
                    LOGGER.debug("Recovering {} producer(s) after unexpected connection termination", (Object)this.producers.size());
                    this.producers.forEach((publishingId, tracker) -> tracker.unavailable());
                    this.trackingConsumerTrackers.forEach(AgentTracker::unavailable);
                    ProducersCoordinator.this.environment.scheduledExecutorService().execute(Utils.namedRunnable(() -> {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        this.streamToTrackers.forEach((stream, trackers) -> {
                            if (!Thread.currentThread().isInterrupted()) {
                                this.assignProducersToNewManagers((Collection<AgentTracker>)trackers, (String)stream, ProducersCoordinator.this.environment.recoveryBackOffDelayPolicy());
                            }
                        });
                    }, "Producer recovery after disconnection from %s", this.name));
                }
            };
            Client.MetadataListener metadataListener = (stream, code) -> {
                Set<AgentTracker> affectedTrackers;
                LOGGER.debug("Received metadata notification for '{}', stream is likely to have become unavailable", (Object)stream);
                ClientProducersManager clientProducersManager = this;
                synchronized (clientProducersManager) {
                    affectedTrackers = this.streamToTrackers.remove(stream);
                    LOGGER.debug("Affected publishers and consumer trackers after metadata update: {}", (Object)(affectedTrackers == null ? 0 : affectedTrackers.size()));
                    if (affectedTrackers != null && !affectedTrackers.isEmpty()) {
                        affectedTrackers.forEach(tracker -> {
                            tracker.unavailable();
                            if (tracker.identifiable()) {
                                this.producers.remove(tracker.id());
                            } else {
                                this.trackingConsumerTrackers.remove(tracker);
                            }
                        });
                    }
                }
                if (affectedTrackers != null && !affectedTrackers.isEmpty()) {
                    ProducersCoordinator.this.environment.scheduledExecutorService().execute(Utils.namedRunnable(() -> {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        this.closeIfEmpty();
                        this.assignProducersToNewManagers(affectedTrackers, stream, ProducersCoordinator.this.environment.topologyUpdateBackOffDelayPolicy());
                    }, "Producer re-assignment after metadata update on stream '%s'", stream));
                }
            };
            String connectionName = (String)ProducersCoordinator.this.connectionNamingStrategy.apply(Utils.ClientConnectionType.PRODUCER);
            Utils.ClientFactoryContext connectionFactoryContext = Utils.ClientFactoryContext.fromParameters(clientParameters.publishConfirmListener(publishConfirmListener).publishErrorListener(publishErrorListener).shutdownListener(shutdownListener).metadataListener(metadataListener).clientProperty("connection_name", connectionName)).key(this.name);
            this.client = cf.client(connectionFactoryContext);
            LOGGER.debug("Created producer connection '{}'", (Object)connectionName);
            clientInitializedInManager.set(true);
            ref.set(this.client);
        }

        private void assignProducersToNewManagers(Collection<AgentTracker> trackers, String stream, BackOffDelayPolicy delayPolicy) {
            ((CompletableFuture)AsyncRetry.asyncRetry(() -> ProducersCoordinator.this.getBrokerForProducer(stream)).description("Candidate lookup to publish to " + stream, new Object[0]).scheduler(ProducersCoordinator.this.environment.scheduledExecutorService()).retry(ex -> !(ex instanceof StreamDoesNotExistException)).delayPolicy(delayPolicy).build().thenAccept(broker -> {
                String key = ProducersCoordinator.keyForNode(broker);
                LOGGER.debug("Assigning {} producer(s) to {}", (Object)trackers.size(), (Object)key);
                trackers.forEach(tracker -> this.maybeRecoverAgent((Client.Broker)broker, (AgentTracker)tracker));
            })).exceptionally(ex -> {
                LOGGER.info("Error while re-assigning producers and consumer trackers, closing them: {}", (Object)ex.getMessage());
                for (AgentTracker tracker : trackers) {
                    try {
                        short code = ex instanceof StreamDoesNotExistException || ex.getCause() instanceof StreamDoesNotExistException ? (short)2 : (short)6;
                        tracker.closeAfterStreamDeletion(code);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error while closing producer: {}", (Object)e.getMessage());
                    }
                }
                return null;
            });
        }

        private void maybeRecoverAgent(Client.Broker broker, AgentTracker tracker) {
            if (tracker.markRecoveryInProgress()) {
                try {
                    this.recoverAgent(broker, tracker);
                }
                catch (Exception e) {
                    LOGGER.warn("Error while recovering {} tracker {} (stream '{}'). Reason: {}", new Object[]{tracker.type(), tracker.uniqueId(), tracker.stream(), Utils.exceptionMessage(e)});
                }
            } else {
                LOGGER.debug("Not recovering {} (stream '{}'), recovery is already is progress", (Object)tracker.type(), (Object)tracker.stream());
            }
        }

        private void recoverAgent(Client.Broker node, AgentTracker tracker) {
            boolean reassignmentCompleted = false;
            while (!reassignmentCompleted) {
                try {
                    if (tracker.isOpen()) {
                        LOGGER.debug("Using {} to resume {} to {}", new Object[]{node.label(), tracker.type(), tracker.stream()});
                        ProducersCoordinator.this.addToManager(node, tracker);
                        tracker.running();
                    } else {
                        LOGGER.debug("Not recovering {} (stream '{}') because it has been closed", (Object)tracker.type(), (Object)tracker.stream());
                    }
                    reassignmentCompleted = true;
                }
                catch (StreamNotAvailableException | ConnectionStreamException | ClientClosedException e) {
                    LOGGER.debug("{} re-assignment on stream {} timed out or connection closed or stream not available, refreshing candidate leader and retrying", new Object[]{tracker.type(), tracker.id(), tracker.stream()});
                    node = Utils.callAndMaybeRetry(() -> ProducersCoordinator.this.getBrokerForProducer(tracker.stream()), ex -> !(ex instanceof StreamDoesNotExistException), ProducersCoordinator.this.environment.recoveryBackOffDelayPolicy(), "Candidate lookup for %s on stream '%s'", tracker.type(), tracker.stream());
                }
                catch (Exception e) {
                    LOGGER.warn("Error while re-assigning {} (stream '{}')", new Object[]{tracker.type(), tracker.stream(), e});
                    reassignmentCompleted = true;
                }
            }
        }

        private synchronized void register(AgentTracker tracker) {
            if (this.isFullFor(tracker)) {
                throw new IllegalStateException("Cannot add subscription tracker, the manager is full");
            }
            if (this.isClosed()) {
                throw new IllegalStateException("Cannot add subscription tracker, the manager is closed");
            }
            this.checkNotClosed();
            if (tracker.identifiable()) {
                ProducerTracker producerTracker = (ProducerTracker)tracker;
                for (int i = 0; i < ProducersCoordinator.this.maxProducersByClient; ++i) {
                    ProducerTracker previousValue = this.producers.putIfAbsent((byte)i, producerTracker);
                    if (previousValue != null) continue;
                    this.checkNotClosed();
                    int index = i;
                    Client.Response response = Utils.callAndMaybeRetry(() -> this.client.declarePublisher((byte)index, tracker.reference(), tracker.stream()), (Predicate<Exception>)RETRY_ON_TIMEOUT, "Declare publisher request for publisher %d on stream '%s'", producerTracker.uniqueId(), producerTracker.stream());
                    if (response.isOk()) {
                        tracker.assign((byte)i, this.client, this);
                        break;
                    }
                    String message = "Error while declaring publisher: " + Utils.formatConstant(response.getResponseCode()) + ". Could not assign producer to client.";
                    LOGGER.info(message);
                    throw new StreamException(message, response.getResponseCode());
                }
                this.producers.put(tracker.id(), producerTracker);
            } else {
                tracker.assign((byte)0, this.client, this);
                this.trackingConsumerTrackers.add(tracker);
            }
            this.streamToTrackers.computeIfAbsent(tracker.stream(), s -> ConcurrentHashMap.newKeySet()).add(tracker);
        }

        private synchronized void unregister(AgentTracker tracker) {
            LOGGER.debug("Unregistering {} {} from manager on {}", new Object[]{tracker.type(), tracker.uniqueId(), this.name});
            if (tracker.identifiable()) {
                this.producers.remove(tracker.id());
            } else {
                this.trackingConsumerTrackers.remove(tracker);
            }
            this.streamToTrackers.compute(tracker.stream(), (s, trackersForThisStream) -> {
                if (s == null || trackersForThisStream == null) {
                    return null;
                }
                trackersForThisStream.remove(tracker);
                return trackersForThisStream.isEmpty() ? null : trackersForThisStream;
            });
            this.closeIfEmpty();
        }

        synchronized boolean isFullFor(AgentTracker tracker) {
            if (tracker.identifiable()) {
                return this.producers.size() == ProducersCoordinator.this.maxProducersByClient;
            }
            return this.trackingConsumerTrackers.size() == ProducersCoordinator.this.maxTrackingConsumersByClient;
        }

        synchronized boolean isEmpty() {
            return this.producers.isEmpty() && this.trackingConsumerTrackers.isEmpty();
        }

        private void checkNotClosed() {
            if (!this.client.isOpen()) {
                throw new ClientClosedException();
            }
        }

        boolean isClosed() {
            if (!this.client.isOpen()) {
                this.close();
            }
            return this.closed.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeIfEmpty() {
            if (!this.closed.get()) {
                ClientProducersManager clientProducersManager = this;
                synchronized (clientProducersManager) {
                    if (this.isEmpty()) {
                        this.close();
                    } else {
                        LOGGER.debug("Not closing producer manager {} because it is not empty", (Object)this.id);
                    }
                }
            }
        }

        private void close() {
            if (this.closed.compareAndSet(false, true)) {
                ProducersCoordinator.this.managers.remove(this);
                try {
                    if (this.client.isOpen()) {
                        this.client.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Error while closing client producer connection: ", (Object)e.getMessage());
                }
            }
        }

        @Override
        public int compareTo(ClientProducersManager o) {
            return Long.compare(this.id, o.id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientProducersManager that = (ClientProducersManager)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class TrackingConsumerTracker
    implements AgentTracker {
        private final long uniqueId;
        private final String stream;
        private final StreamConsumer consumer;
        private volatile ClientProducersManager clientProducersManager;
        private final AtomicBoolean recovering = new AtomicBoolean(false);

        private TrackingConsumerTracker(long uniqueId, String stream, StreamConsumer consumer) {
            this.uniqueId = uniqueId;
            this.stream = stream;
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void assign(byte producerId, Client client, ClientProducersManager manager) {
            TrackingConsumerTracker trackingConsumerTracker = this;
            synchronized (trackingConsumerTracker) {
                this.clientProducersManager = manager;
            }
            this.consumer.setTrackingClient(client);
        }

        @Override
        public boolean identifiable() {
            return false;
        }

        @Override
        public byte id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String reference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String stream() {
            return this.stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unavailable() {
            TrackingConsumerTracker trackingConsumerTracker = this;
            synchronized (trackingConsumerTracker) {
                this.clientProducersManager = null;
            }
            this.consumer.unavailable();
        }

        @Override
        public void running() {
            this.consumer.running();
            this.recovering.set(false);
        }

        @Override
        public synchronized void cancel() {
            if (this.clientProducersManager != null) {
                this.clientProducersManager.unregister(this);
            }
        }

        @Override
        public void closeAfterStreamDeletion(short code) {
        }

        @Override
        public boolean isOpen() {
            return this.consumer.isOpen();
        }

        @Override
        public long uniqueId() {
            return this.uniqueId;
        }

        @Override
        public String type() {
            return "tracking consumer";
        }

        @Override
        public boolean markRecoveryInProgress() {
            return this.recovering.compareAndSet(false, true);
        }
    }

    private static class ProducerTracker
    implements AgentTracker {
        private final long uniqueId;
        private final String reference;
        private final String stream;
        private final StreamProducer producer;
        private volatile byte publisherId;
        private volatile ClientProducersManager clientProducersManager;
        private final AtomicBoolean recovering = new AtomicBoolean(false);

        private ProducerTracker(long uniqueId, String reference, String stream, StreamProducer producer) {
            this.uniqueId = uniqueId;
            this.reference = reference;
            this.stream = stream;
            this.producer = producer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void assign(byte producerId, Client client, ClientProducersManager manager) {
            ProducerTracker producerTracker = this;
            synchronized (producerTracker) {
                this.publisherId = producerId;
                this.clientProducersManager = manager;
            }
            this.producer.setPublisherId(producerId);
            this.producer.setClient(client);
        }

        @Override
        public boolean identifiable() {
            return true;
        }

        @Override
        public byte id() {
            return this.publisherId;
        }

        @Override
        public String reference() {
            return this.reference;
        }

        @Override
        public String stream() {
            return this.stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unavailable() {
            ProducerTracker producerTracker = this;
            synchronized (producerTracker) {
                this.clientProducersManager = null;
            }
            this.producer.unavailable();
        }

        @Override
        public void running() {
            this.producer.running();
            this.recovering.set(false);
        }

        @Override
        public synchronized void cancel() {
            if (this.clientProducersManager != null) {
                this.clientProducersManager.unregister(this);
            }
        }

        @Override
        public void closeAfterStreamDeletion(short code) {
            this.producer.closeAfterStreamDeletion(code);
        }

        @Override
        public boolean isOpen() {
            return this.producer.isOpen();
        }

        @Override
        public long uniqueId() {
            return this.uniqueId;
        }

        @Override
        public String type() {
            return "producer";
        }

        @Override
        public boolean markRecoveryInProgress() {
            return this.recovering.compareAndSet(false, true);
        }
    }

    private static interface AgentTracker {
        public void assign(byte var1, Client var2, ClientProducersManager var3);

        public boolean identifiable();

        public byte id();

        public void unavailable();

        public void running();

        public void cancel();

        public void closeAfterStreamDeletion(short var1);

        public String stream();

        public String reference();

        public boolean isOpen();

        public long uniqueId();

        public String type();

        public boolean markRecoveryInProgress();
    }
}

