/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.compression.Compression;
import com.rabbitmq.stream.compression.CompressionCodec;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.Clock;
import com.rabbitmq.stream.impl.MessageAccumulator;
import com.rabbitmq.stream.impl.SimpleMessageAccumulator;
import com.rabbitmq.stream.impl.StreamProducer;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToLongFunction;

class SubEntryMessageAccumulator
extends SimpleMessageAccumulator {
    private final int subEntrySize;
    private final CompressionCodec compressionCodec;
    private final ByteBufAllocator byteBufAllocator;
    private final byte compression;

    public SubEntryMessageAccumulator(int subEntrySize, int batchSize, CompressionCodec compressionCodec, Codec codec, ByteBufAllocator byteBufAllocator, int maxFrameSize, ToLongFunction<Message> publishSequenceFunction, Clock clock) {
        super(subEntrySize * batchSize, codec, maxFrameSize, publishSequenceFunction, null, clock);
        this.subEntrySize = subEntrySize;
        this.compressionCodec = compressionCodec;
        this.compression = compressionCodec == null ? Compression.NONE.code() : compressionCodec.code();
        this.byteBufAllocator = byteBufAllocator;
    }

    private Batch createBatch() {
        return new Batch(Client.EncodedMessageBatch.create(this.byteBufAllocator, this.compression, this.compressionCodec, this.subEntrySize), new CompositeConfirmationCallback(new ArrayList(this.subEntrySize)));
    }

    @Override
    public MessageAccumulator.AccumulatedEntity get() {
        MessageAccumulator.AccumulatedEntity message;
        if (this.messages.isEmpty()) {
            return null;
        }
        Batch batch = this.createBatch();
        MessageAccumulator.AccumulatedEntity lastMessageInBatch = null;
        for (int count = 0; count != this.subEntrySize && (message = (MessageAccumulator.AccumulatedEntity)this.messages.poll()) != null; ++count) {
            lastMessageInBatch = message;
            batch.add((Codec.EncodedMessage)message.encodedEntity(), message.confirmationCallback());
        }
        if (batch.isEmpty()) {
            return null;
        }
        batch.time = lastMessageInBatch.time();
        batch.publishingId = lastMessageInBatch.publishindId();
        batch.encodedMessageBatch.close();
        return batch;
    }

    private static class CompositeConfirmationCallback
    implements StreamProducer.ConfirmationCallback {
        private final List<StreamProducer.ConfirmationCallback> callbacks;

        private CompositeConfirmationCallback(List<StreamProducer.ConfirmationCallback> callbacks) {
            this.callbacks = callbacks;
        }

        private void add(StreamProducer.ConfirmationCallback confirmationCallback) {
            this.callbacks.add(confirmationCallback);
        }

        @Override
        public int handle(boolean confirmed, short code) {
            for (StreamProducer.ConfirmationCallback callback : this.callbacks) {
                callback.handle(confirmed, code);
            }
            return this.callbacks.size();
        }
    }

    private static class Batch
    implements MessageAccumulator.AccumulatedEntity {
        private final Client.EncodedMessageBatch encodedMessageBatch;
        private final CompositeConfirmationCallback confirmationCallback;
        private volatile long publishingId;
        private volatile long time;

        private Batch(Client.EncodedMessageBatch encodedMessageBatch, CompositeConfirmationCallback confirmationCallback) {
            this.encodedMessageBatch = encodedMessageBatch;
            this.confirmationCallback = confirmationCallback;
        }

        void add(Codec.EncodedMessage encodedMessage, StreamProducer.ConfirmationCallback confirmationCallback) {
            this.encodedMessageBatch.add(encodedMessage);
            this.confirmationCallback.add(confirmationCallback);
        }

        boolean isEmpty() {
            return this.confirmationCallback.callbacks.isEmpty();
        }

        @Override
        public long publishindId() {
            return this.publishingId;
        }

        @Override
        public String filterValue() {
            return null;
        }

        @Override
        public Object encodedEntity() {
            return this.encodedMessageBatch;
        }

        @Override
        public long time() {
            return this.time;
        }

        @Override
        public StreamProducer.ConfirmationCallback confirmationCallback() {
            return this.confirmationCallback;
        }
    }
}

