/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.perf;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import com.rabbitmq.stream.perf.StreamPerfTest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

class LogUtils {
    LogUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void configureLog() throws IOException {
        String loggers = System.getProperty("rabbitmq.streamperftest.loggers") == null ? System.getenv("RABBITMQ_STREAM_PERF_TEST_LOGGERS") : System.getProperty("rabbitmq.streamperftest.loggers");
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try (InputStream configurationFile = StreamPerfTest.class.getResourceAsStream("/logback.xml");){
            String configuration = LogUtils.processConfigurationFile(configurationFile, LogUtils.convertKeyValuePairs(loggers));
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure((InputStream)new ByteArrayInputStream(configuration.getBytes(StandardCharsets.UTF_8)));
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    private static Map<String, Object> convertKeyValuePairs(String arg) {
        if (arg == null || arg.trim().isEmpty()) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String entry : arg.split(",")) {
            String[] keyValue = entry.split("=");
            try {
                properties.put(keyValue[0], Long.parseLong(keyValue[1]));
            }
            catch (NumberFormatException e) {
                properties.put(keyValue[0], keyValue[1]);
            }
        }
        return properties;
    }

    static String processConfigurationFile(InputStream configurationFile, Map<String, Object> loggers) throws IOException {
        int charsRead;
        StringBuilder loggersConfiguration = new StringBuilder();
        if (loggers != null) {
            for (Map.Entry<String, Object> logger : loggers.entrySet()) {
                loggersConfiguration.append(String.format("\t<logger name=\"%s\" level=\"%s\" />%s", logger.getKey(), logger.getValue().toString(), System.getProperty("line.separator")));
            }
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(configurationFile));
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        StringBuilder builder = new StringBuilder();
        while ((charsRead = in.read(buffer, 0, buffer.length)) > 0) {
            builder.append(buffer, 0, charsRead);
        }
        return builder.toString().replace("${loggers}", loggersConfiguration);
    }
}

