/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.impl.RoutingStrategy;
import com.rabbitmq.stream.impl.StreamEnvironment;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class RoutingKeyRoutingStrategy
implements RoutingStrategy {
    private final Function<Message, String> routingKeyExtractor;
    private final Map<String, String> routingKeysToStreams = new ConcurrentHashMap<String, String>();
    private final StreamEnvironment env;
    private final String superStream;

    RoutingKeyRoutingStrategy(String superStream, Function<Message, String> routingKeyExtractor, StreamEnvironment env) {
        this.routingKeyExtractor = routingKeyExtractor;
        this.env = env;
        this.superStream = superStream;
    }

    @Override
    public String route(Message message) {
        String routingKey = this.routingKeyExtractor.apply(message);
        String stream = this.routingKeysToStreams.computeIfAbsent(routingKey, routingKey1 -> this.env.locator().route((String)routingKey1, this.superStream));
        return stream;
    }
}

