/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Consumer;
import com.rabbitmq.stream.ConsumerBuilder;
import com.rabbitmq.stream.MessageHandler;
import com.rabbitmq.stream.OffsetSpecification;
import com.rabbitmq.stream.impl.StreamConsumer;
import com.rabbitmq.stream.impl.StreamEnvironment;
import java.time.Duration;

class StreamConsumerBuilder
implements ConsumerBuilder {
    private static final int NAME_MAX_SIZE = 256;
    private final StreamEnvironment environment;
    private String stream;
    private OffsetSpecification offsetSpecification = null;
    private MessageHandler messageHandler;
    private String name;
    private DefaultAutoTrackingStrategy autoTrackingStrategy;
    private DefaultManualTrackingStrategy manualTrackingStrategy;

    public StreamConsumerBuilder(StreamEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public ConsumerBuilder stream(String stream) {
        this.stream = stream;
        return this;
    }

    @Override
    public ConsumerBuilder offset(OffsetSpecification offsetSpecification) {
        this.offsetSpecification = offsetSpecification;
        return this;
    }

    @Override
    public ConsumerBuilder messageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    @Override
    public ConsumerBuilder name(String name) {
        if (name == null || name.length() > 256) {
            throw new IllegalArgumentException("The consumer name must be non-null and under 256 characters");
        }
        this.name = name;
        return this;
    }

    @Override
    public ConsumerBuilder.ManualTrackingStrategy manualTrackingStrategy() {
        this.manualTrackingStrategy = new DefaultManualTrackingStrategy(this);
        this.autoTrackingStrategy = null;
        return this.manualTrackingStrategy;
    }

    @Override
    public ConsumerBuilder.AutoTrackingStrategy autoTrackingStrategy() {
        this.autoTrackingStrategy = new DefaultAutoTrackingStrategy(this);
        this.manualTrackingStrategy = null;
        return this.autoTrackingStrategy;
    }

    @Override
    public Consumer build() {
        if (this.stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        if (this.name == null && (this.autoTrackingStrategy != null || this.manualTrackingStrategy != null)) {
            throw new IllegalArgumentException("A name must be set if a tracking strategy is specified");
        }
        this.environment.maybeInitializeLocator();
        TrackingConfiguration trackingConfiguration = this.autoTrackingStrategy != null ? new TrackingConfiguration(true, true, this.autoTrackingStrategy.messageCountBeforeStorage, this.autoTrackingStrategy.flushInterval, Duration.ZERO) : (this.manualTrackingStrategy != null ? new TrackingConfiguration(true, false, -1, Duration.ZERO, this.manualTrackingStrategy.checkInterval) : (this.name != null ? new TrackingConfiguration(true, true, 10000, Duration.ofSeconds(5L), Duration.ZERO) : new TrackingConfiguration(false, false, -1, Duration.ZERO, Duration.ZERO)));
        StreamConsumer consumer = new StreamConsumer(this.stream, this.offsetSpecification, this.messageHandler, this.name, this.environment, trackingConfiguration);
        this.environment.addConsumer(consumer);
        return consumer;
    }

    private static final class DefaultManualTrackingStrategy
    implements ConsumerBuilder.ManualTrackingStrategy {
        private final StreamConsumerBuilder builder;
        private Duration checkInterval = Duration.ofSeconds(5L);

        private DefaultManualTrackingStrategy(StreamConsumerBuilder builder) {
            this.builder = builder;
        }

        @Override
        public ConsumerBuilder.ManualTrackingStrategy checkInterval(Duration checkInterval) {
            if (checkInterval.toMillis() <= 1000L && !checkInterval.isZero()) {
                throw new IllegalArgumentException("the check interval cannot be shorter than 1 second");
            }
            this.checkInterval = checkInterval;
            return this;
        }

        @Override
        public ConsumerBuilder builder() {
            return this.builder;
        }
    }

    private static final class DefaultAutoTrackingStrategy
    implements ConsumerBuilder.AutoTrackingStrategy {
        private final StreamConsumerBuilder builder;
        private int messageCountBeforeStorage = 10000;
        private Duration flushInterval = Duration.ofSeconds(5L);

        private DefaultAutoTrackingStrategy(StreamConsumerBuilder builder) {
            this.builder = builder;
        }

        @Override
        public ConsumerBuilder.AutoTrackingStrategy messageCountBeforeStorage(int messageCountBeforeStorage) {
            if (messageCountBeforeStorage <= 0) {
                throw new IllegalArgumentException("the number of messages before storing must be positive");
            }
            this.messageCountBeforeStorage = messageCountBeforeStorage;
            return this;
        }

        @Override
        public ConsumerBuilder.AutoTrackingStrategy flushInterval(Duration flushInterval) {
            if (flushInterval.toMillis() <= 1000L) {
                throw new IllegalArgumentException("the flush interval cannot be shorter than 1 second");
            }
            this.flushInterval = flushInterval;
            return this;
        }

        @Override
        public ConsumerBuilder builder() {
            return this.builder;
        }
    }

    static class TrackingConfiguration {
        private final boolean enabled;
        private final boolean auto;
        private final int autoMessageCountBeforeStorage;
        private final Duration autoFlushInterval;
        private final Duration manualCheckInterval;

        TrackingConfiguration(boolean enabled, boolean auto, int autoMessageCountBeforeStorage, Duration autoFlushInterval, Duration manualCheckInterval) {
            this.enabled = enabled;
            this.auto = auto;
            this.autoMessageCountBeforeStorage = autoMessageCountBeforeStorage;
            this.autoFlushInterval = autoFlushInterval;
            this.manualCheckInterval = manualCheckInterval;
        }

        boolean auto() {
            return this.auto;
        }

        boolean manual() {
            return !this.auto();
        }

        boolean enabled() {
            return this.enabled;
        }

        public int autoMessageCountBeforeStorage() {
            return this.autoMessageCountBeforeStorage;
        }

        public Duration autoFlushInterval() {
            return this.autoFlushInterval;
        }

        public Duration manualCheckInterval() {
            return this.manualCheckInterval;
        }
    }
}

