/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.Producer;
import com.rabbitmq.stream.ProducerBuilder;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.compression.Compression;
import com.rabbitmq.stream.impl.HashRoutingStrategy;
import com.rabbitmq.stream.impl.HashUtils;
import com.rabbitmq.stream.impl.RoutingKeyRoutingStrategy;
import com.rabbitmq.stream.impl.RoutingStrategy;
import com.rabbitmq.stream.impl.StreamEnvironment;
import com.rabbitmq.stream.impl.StreamProducer;
import com.rabbitmq.stream.impl.SuperStreamProducer;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.ToIntFunction;

class StreamProducerBuilder
implements ProducerBuilder {
    private final StreamEnvironment environment;
    private String name;
    private String stream;
    private int subEntrySize = 1;
    private Compression compression;
    private int batchSize = 100;
    private Duration batchPublishingDelay = Duration.ofMillis(100L);
    private int maxUnconfirmedMessages = 10000;
    private Duration confirmTimeout = Duration.ofSeconds(30L);
    private Duration enqueueTimeout = Duration.ofSeconds(10L);
    private Function<Message, String> routingKeyExtractor;
    private ProducerBuilder.RoutingType routingType;
    private ToIntFunction<String> hash = HashUtils.MURMUR3;

    StreamProducerBuilder(StreamEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public StreamProducerBuilder stream(String stream) {
        this.stream = stream;
        return this;
    }

    @Override
    public ProducerBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public StreamProducerBuilder batchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("the batch size must be greater than 0");
        }
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public ProducerBuilder subEntrySize(int subEntrySize) {
        if (subEntrySize < 0) {
            throw new IllegalArgumentException("the sub-entry size must be greater than 0");
        }
        this.subEntrySize = subEntrySize;
        return this;
    }

    @Override
    public ProducerBuilder compression(Compression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public StreamProducerBuilder batchPublishingDelay(Duration batchPublishingDelay) {
        this.batchPublishingDelay = batchPublishingDelay;
        return this;
    }

    @Override
    public ProducerBuilder maxUnconfirmedMessages(int maxUnconfirmedMessages) {
        if (maxUnconfirmedMessages <= 0) {
            throw new IllegalArgumentException("the maximum number of unconfirmed messages must be greater than 0");
        }
        this.maxUnconfirmedMessages = maxUnconfirmedMessages;
        return this;
    }

    @Override
    public ProducerBuilder confirmTimeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("the confirm timeout cannot be negative");
        }
        if (timeout.compareTo(Duration.ofSeconds(1L)) < 0) {
            throw new IllegalArgumentException("the confirm timeout cannot be less than 1 second");
        }
        this.confirmTimeout = timeout;
        return this;
    }

    @Override
    public ProducerBuilder enqueueTimeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("the enqueue timeout cannot be negative");
        }
        this.enqueueTimeout = timeout;
        return this;
    }

    @Override
    public ProducerBuilder routing(Function<Message, String> routingKeyExtractor, ProducerBuilder.RoutingType routingType) {
        return this.routing(routingKeyExtractor, routingType, HashUtils.MURMUR3);
    }

    @Override
    public ProducerBuilder routing(Function<Message, String> routingKeyExtractor, ProducerBuilder.RoutingType routingType, ToIntFunction<String> hash) {
        if (!(routingKeyExtractor == null && routingType == null || routingKeyExtractor != null && routingType != null)) {
            throw new IllegalArgumentException("both routing key extractor and routing type must be non-null");
        }
        this.routingKeyExtractor = routingKeyExtractor;
        this.routingType = routingType;
        return this;
    }

    @Override
    public Producer build() {
        Producer producer;
        if (this.subEntrySize == 1 && this.compression != null) {
            throw new IllegalArgumentException("Sub-entry batching must be enabled to enable compression");
        }
        if (this.subEntrySize > 1 && this.compression == null) {
            this.compression = Compression.NONE;
        }
        this.environment.maybeInitializeLocator();
        if (this.routingKeyExtractor == null) {
            producer = new StreamProducer(this.name, this.stream, this.subEntrySize, this.batchSize, this.compression, this.batchPublishingDelay, this.maxUnconfirmedMessages, this.confirmTimeout, this.enqueueTimeout, this.environment);
            this.environment.addProducer((StreamProducer)producer);
        } else {
            ToIntFunction<String> hashFunction = this.hash == null ? HashUtils.MURMUR3 : this.hash;
            RoutingStrategy routingStrategy = this.routingType == ProducerBuilder.RoutingType.HASH ? new HashRoutingStrategy(this.stream, this.routingKeyExtractor, this.environment, hashFunction) : new RoutingKeyRoutingStrategy(this.stream, this.routingKeyExtractor, this.environment);
            producer = new SuperStreamProducer(this, this.stream, routingStrategy, this.environment);
        }
        return producer;
    }

    StreamProducerBuilder duplicate() {
        StreamProducerBuilder duplicate = new StreamProducerBuilder(this.environment);
        for (Field field : StreamProducerBuilder.class.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                field.set(duplicate, field.get(this));
            }
            catch (IllegalAccessException e) {
                throw new StreamException("Error while duplicating stream producer builder", e);
            }
        }
        return duplicate;
    }
}

