/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.perf;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.rabbitmq.stream.perf.PerformanceMetrics;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultPerformanceMetrics
implements PerformanceMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPerformanceMetrics.class);
    private final MetricRegistry metricRegistry;
    private final Timer latency;
    private final boolean summaryFile;
    private final PrintWriter out;
    private final boolean includeByteRates;
    private final Supplier<String> memoryReportSupplier;
    private volatile Closeable closingSequence = () -> {};
    private volatile long lastPublishedCount = 0L;
    private volatile long lastConsumedCount = 0L;

    DefaultPerformanceMetrics(CompositeMeterRegistry meterRegistry, String metricsPrefix, boolean summaryFile, boolean includeByteRates, Supplier<String> memoryReportSupplier, PrintWriter out) {
        this.summaryFile = summaryFile;
        this.includeByteRates = includeByteRates;
        this.memoryReportSupplier = memoryReportSupplier;
        this.out = out;
        DropwizardConfig dropwizardConfig = new DropwizardConfig(){

            public String prefix() {
                return "";
            }

            public String get(String key) {
                return null;
            }
        };
        this.metricRegistry = new MetricRegistry();
        DropwizardMeterRegistry dropwizardMeterRegistry = new DropwizardMeterRegistry(dropwizardConfig, this.metricRegistry, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return null;
            }
        };
        meterRegistry.add((MeterRegistry)dropwizardMeterRegistry);
        this.latency = Timer.builder((String)(metricsPrefix + ".latency")).description("message latency").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).distributionStatisticExpiry(Duration.ofSeconds(1L)).serviceLevelObjectives(new Duration[0]).register((MeterRegistry)meterRegistry);
    }

    private long getPublishedCount() {
        return ((Meter)this.metricRegistry.getMeters().get("rabbitmqStreamPublished")).getCount();
    }

    private long getConsumedCount() {
        return ((Meter)this.metricRegistry.getMeters().get("rabbitmqStreamConsumed")).getCount();
    }

    @Override
    public void start(String description) throws Exception {
        String metricPublished = "rabbitmqStreamPublished";
        String metricProducerConfirmed = "rabbitmqStreamProducer_confirmed";
        String metricConsumed = "rabbitmqStreamConsumed";
        String metricChunkSize = "rabbitmqStreamChunk_size";
        String metricLatency = "rabbitmqStreamLatency";
        String metricWrittenBytes = "rabbitmqStreamWritten_bytes";
        String metricReadBytes = "rabbitmqStreamRead_bytes";
        HashSet<String> allMetrics = new HashSet<String>(Arrays.asList(metricPublished, metricProducerConfirmed, metricConsumed, metricChunkSize, metricLatency));
        LinkedHashMap<String, String> metersNamesAndLabels = new LinkedHashMap<String, String>();
        metersNamesAndLabels.put(metricPublished, "published");
        metersNamesAndLabels.put(metricProducerConfirmed, "confirmed");
        metersNamesAndLabels.put(metricConsumed, "consumed");
        if (this.includeByteRates) {
            allMetrics.add(metricWrittenBytes);
            allMetrics.add(metricReadBytes);
            metersNamesAndLabels.put(metricWrittenBytes, "written bytes");
            metersNamesAndLabels.put(metricReadBytes, "read bytes");
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Closeable summaryFileClosingSequence = this.maybeSetSummaryFile(description, allMetrics, scheduledExecutorService);
        SortedMap registryMeters = this.metricRegistry.getMeters();
        LinkedHashMap meters = new LinkedHashMap(metersNamesAndLabels.size());
        metersNamesAndLabels.entrySet().forEach(entry -> {
            Meter cfr_ignored_0 = (Meter)meters.put(entry.getValue(), registryMeters.get(entry.getKey()));
        });
        HashMap formatMeter = new HashMap();
        metersNamesAndLabels.entrySet().stream().filter(entry -> !((String)entry.getKey()).contains("bytes")).forEach(entry -> formatMeter.put(entry.getValue(), meter -> String.format("%s %.0f msg/s, ", entry.getValue(), meter.getMeanRate())));
        metersNamesAndLabels.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains("bytes")).forEach(entry -> formatMeter.put(entry.getValue(), meter -> DefaultPerformanceMetrics.formatByteRate((String)entry.getValue(), meter.getMeanRate()) + ", "));
        Histogram chunkSize = (Histogram)this.metricRegistry.getHistograms().get(metricChunkSize);
        Function<Histogram, String> formatChunkSize = histogram -> String.format("chunk size %.0f", histogram.getSnapshot().getMean());
        com.codahale.metrics.Timer latency = (com.codahale.metrics.Timer)this.metricRegistry.getTimers().get(metricLatency);
        Function<Number, Number> convertDuration = in -> in instanceof Long ? (double)(in.longValue() / 1000L) : in.doubleValue() / 1000.0;
        Function<com.codahale.metrics.Timer, String> formatLatency = timer -> {
            Snapshot snapshot = timer.getSnapshot();
            return String.format("latency min/median/75th/95th/99th %.0f/%.0f/%.0f/%.0f/%.0f \u00b5s", convertDuration.apply(snapshot.getMin()), convertDuration.apply(snapshot.getMedian()), convertDuration.apply(snapshot.get75thPercentile()), convertDuration.apply(snapshot.get95thPercentile()), convertDuration.apply(snapshot.get99thPercentile()));
        };
        AtomicInteger reportCount = new AtomicInteger(1);
        ScheduledFuture<?> consoleReportingTask = scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                if (this.checkActivity()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(reportCount.get()).append(", ");
                    meters.entrySet().forEach(entry -> {
                        String meterName = (String)entry.getKey();
                        Meter meter = (Meter)entry.getValue();
                        builder.append((String)((Function)formatMeter.get(meterName)).apply(meter));
                    });
                    builder.append((String)formatLatency.apply(latency)).append(", ");
                    builder.append((String)formatChunkSize.apply(chunkSize));
                    this.out.println(builder);
                    String memoryReport = this.memoryReportSupplier.get();
                    if (!memoryReport.isEmpty()) {
                        this.out.println(memoryReport);
                    }
                }
                reportCount.incrementAndGet();
            }
            catch (Exception e) {
                LOGGER.warn("Error while metrics report: {}", (Object)e.getMessage());
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        long start = System.currentTimeMillis();
        this.closingSequence = () -> {
            consoleReportingTask.cancel(true);
            summaryFileClosingSequence.close();
            scheduledExecutorService.shutdownNow();
            long duration = System.currentTimeMillis() - start;
            Function<Map.Entry, String> formatMeterSummary = entry -> {
                if (((String)entry.getKey()).contains("bytes")) {
                    return DefaultPerformanceMetrics.formatByteRate((String)entry.getKey(), ((Meter)entry.getValue()).getCount() * 1000L / duration) + ", ";
                }
                return String.format("%s %d msg/s, ", entry.getKey(), ((Meter)entry.getValue()).getCount() * 1000L / duration);
            };
            Function<com.codahale.metrics.Timer, String> formatLatencySummary = histogram -> String.format("latency 95th %.0f \u00b5s", convertDuration.apply(latency.getSnapshot().get95thPercentile()));
            StringBuilder builder = new StringBuilder("Summary: ");
            meters.entrySet().forEach(entry -> builder.append((String)formatMeterSummary.apply((Map.Entry)entry)));
            builder.append(formatLatencySummary.apply(latency)).append(", ");
            builder.append((String)formatChunkSize.apply(chunkSize));
            this.out.println();
            this.out.println(builder);
        };
    }

    static String formatByteRate(String label, double bytes) {
        if (-1000.0 < bytes && bytes < 1000.0) {
            return bytes + " B/s";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950.0 || bytes >= 999950.0) {
            bytes /= 1000.0;
            ci.next();
        }
        return String.format("%s %.1f %cB/s", label, bytes / 1000.0, Character.valueOf(ci.current()));
    }

    private Closeable maybeSetSummaryFile(String description, Set<String> allMetrics, ScheduledExecutorService scheduledExecutorService) throws IOException {
        Closeable summaryFileClosingSequence;
        if (this.summaryFile) {
            String currentFilename = "stream-perf-test-current.txt";
            String finalFilename = "stream-perf-test-" + new SimpleDateFormat("yyyy-MM-dd-HHmmss").format(new Date()) + ".txt";
            Path currentFile = Paths.get(currentFilename, new String[0]);
            if (Files.exists(currentFile, new LinkOption[0]) && !Files.deleteIfExists(Paths.get(currentFilename, new String[0]))) {
                LOGGER.warn("Could not delete file {}", (Object)currentFilename);
            }
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(currentFilename));
            PrintStream printStream = new PrintStream(outputStream);
            if (description != null && !description.trim().isEmpty()) {
                printStream.println(description);
            }
            ConsoleReporter fileReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).filter((name, metric) -> allMetrics.contains(name)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(printStream).scheduleOn(scheduledExecutorService).shutdownExecutorOnStop(false).build();
            fileReporter.start(1L, TimeUnit.SECONDS);
            summaryFileClosingSequence = () -> {
                fileReporter.stop();
                printStream.close();
                Files.move(currentFile, currentFile.resolveSibling(finalFilename), new CopyOption[0]);
            };
        } else {
            summaryFileClosingSequence = () -> {};
        }
        return summaryFileClosingSequence;
    }

    boolean checkActivity() {
        boolean activity;
        long currentPublishedCount = this.getPublishedCount();
        long currentConsumedCount = this.getConsumedCount();
        boolean bl = activity = this.lastPublishedCount != currentPublishedCount || this.lastConsumedCount != currentConsumedCount;
        if (activity) {
            this.lastPublishedCount = currentPublishedCount;
            this.lastConsumedCount = currentConsumedCount;
        }
        return activity;
    }

    @Override
    public void latency(long latency, TimeUnit unit) {
        this.latency.record(latency, unit);
    }

    @Override
    public void close() throws Exception {
        this.closingSequence.close();
    }
}

