/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.Producer;
import com.rabbitmq.stream.ProducerBuilder;
import com.rabbitmq.stream.RoutingStrategy;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.compression.Compression;
import com.rabbitmq.stream.impl.HashRoutingStrategy;
import com.rabbitmq.stream.impl.HashUtils;
import com.rabbitmq.stream.impl.RoutingKeyRoutingStrategy;
import com.rabbitmq.stream.impl.StreamEnvironment;
import com.rabbitmq.stream.impl.StreamProducer;
import com.rabbitmq.stream.impl.SuperStreamProducer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.ToIntFunction;

class StreamProducerBuilder
implements ProducerBuilder {
    static final boolean DEFAULT_DYNAMIC_BATCH = Boolean.parseBoolean(System.getProperty("rabbitmq.stream.producer.dynamic.batch", "true"));
    private final StreamEnvironment environment;
    private String name;
    private String stream;
    private String superStream;
    private int subEntrySize = 1;
    private Compression compression;
    private int batchSize = 100;
    private Duration batchPublishingDelay = Duration.ofMillis(100L);
    private int maxUnconfirmedMessages = 10000;
    private Duration confirmTimeout = Duration.ofSeconds(30L);
    private Duration enqueueTimeout = Duration.ofSeconds(10L);
    private boolean retryOnRecovery = true;
    private DefaultRoutingConfiguration routingConfiguration;
    private Function<Message, String> filterValueExtractor;
    private boolean dynamicBatch = DEFAULT_DYNAMIC_BATCH;

    StreamProducerBuilder(StreamEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public StreamProducerBuilder stream(String stream) {
        this.stream = stream;
        return this;
    }

    @Override
    public ProducerBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public ProducerBuilder superStream(String superStream) {
        this.superStream = superStream;
        return this;
    }

    @Override
    public StreamProducerBuilder batchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("the batch size must be greater than 0");
        }
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public ProducerBuilder subEntrySize(int subEntrySize) {
        if (subEntrySize < 0) {
            throw new IllegalArgumentException("the sub-entry size must be greater than 0");
        }
        this.subEntrySize = subEntrySize;
        return this;
    }

    @Override
    public ProducerBuilder compression(Compression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public StreamProducerBuilder batchPublishingDelay(Duration batchPublishingDelay) {
        this.batchPublishingDelay = batchPublishingDelay;
        return this;
    }

    @Override
    public ProducerBuilder dynamicBatch(boolean dynamicBatch) {
        this.dynamicBatch = dynamicBatch;
        return this;
    }

    @Override
    public ProducerBuilder maxUnconfirmedMessages(int maxUnconfirmedMessages) {
        if (maxUnconfirmedMessages <= 0) {
            throw new IllegalArgumentException("the maximum number of unconfirmed messages must be greater than 0");
        }
        this.maxUnconfirmedMessages = maxUnconfirmedMessages;
        return this;
    }

    @Override
    public ProducerBuilder confirmTimeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("the confirm timeout cannot be negative");
        }
        if (timeout.compareTo(Duration.ofSeconds(1L)) < 0 && !timeout.isZero()) {
            throw new IllegalArgumentException("the confirm timeout cannot be less than 1 second");
        }
        this.confirmTimeout = timeout;
        return this;
    }

    @Override
    public ProducerBuilder enqueueTimeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("the enqueue timeout cannot be negative");
        }
        this.enqueueTimeout = timeout;
        return this;
    }

    @Override
    public ProducerBuilder retryOnRecovery(boolean retryOnRecovery) {
        this.retryOnRecovery = retryOnRecovery;
        return this;
    }

    @Override
    public ProducerBuilder filterValue(Function<Message, String> filterValueExtractor) {
        this.filterValueExtractor = filterValueExtractor;
        return this;
    }

    @Override
    public ProducerBuilder.RoutingConfiguration routing(Function<Message, String> routingKeyExtractor) {
        this.routingConfiguration = new DefaultRoutingConfiguration(this);
        this.routingConfiguration.routingKeyExtractor = routingKeyExtractor;
        return this.routingConfiguration;
    }

    void resetRouting() {
        this.routingConfiguration = null;
    }

    @Override
    public Producer build() {
        Producer producer;
        if (this.stream == null && this.superStream == null) {
            throw new IllegalArgumentException("A stream must be specified");
        }
        if (this.stream != null && this.superStream != null) {
            throw new IllegalArgumentException("Stream and superStream cannot be set at the same time");
        }
        if (this.subEntrySize == 1 && this.compression != null) {
            throw new IllegalArgumentException("Sub-entry batching must be enabled to enable compression");
        }
        if (this.subEntrySize > 1 && this.filterValueExtractor != null) {
            throw new IllegalArgumentException("Filtering is not supported with sub-entry batching");
        }
        if (this.subEntrySize > 1 && this.compression == null) {
            this.compression = Compression.NONE;
        }
        this.environment.maybeInitializeLocator();
        if (this.stream != null && this.routingConfiguration != null) {
            throw new IllegalArgumentException("A super stream must be specified when a routing configuration is set");
        }
        if (this.routingConfiguration != null && this.superStream == null) {
            throw new IllegalArgumentException("A super stream must be specified when a routing configuration is set");
        }
        if (this.routingConfiguration == null && this.superStream != null) {
            throw new IllegalArgumentException("A routing configuration must specified when a super stream is set");
        }
        if (this.stream != null) {
            producer = new StreamProducer(this.name, this.stream, this.subEntrySize, this.batchSize, this.dynamicBatch, this.compression, this.batchPublishingDelay, this.maxUnconfirmedMessages, this.confirmTimeout, this.enqueueTimeout, this.retryOnRecovery, this.filterValueExtractor, this.environment);
            this.environment.addProducer((StreamProducer)producer);
        } else {
            RoutingStrategy routingStrategy = this.routingConfiguration.routingStrategy;
            if (routingStrategy == null) {
                routingStrategy = this.routingConfiguration.hash == null ? new RoutingKeyRoutingStrategy(this.routingConfiguration.routingKeyExtractor) : new HashRoutingStrategy(this.routingConfiguration.routingKeyExtractor, this.routingConfiguration.hash);
            }
            producer = new SuperStreamProducer(this, this.name, this.superStream, routingStrategy, this.environment);
        }
        return producer;
    }

    StreamProducerBuilder duplicate() {
        StreamProducerBuilder duplicate = new StreamProducerBuilder(this.environment);
        for (Field field : StreamProducerBuilder.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(duplicate, field.get(this));
            }
            catch (IllegalAccessException e) {
                throw new StreamException("Error while duplicating stream producer builder", e);
            }
        }
        return duplicate;
    }

    static final class DefaultRoutingConfiguration
    implements ProducerBuilder.RoutingConfiguration {
        private final StreamProducerBuilder producerBuilder;
        private Function<Message, String> routingKeyExtractor;
        private RoutingStrategy routingStrategy;
        private ToIntFunction<String> hash = HashUtils.MURMUR3;

        DefaultRoutingConfiguration(StreamProducerBuilder producerBuilder) {
            this.producerBuilder = producerBuilder;
        }

        @Override
        public ProducerBuilder.RoutingConfiguration hash() {
            if (this.hash == null) {
                this.hash = HashUtils.MURMUR3;
            }
            this.routingStrategy = null;
            return this;
        }

        @Override
        public ProducerBuilder.RoutingConfiguration hash(ToIntFunction<String> hash) {
            this.hash = hash;
            this.routingStrategy = null;
            return this;
        }

        @Override
        public ProducerBuilder.RoutingConfiguration key() {
            this.hash = null;
            this.routingStrategy = null;
            return this;
        }

        @Override
        public ProducerBuilder.RoutingConfiguration strategy(RoutingStrategy routingStrategy) {
            this.routingStrategy = routingStrategy;
            return this;
        }

        @Override
        public ProducerBuilder producerBuilder() {
            return this.producerBuilder;
        }
    }
}

