/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Address;
import com.rabbitmq.stream.AddressResolver;
import com.rabbitmq.stream.BackOffDelayPolicy;
import com.rabbitmq.stream.Constants;
import com.rabbitmq.stream.ConsumerUpdateListener;
import com.rabbitmq.stream.OffsetSpecification;
import com.rabbitmq.stream.StreamDoesNotExistException;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.StreamNotAvailableException;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.ExecutorServiceFactory;
import com.rabbitmq.stream.impl.StreamEnvironment;
import com.rabbitmq.stream.impl.TimeoutStreamException;
import io.netty.channel.ConnectTimeoutException;
import java.lang.invoke.CallSite;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Utils {
    private static final Consumer NO_OP_CONSUMER = o -> {};
    static final LongConsumer NO_OP_LONG_CONSUMER = someLong -> {};
    static final LongSupplier NO_OP_LONG_SUPPLIER = () -> 0L;
    static final X509TrustManager TRUST_EVERYTHING_TRUST_MANAGER = new TrustEverythingTrustManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final Map<Short, String> CONSTANT_LABELS;
    static final String SUBSCRIPTION_PROPERTY_SAC = "single-active-consumer";
    static final String SUBSCRIPTION_PROPERTY_SUPER_STREAM = "super-stream";
    static final String SUBSCRIPTION_PROPERTY_FILTER_PREFIX = "filter.";
    static final String SUBSCRIPTION_PROPERTY_MATCH_UNFILTERED = "match-unfiltered";
    static final AddressResolver DEFAULT_ADDRESS_RESOLVER;
    static final String DEFAULT_USERNAME = "guest";
    static final ExecutorServiceFactory NO_OP_EXECUTOR_SERVICE_FACTORY;

    private Utils() {
    }

    static <T> Consumer<T> noOpConsumer() {
        return NO_OP_CONSUMER;
    }

    static Runnable makeIdempotent(Runnable action) {
        AtomicBoolean executed = new AtomicBoolean(false);
        return () -> {
            if (executed.compareAndSet(false, true)) {
                action.run();
            }
        };
    }

    static <T> Consumer<T> makeIdempotent(Consumer<T> action) {
        AtomicBoolean executed = new AtomicBoolean(false);
        return t -> {
            if (executed.compareAndSet(false, true)) {
                action.accept(t);
            }
        };
    }

    static String formatConstant(short value) {
        return value + " (" + CONSTANT_LABELS.getOrDefault(value, "UNKNOWN") + ")";
    }

    static boolean isSac(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        return "true".equals(properties.get(SUBSCRIPTION_PROPERTY_SAC));
    }

    static boolean filteringEnabled(Map<String, String> properties) {
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        return properties.keySet().stream().anyMatch(k -> k.startsWith(SUBSCRIPTION_PROPERTY_FILTER_PREFIX));
    }

    static short encodeRequestCode(Short code) {
        return code;
    }

    static short extractResponseCode(Short code) {
        return (short)(code & Short.MAX_VALUE);
    }

    static short encodeResponseCode(Short code) {
        return (short)(code | 0x8000);
    }

    static ClientFactory coordinatorClientFactory(StreamEnvironment environment, Duration retryInterval) {
        String messageFormat = "%s. %s. This may be due to the usage of a load balancer that makes topology discovery fail. Use a custom AddressResolver or the --load-balancer flag if using StreamPerfTest. See https://rabbitmq.github.io/rabbitmq-stream-java-client/stable/htmlsingle/#understanding-connection-logic and https://blog.rabbitmq.com/posts/2021/07/connecting-to-streams/#with-a-load-balancer.";
        return context -> {
            Client.ClientParameters parametersCopy = context.parameters().duplicate();
            Address address = new Address(parametersCopy.host(), parametersCopy.port());
            address = environment.addressResolver().resolve(address);
            parametersCopy.host(address.host()).port(address.port());
            if (context.targetKey() == null) {
                throw new IllegalArgumentException("A key is necessary to create the client connection");
            }
            try {
                ClientFactory delegate = context1 -> new Client(context1.parameters());
                ClientFactoryContext clientFactoryContext = new ClientFactoryContext(parametersCopy, context.targetKey(), context.candidates());
                return Utils.connectToAdvertisedNodeClientFactory(delegate, retryInterval).client(clientFactoryContext);
            }
            catch (TimeoutStreamException e) {
                if (e.getCause() == null) {
                    throw new TimeoutStreamException(String.format(messageFormat, e.getMessage(), "No root cause"));
                }
                throw new TimeoutStreamException(String.format(messageFormat, e.getMessage(), e.getCause().getMessage()), e.getCause());
            }
            catch (StreamException e) {
                if (e.getCause() != null && (e.getCause() instanceof UnknownHostException || e.getCause() instanceof ConnectTimeoutException)) {
                    throw new StreamException(String.format(messageFormat, e.getMessage(), e.getCause().getMessage()), e.getCause());
                }
                throw e;
            }
        };
    }

    static ClientFactory connectToAdvertisedNodeClientFactory(ClientFactory clientFactory, Duration retryInterval) {
        return new ConditionalClientFactory(clientFactory, (ctx, client) -> {
            String currentKey = client.serverAdvertisedHost() + ":" + client.serverAdvertisedPort();
            boolean success = ctx.targetKey().equals(currentKey);
            if (!success && !ctx.candidates().isEmpty()) {
                success = ctx.candidates().stream().anyMatch(b -> currentKey.equals(Utils.keyForNode(b)));
            }
            LOGGER.debug("Expected client {}, got {}, viable candidates {}: {}", new Object[]{ctx.targetKey(), currentKey, ctx.candidates(), success ? "success" : "failure"});
            return success;
        }, retryInterval);
    }

    static String keyForNode(Client.Broker broker) {
        return broker.getHost() + ":" + broker.getPort();
    }

    static Client.Broker brokerFromClient(Client client) {
        return new Client.Broker(client.serverAdvertisedHost(), client.serverAdvertisedPort());
    }

    static Function<List<Client.Broker>, Client.Broker> brokerPicker() {
        Random random = new Random();
        return brokers -> {
            if (brokers.isEmpty()) {
                return null;
            }
            if (brokers.size() == 1) {
                return (Client.Broker)brokers.get(0);
            }
            return (Client.Broker)brokers.get(random.nextInt(brokers.size()));
        };
    }

    static Runnable namedRunnable(Runnable task, String format, Object ... args) {
        return new NamedRunnable(String.format(format, args), task);
    }

    static <T, R> Function<T, R> namedFunction(Function<T, R> task, String format, Object ... args) {
        return new NamedFunction<T, R>(String.format(format, args), task);
    }

    static <T> T callAndMaybeRetry(Callable<T> operation, Predicate<Exception> retryCondition, String format, Object ... args) {
        return Utils.callAndMaybeRetry(operation, retryCondition, (int i) -> i >= 3 ? BackOffDelayPolicy.TIMEOUT : Duration.ZERO, format, args);
    }

    static <T> T callAndMaybeRetry(Callable<T> operation, Predicate<Exception> retryCondition, BackOffDelayPolicy delayPolicy, String format, Object ... args) {
        String description = String.format(format, args);
        int attempt = 0;
        Exception lastException = null;
        long startTime = System.nanoTime();
        boolean keepTrying = true;
        while (keepTrying) {
            try {
                LOGGER.debug("Starting attempt #{} for operation '{}'", (Object)(++attempt), (Object)description);
                T result = operation.call();
                Duration operationDuration = Duration.ofNanos(System.nanoTime() - startTime);
                LOGGER.debug("Operation '{}' completed in {} ms after {} attempt(s)", new Object[]{description, operationDuration.toMillis(), attempt});
                return result;
            }
            catch (Exception e) {
                lastException = e;
                if (retryCondition.test(e)) {
                    LOGGER.debug("Operation '{}' failed, retrying...", (Object)description);
                    Duration delay = delayPolicy.delay(attempt);
                    if (BackOffDelayPolicy.TIMEOUT.equals(delay)) {
                        keepTrying = false;
                        continue;
                    }
                    if (delay.isZero()) continue;
                    try {
                        Thread.sleep(delay.toMillis());
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        lastException = ex;
                        keepTrying = false;
                    }
                    continue;
                }
                keepTrying = false;
            }
        }
        String message = String.format("Could not complete task '%s' after %d attempt(s) (reason: %s)", description, attempt, Utils.exceptionMessage(lastException));
        LOGGER.debug(message);
        if (lastException == null) {
            throw new StreamException(message);
        }
        if (lastException instanceof RuntimeException) {
            throw (RuntimeException)lastException;
        }
        throw new StreamException(message, lastException);
    }

    static String exceptionMessage(Exception e) {
        if (e == null) {
            return "unknown";
        }
        if (e.getMessage() == null) {
            return e.getClass().getSimpleName();
        }
        return e.getMessage() + " [" + e.getClass().getSimpleName() + "]";
    }

    static Function<ClientConnectionType, String> defaultConnectionNamingStrategy(String prefix) {
        ConcurrentHashMap<ClientConnectionType, AtomicLong> sequences = new ConcurrentHashMap<ClientConnectionType, AtomicLong>(ClientConnectionType.values().length);
        ConcurrentHashMap<ClientConnectionType, CallSite> prefixes = new ConcurrentHashMap<ClientConnectionType, CallSite>(ClientConnectionType.values().length);
        for (ClientConnectionType type : ClientConnectionType.values()) {
            sequences.put(type, new AtomicLong(0L));
            prefixes.put(type, (CallSite)((Object)(prefix + type.name().toLowerCase(Locale.ENGLISH) + "-")));
        }
        return clientConnectionType -> (String)prefixes.get(clientConnectionType) + ((AtomicLong)sequences.get(clientConnectionType)).getAndIncrement();
    }

    static boolean offsetBefore(long x, long y) {
        return Long.compareUnsigned(x, y) < 0;
    }

    private static String currentVersion(String currentVersion) {
        if (currentVersion.contains("+")) {
            currentVersion = currentVersion.substring(0, currentVersion.indexOf("+"));
        }
        if (currentVersion.contains("~")) {
            currentVersion = currentVersion.substring(0, currentVersion.indexOf("~"));
        }
        if (currentVersion.contains("-")) {
            currentVersion = currentVersion.substring(0, currentVersion.indexOf("-"));
        }
        return currentVersion;
    }

    static int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    static boolean is3_11_OrMore(String brokerVersion) {
        return Utils.versionCompare(Utils.currentVersion(brokerVersion), "3.11.0") >= 0;
    }

    static StreamException convertCodeToException(short responseCode, String stream, Supplier<String> fallbackMessage) {
        if (responseCode == 2) {
            return new StreamDoesNotExistException(stream);
        }
        if (responseCode == 6) {
            return new StreamNotAvailableException(stream);
        }
        return new StreamException(fallbackMessage.get(), responseCode);
    }

    static String quote(String value) {
        if (value == null) {
            return "null";
        }
        return "\"" + value + "\"";
    }

    static String jsonField(String name, Number value) {
        return Utils.quote(name) + " : " + value.longValue();
    }

    static String jsonField(String name, String value) {
        return Utils.quote(name) + " : " + Utils.quote(value);
    }

    static void lock(Lock lock, Runnable action) {
        Utils.lock(lock, () -> {
            action.run();
            return null;
        });
    }

    static <T> T lock(Lock lock, Supplier<T> action) {
        lock.lock();
        try {
            T t = action.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    static {
        HashMap labels = new HashMap();
        Arrays.stream(Constants.class.getDeclaredFields()).filter(f -> f.getName().startsWith("RESPONSE_CODE_") || f.getName().startsWith("CODE_")).forEach(field -> {
            try {
                labels.put(field.getShort(null), field.getName().replace("RESPONSE_CODE_", "").replace("CODE_", ""));
            }
            catch (IllegalAccessException e) {
                LOGGER.info("Error while trying to access field Constants." + field.getName());
            }
        });
        CONSTANT_LABELS = Map.copyOf(labels);
        DEFAULT_ADDRESS_RESOLVER = address -> address;
        NO_OP_EXECUTOR_SERVICE_FACTORY = new NoOpExecutorServiceFactory();
    }

    static class BrokerWrapper {
        private final Client.Broker broker;
        private final boolean leader;

        BrokerWrapper(Client.Broker broker, boolean leader) {
            this.broker = broker;
            this.leader = leader;
        }

        Client.Broker broker() {
            return this.broker;
        }

        boolean isLeader() {
            return this.leader;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BrokerWrapper that = (BrokerWrapper)o;
            return this.leader == that.leader && Objects.equals(this.broker, that.broker);
        }

        public int hashCode() {
            return Objects.hash(this.broker, this.leader);
        }

        public String toString() {
            return "BrokerWrapper{broker=" + this.broker + ", leader=" + this.leader + "}";
        }
    }

    static class MutableBoolean {
        private boolean value;

        MutableBoolean(boolean initialValue) {
            this.value = initialValue;
        }

        void set(boolean value) {
            this.value = value;
        }

        boolean get() {
            return this.value;
        }
    }

    private static class NoOpExecutorService
    implements ExecutorService {
        private NoOpExecutorService() {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return null;
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return null;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return null;
        }

        @Override
        public Future<?> submit(Runnable task) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
            return null;
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
            return null;
        }

        @Override
        public void execute(Runnable command) {
        }
    }

    static class NoOpExecutorServiceFactory
    implements ExecutorServiceFactory {
        private final ExecutorService executorService = new NoOpExecutorService();

        NoOpExecutorServiceFactory() {
        }

        @Override
        public ExecutorService get() {
            return this.executorService;
        }

        @Override
        public void clientClosed(ExecutorService executorService) {
        }

        @Override
        public void close() {
        }
    }

    private static class NamedFunction<T, R>
    implements Function<T, R> {
        private final String name;
        private final Function<T, R> delegate;

        private NamedFunction(String name, Function<T, R> delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        @Override
        public R apply(T t) {
            return this.delegate.apply(t);
        }

        public String toString() {
            return this.name;
        }
    }

    private static class NamedRunnable
    implements Runnable {
        private final String name;
        private final Runnable delegate;

        private NamedRunnable(String name, Runnable delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        public String toString() {
            return this.name;
        }
    }

    static class CompositeConsumerUpdateListener
    implements ConsumerUpdateListener {
        private final List<ConsumerUpdateListener> delegates = new CopyOnWriteArrayList<ConsumerUpdateListener>();

        CompositeConsumerUpdateListener() {
        }

        @Override
        public OffsetSpecification update(ConsumerUpdateListener.Context context) {
            OffsetSpecification result = null;
            for (ConsumerUpdateListener delegate : this.delegates) {
                OffsetSpecification offsetSpecification = delegate.update(context);
                if (offsetSpecification == null) continue;
                result = offsetSpecification;
            }
            return result;
        }

        void add(ConsumerUpdateListener delegate) {
            this.delegates.add(delegate);
        }

        CompositeConsumerUpdateListener duplicate() {
            CompositeConsumerUpdateListener duplica = new CompositeConsumerUpdateListener();
            for (ConsumerUpdateListener delegate : this.delegates) {
                duplica.add(delegate);
            }
            return duplica;
        }
    }

    static enum ClientConnectionType {
        CONSUMER,
        PRODUCER,
        LOCATOR;

    }

    private static class TrustEverythingTrustManager
    implements X509TrustManager {
        private TrustEverythingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    static class ClientFactoryContext {
        private final Client.ClientParameters parameters;
        private final String targetKey;
        private final List<Client.Broker> candidates;

        ClientFactoryContext(Client.ClientParameters parameters, String targetKey, List<Client.Broker> candidates) {
            this.parameters = parameters;
            this.targetKey = targetKey;
            this.candidates = candidates == null ? Collections.emptyList() : List.copyOf(candidates);
        }

        Client.ClientParameters parameters() {
            return this.parameters;
        }

        String targetKey() {
            return this.targetKey;
        }

        List<Client.Broker> candidates() {
            return this.candidates;
        }
    }

    static class ConditionalClientFactory
    implements ClientFactory {
        private static final Duration RETRY_INTERVAL = Duration.ofSeconds(1L);
        private final ClientFactory delegate;
        private final BiPredicate<ClientFactoryContext, Client> condition;
        private final Duration retryInterval;

        ConditionalClientFactory(ClientFactory delegate, BiPredicate<ClientFactoryContext, Client> condition, Duration retryInterval) {
            this.delegate = delegate;
            this.condition = condition;
            this.retryInterval = retryInterval;
        }

        @Override
        public Client client(ClientFactoryContext context) {
            Client client;
            while (!this.condition.test(context, client = this.delegate.client(context))) {
                try {
                    client.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error while trying to close client", (Throwable)e);
                }
                try {
                    Thread.sleep(this.retryInterval.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
            return client;
        }
    }

    static interface ClientFactory {
        public Client client(ClientFactoryContext var1);
    }
}

