/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.ObservationCollector;
import com.rabbitmq.stream.compression.Compression;
import com.rabbitmq.stream.compression.CompressionCodec;
import com.rabbitmq.stream.impl.Clock;
import com.rabbitmq.stream.impl.ProducerUtils;
import com.rabbitmq.stream.impl.SimpleMessageAccumulator;
import com.rabbitmq.stream.impl.StreamProducer;
import io.netty.buffer.ByteBufAllocator;
import java.util.function.ToLongFunction;

final class SubEntryMessageAccumulator
extends SimpleMessageAccumulator {
    private final int subEntrySize;
    private final CompressionCodec compressionCodec;
    private final ByteBufAllocator byteBufAllocator;
    private final byte compressionCode;

    public SubEntryMessageAccumulator(int subEntrySize, int batchSize, CompressionCodec compressionCodec, Codec codec, ByteBufAllocator byteBufAllocator, int maxFrameSize, ToLongFunction<Message> publishSequenceFunction, Clock clock, String stream, ObservationCollector<?> observationCollector, StreamProducer producer) {
        super(subEntrySize * batchSize, codec, maxFrameSize, publishSequenceFunction, null, clock, stream, observationCollector, producer);
        this.subEntrySize = subEntrySize;
        this.compressionCodec = compressionCodec;
        this.compressionCode = compressionCodec == null ? Compression.NONE.code() : compressionCodec.code();
        this.byteBufAllocator = byteBufAllocator;
    }

    private ProducerUtils.Batch createBatch() {
        return this.helper.batch(this.byteBufAllocator, this.compressionCode, this.compressionCodec, this.subEntrySize);
    }

    @Override
    protected ProducerUtils.AccumulatedEntity get() {
        ProducerUtils.AccumulatedEntity message;
        if (this.messages.isEmpty()) {
            return null;
        }
        ProducerUtils.Batch batch = this.createBatch();
        ProducerUtils.AccumulatedEntity lastMessageInBatch = null;
        for (int count = 0; count != this.subEntrySize && (message = (ProducerUtils.AccumulatedEntity)this.messages.poll()) != null; ++count) {
            this.observationCollector.published(message.observationContext(), message.confirmationCallback().message());
            lastMessageInBatch = message;
            batch.add((Codec.EncodedMessage)message.encodedEntity(), message.confirmationCallback());
        }
        if (batch.isEmpty()) {
            return null;
        }
        batch.time = lastMessageInBatch.time();
        batch.publishingId = lastMessageInBatch.publishingId();
        batch.encodedMessageBatch.close();
        return batch;
    }
}

