/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThreadUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadUtils.class);
    private static final ThreadFactory THREAD_FACTORY;
    private static final Function<String, ExecutorService> EXECUTOR_SERVICE_FACTORY;
    private static final Predicate<Thread> IS_VIRTUAL;

    private ThreadUtils() {
    }

    static ThreadFactory threadFactory(String prefix) {
        if (prefix == null) {
            return Executors.defaultThreadFactory();
        }
        return new NamedThreadFactory(prefix);
    }

    static ThreadFactory internalThreadFactory(String prefix) {
        return new NamedThreadFactory(THREAD_FACTORY, prefix);
    }

    static boolean isVirtual(Thread thread) {
        return IS_VIRTUAL.test(thread);
    }

    private static boolean isJava21OrMore() {
        return Runtime.version().compareTo(Runtime.Version.parse("21")) >= 0;
    }

    static {
        if (ThreadUtils.isJava21OrMore()) {
            LOGGER.debug("Running Java 21 or more, using virtual threads");
            Class builderClass = Arrays.stream(Thread.class.getDeclaredClasses()).filter(c -> "Builder".equals(c.getSimpleName())).findFirst().get();
            try {
                Object builder = Thread.class.getDeclaredMethod("ofVirtual", new Class[0]).invoke(null, new Object[0]);
                THREAD_FACTORY = (ThreadFactory)builderClass.getDeclaredMethod("factory", new Class[0]).invoke(builder, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            EXECUTOR_SERVICE_FACTORY = prefix -> {
                try {
                    Object builder = Thread.class.getDeclaredMethod("ofVirtual", new Class[0]).invoke(null, new Object[0]);
                    if (prefix != null) {
                        builder = builderClass.getDeclaredMethod("name", String.class, Long.TYPE).invoke(builder, prefix, 0L);
                    }
                    ThreadFactory factory = (ThreadFactory)builderClass.getDeclaredMethod("factory", new Class[0]).invoke(builder, new Object[0]);
                    return (ExecutorService)Executors.class.getDeclaredMethod("newThreadPerTaskExecutor", ThreadFactory.class).invoke(null, factory);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            IS_VIRTUAL = thread -> {
                Method method = null;
                try {
                    method = Thread.class.getDeclaredMethod("isVirtual", new Class[0]);
                    return (Boolean)method.invoke(thread, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.info("Error while checking if a thread is virtual: {}", (Object)e.getMessage());
                    return false;
                }
            };
        } else {
            THREAD_FACTORY = Executors.defaultThreadFactory();
            EXECUTOR_SERVICE_FACTORY = prefix -> Executors.newCachedThreadPool(ThreadUtils.threadFactory(prefix));
            IS_VIRTUAL = ignored -> false;
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadFactory backingThreadFactory;
        private final String prefix;
        private final AtomicLong count = new AtomicLong(0L);

        private NamedThreadFactory(String prefix) {
            this(Executors.defaultThreadFactory(), prefix);
        }

        private NamedThreadFactory(ThreadFactory backingThreadFactory, String prefix) {
            this.backingThreadFactory = backingThreadFactory;
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.backingThreadFactory.newThread(r);
            thread.setName(this.prefix + this.count.getAndIncrement());
            return thread;
        }
    }
}

