/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.BackOffDelayPolicy;
import com.rabbitmq.stream.StreamDoesNotExistException;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.impl.AsyncRetry;
import com.rabbitmq.stream.impl.Client;
import com.rabbitmq.stream.impl.StreamConsumer;
import com.rabbitmq.stream.impl.StreamEnvironment;
import com.rabbitmq.stream.impl.StreamProducer;
import com.rabbitmq.stream.impl.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProducersCoordinator {
    static final int MAX_PRODUCERS_PER_CLIENT = 256;
    static final int MAX_TRACKING_CONSUMERS_PER_CLIENT = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducersCoordinator.class);
    private final StreamEnvironment environment;
    private final Utils.ClientFactory clientFactory;
    private final Map<String, ManagerPool> pools = new ConcurrentHashMap<String, ManagerPool>();
    private final int maxProducersByClient;
    private final int maxTrackingConsumersByClient;
    private final Function<Utils.ClientConnectionType, String> connectionNamingStrategy;

    ProducersCoordinator(StreamEnvironment environment, int maxProducersByClient, int maxTrackingConsumersByClient, Function<Utils.ClientConnectionType, String> connectionNamingStrategy, Utils.ClientFactory clientFactory) {
        this.environment = environment;
        this.clientFactory = clientFactory;
        this.maxProducersByClient = maxProducersByClient;
        this.maxTrackingConsumersByClient = maxTrackingConsumersByClient;
        this.connectionNamingStrategy = connectionNamingStrategy;
    }

    private static String keyForManagerPool(Client.Broker broker) {
        return broker.getHost() + ":" + broker.getPort();
    }

    Runnable registerProducer(StreamProducer producer, String reference, String stream) {
        return this.registerAgentTracker(new ProducerTracker(reference, stream, producer), stream);
    }

    Runnable registerTrackingConsumer(StreamConsumer consumer) {
        return this.registerAgentTracker(new TrackingConsumerTracker(consumer.stream(), consumer), consumer.stream());
    }

    private Runnable registerAgentTracker(AgentTracker tracker, String stream) {
        Client.Broker brokerForProducer = this.getBrokerForProducer(stream);
        String key = ProducersCoordinator.keyForManagerPool(brokerForProducer);
        ManagerPool pool = this.pools.computeIfAbsent(key, s -> new ManagerPool(key, this.environment.clientParametersCopy().host(brokerForProducer.getHost()).port(brokerForProducer.getPort())));
        pool.add(tracker);
        return tracker::cancel;
    }

    private Client.Broker getBrokerForProducer(String stream) {
        Map metadata = this.environment.locatorOperation(c -> c.metadata(stream));
        if (metadata.size() == 0 || metadata.get(stream) == null) {
            throw new StreamDoesNotExistException(stream);
        }
        Client.StreamMetadata streamMetadata = (Client.StreamMetadata)metadata.get(stream);
        if (!streamMetadata.isResponseOk()) {
            if (streamMetadata.getResponseCode() == 2) {
                throw new StreamDoesNotExistException(stream);
            }
            throw new IllegalStateException("Could not get stream metadata, response code: " + streamMetadata.getResponseCode());
        }
        Client.Broker leader = streamMetadata.getLeader();
        if (leader == null) {
            throw new IllegalStateException("Not leader available for stream " + stream);
        }
        LOGGER.debug("Using client on {}:{} to publish to {}", new Object[]{leader.getHost(), leader.getPort(), stream});
        return leader;
    }

    void close() {
        for (ManagerPool pool : this.pools.values()) {
            pool.close();
        }
        this.pools.clear();
    }

    int poolSize() {
        return this.pools.size();
    }

    int clientCount() {
        return this.pools.values().stream().map(pool -> ((ManagerPool)pool).managers.size()).reduce(0, Integer::sum);
    }

    public String toString() {
        return "[ \n" + this.pools.entrySet().stream().map(poolEntry -> "  { \"broker\" : \"" + (String)poolEntry.getKey() + "\", \"clients\" : [ " + ((ManagerPool)poolEntry.getValue()).managers.stream().map(manager -> "{ \"producer_count\" : " + ((ClientProducersManager)manager).producers.size() + ",   \"tracking_consumer_count\" : " + ((ClientProducersManager)manager).trackingConsumerTrackers.size() + " }").collect(Collectors.joining(", ")) + " ] }").collect(Collectors.joining(", \n")) + "\n]";
    }

    private class ClientProducersManager {
        private final ConcurrentMap<Byte, ProducerTracker> producers;
        private final Set<AgentTracker> trackingConsumerTrackers;
        private final Map<String, Set<AgentTracker>> streamToTrackers;
        private final Client client;
        private final ManagerPool owner;

        private ClientProducersManager(ManagerPool owner, Utils.ClientFactory cf, Client.ClientParameters clientParameters) {
            this.producers = new ConcurrentHashMap<Byte, ProducerTracker>(ProducersCoordinator.this.maxProducersByClient);
            this.trackingConsumerTrackers = ConcurrentHashMap.newKeySet(ProducersCoordinator.this.maxTrackingConsumersByClient);
            this.streamToTrackers = new ConcurrentHashMap<String, Set<AgentTracker>>();
            this.owner = owner;
            AtomicReference<Client> ref = new AtomicReference<Client>();
            AtomicBoolean clientInitializedInManager = new AtomicBoolean(false);
            Client.PublishConfirmListener publishConfirmListener = (publisherId, publishingId) -> {
                ProducerTracker producerTracker = (ProducerTracker)this.producers.get(publisherId);
                if (producerTracker == null) {
                    LOGGER.info("Received publish confirm for unknown producer: {}", (Object)publisherId);
                } else {
                    producerTracker.producer.confirm(publishingId);
                }
            };
            Client.PublishErrorListener publishErrorListener = (publisherId, publishingId, errorCode) -> {
                ProducerTracker producerTracker = (ProducerTracker)this.producers.get(publisherId);
                if (producerTracker == null) {
                    LOGGER.info("Received publish error for unknown producer: {}, error code {}", (Object)publisherId, (Object)Utils.formatConstant(errorCode));
                } else {
                    producerTracker.producer.error(publishingId, errorCode);
                }
            };
            Client.ShutdownListener shutdownListener = shutdownContext -> {
                if (clientInitializedInManager.get()) {
                    owner.remove(this);
                }
                if (shutdownContext.isShutdownUnexpected()) {
                    LOGGER.debug("Recovering {} producers after unexpected connection termination", (Object)this.producers.size());
                    this.producers.forEach((publishingId, tracker) -> tracker.unavailable());
                    this.trackingConsumerTrackers.forEach(AgentTracker::unavailable);
                    ProducersCoordinator.this.environment.scheduledExecutorService().execute(() -> {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        this.streamToTrackers.forEach((stream, trackers) -> {
                            if (!Thread.currentThread().isInterrupted()) {
                                this.assignProducersToNewManagers((Collection<AgentTracker>)trackers, (String)stream, ProducersCoordinator.this.environment.recoveryBackOffDelayPolicy());
                            }
                        });
                    });
                }
            };
            Client.MetadataListener metadataListener = (stream, code) -> {
                ClientProducersManager clientProducersManager = this;
                synchronized (clientProducersManager) {
                    Set<AgentTracker> affectedTrackers = this.streamToTrackers.remove(stream);
                    if (affectedTrackers != null && !affectedTrackers.isEmpty()) {
                        affectedTrackers.forEach(tracker -> {
                            tracker.unavailable();
                            if (tracker.identifiable()) {
                                this.producers.remove(tracker.id());
                            } else {
                                this.trackingConsumerTrackers.remove(tracker);
                            }
                        });
                        ProducersCoordinator.this.environment.scheduledExecutorService().execute(() -> {
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            this.owner.maybeDisposeManager(this);
                            this.assignProducersToNewManagers(affectedTrackers, stream, ProducersCoordinator.this.environment.topologyUpdateBackOffDelayPolicy());
                        });
                    }
                }
            };
            Utils.ClientFactoryContext connectionFactoryContext = Utils.ClientFactoryContext.fromParameters(clientParameters.publishConfirmListener(publishConfirmListener).publishErrorListener(publishErrorListener).shutdownListener(shutdownListener).metadataListener(metadataListener).clientProperty("connection_name", (String)ProducersCoordinator.this.connectionNamingStrategy.apply(Utils.ClientConnectionType.PRODUCER))).key(owner.name);
            this.client = cf.client(connectionFactoryContext);
            clientInitializedInManager.set(true);
            ref.set(this.client);
        }

        private void assignProducersToNewManagers(Collection<AgentTracker> trackers, String stream, BackOffDelayPolicy delayPolicy) {
            ((CompletableFuture)AsyncRetry.asyncRetry(() -> ProducersCoordinator.this.getBrokerForProducer(stream)).description("Candidate lookup to publish to " + stream).scheduler(ProducersCoordinator.this.environment.scheduledExecutorService()).retry(ex -> !(ex instanceof StreamDoesNotExistException)).delayPolicy(delayPolicy).build().thenAccept(broker -> {
                String key = ProducersCoordinator.keyForManagerPool(broker);
                LOGGER.debug("Assigning {} producer(s) to {}", (Object)trackers.size(), (Object)key);
                trackers.forEach(tracker -> {
                    try {
                        if (tracker.isOpen()) {
                            ManagerPool pool = ProducersCoordinator.this.pools.computeIfAbsent(key, s -> new ManagerPool(key, ProducersCoordinator.this.environment.clientParametersCopy().host(broker.getHost()).port(broker.getPort())));
                            pool.add(tracker);
                            tracker.running();
                        } else {
                            LOGGER.debug("Not re-assigning producer because it has been closed");
                        }
                    }
                    catch (Exception e) {
                        LOGGER.info("Error while re-assigning producer {} to {}: {}. Moving on.", new Object[]{tracker.identifiable() ? Byte.valueOf(tracker.id()) : "(tracking consumer)", key, e.getMessage()});
                    }
                });
            })).exceptionally(ex -> {
                LOGGER.info("Error while re-assigning producers: {}", (Object)ex.getMessage());
                for (AgentTracker tracker : trackers) {
                    try {
                        short code = ex instanceof StreamDoesNotExistException || ex.getCause() instanceof StreamDoesNotExistException ? (short)2 : (short)6;
                        tracker.closeAfterStreamDeletion(code);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error while closing producer: {}", (Object)e.getMessage());
                    }
                }
                return null;
            });
        }

        private synchronized void register(AgentTracker tracker) {
            if (tracker.identifiable()) {
                ProducerTracker producerTracker = (ProducerTracker)tracker;
                for (int i = 0; i < ProducersCoordinator.this.maxProducersByClient; ++i) {
                    ProducerTracker previousValue = this.producers.putIfAbsent((byte)i, producerTracker);
                    if (previousValue != null) continue;
                    Client.Response response = this.client.declarePublisher((byte)i, tracker.reference(), tracker.stream());
                    if (response.isOk()) {
                        tracker.assign((byte)i, this.client, this);
                        break;
                    }
                    String message = "Error while declaring publisher: " + Utils.formatConstant(response.getResponseCode()) + ". Could not assign producer to client.";
                    LOGGER.info(message);
                    throw new StreamException(message, response.getResponseCode());
                }
                this.producers.put(tracker.id(), producerTracker);
            } else {
                tracker.assign((byte)0, this.client, this);
                this.trackingConsumerTrackers.add(tracker);
            }
            this.streamToTrackers.computeIfAbsent(tracker.stream(), s -> ConcurrentHashMap.newKeySet()).add(tracker);
        }

        private synchronized void unregister(AgentTracker tracker) {
            if (tracker.identifiable()) {
                this.producers.remove(tracker.id());
            } else {
                this.trackingConsumerTrackers.remove(tracker);
            }
            this.streamToTrackers.compute(tracker.stream(), (s, trackersForThisStream) -> {
                if (s == null || trackersForThisStream == null) {
                    return null;
                }
                trackersForThisStream.remove(tracker);
                return trackersForThisStream.isEmpty() ? null : trackersForThisStream;
            });
            this.owner.maybeDisposeManager(this);
        }

        synchronized boolean isFullFor(AgentTracker tracker) {
            if (tracker.identifiable()) {
                return this.producers.size() == ProducersCoordinator.this.maxProducersByClient;
            }
            return this.trackingConsumerTrackers.size() == ProducersCoordinator.this.maxTrackingConsumersByClient;
        }

        synchronized boolean isEmpty() {
            return this.producers.isEmpty() && this.trackingConsumerTrackers.isEmpty();
        }

        private void close() {
            try {
                if (this.client.isOpen()) {
                    this.client.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ManagerPool {
        private final List<ClientProducersManager> managers = new CopyOnWriteArrayList<ClientProducersManager>();
        private final String name;
        private final Client.ClientParameters clientParameters;

        private ManagerPool(String name, Client.ClientParameters clientParameters) {
            this.name = name;
            this.clientParameters = clientParameters;
            this.managers.add(new ClientProducersManager(this, ProducersCoordinator.this.clientFactory, clientParameters));
        }

        private synchronized void add(AgentTracker producerTracker) {
            boolean added = false;
            for (ClientProducersManager manager : this.managers) {
                if (manager.isFullFor(producerTracker)) continue;
                manager.register(producerTracker);
                added = true;
                break;
            }
            if (!added) {
                LOGGER.debug("Creating producers tracker on {}, this is subscription state #{}", (Object)this.name, (Object)(this.managers.size() + 1));
                ClientProducersManager manager = new ClientProducersManager(this, ProducersCoordinator.this.clientFactory, this.clientParameters);
                this.managers.add(manager);
                manager.register(producerTracker);
            }
        }

        synchronized void maybeDisposeManager(ClientProducersManager manager) {
            if (manager.isEmpty()) {
                manager.close();
                this.remove(manager);
            }
        }

        private synchronized void remove(ClientProducersManager manager) {
            this.managers.remove(manager);
            if (this.managers.isEmpty()) {
                ProducersCoordinator.this.pools.remove(this.name);
            }
        }

        synchronized void close() {
            for (ClientProducersManager manager : this.managers) {
                manager.close();
            }
            this.managers.clear();
        }
    }

    private static class TrackingConsumerTracker
    implements AgentTracker {
        private final String stream;
        private final StreamConsumer consumer;
        private volatile ClientProducersManager clientProducersManager;

        private TrackingConsumerTracker(String stream, StreamConsumer consumer) {
            this.stream = stream;
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void assign(byte producerId, Client client, ClientProducersManager manager) {
            TrackingConsumerTracker trackingConsumerTracker = this;
            synchronized (trackingConsumerTracker) {
                this.clientProducersManager = manager;
            }
            this.consumer.setTrackingClient(client);
        }

        @Override
        public boolean identifiable() {
            return false;
        }

        @Override
        public byte id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String reference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String stream() {
            return this.stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unavailable() {
            TrackingConsumerTracker trackingConsumerTracker = this;
            synchronized (trackingConsumerTracker) {
                this.clientProducersManager = null;
            }
            this.consumer.unavailable();
        }

        @Override
        public void running() {
            this.consumer.running();
        }

        @Override
        public synchronized void cancel() {
            if (this.clientProducersManager != null) {
                this.clientProducersManager.unregister(this);
            }
        }

        @Override
        public void closeAfterStreamDeletion(short code) {
        }

        @Override
        public boolean isOpen() {
            return this.consumer.isOpen();
        }
    }

    private static class ProducerTracker
    implements AgentTracker {
        private final String reference;
        private final String stream;
        private final StreamProducer producer;
        private volatile byte publisherId;
        private volatile ClientProducersManager clientProducersManager;

        private ProducerTracker(String reference, String stream, StreamProducer producer) {
            this.reference = reference;
            this.stream = stream;
            this.producer = producer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void assign(byte producerId, Client client, ClientProducersManager manager) {
            ProducerTracker producerTracker = this;
            synchronized (producerTracker) {
                this.publisherId = producerId;
                this.clientProducersManager = manager;
            }
            this.producer.setPublisherId(producerId);
            this.producer.setClient(client);
        }

        @Override
        public boolean identifiable() {
            return true;
        }

        @Override
        public byte id() {
            return this.publisherId;
        }

        @Override
        public String reference() {
            return this.reference;
        }

        @Override
        public String stream() {
            return this.stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unavailable() {
            ProducerTracker producerTracker = this;
            synchronized (producerTracker) {
                this.clientProducersManager = null;
            }
            this.producer.unavailable();
        }

        @Override
        public void running() {
            this.producer.running();
        }

        @Override
        public synchronized void cancel() {
            if (this.clientProducersManager != null) {
                this.clientProducersManager.unregister(this);
            }
        }

        @Override
        public void closeAfterStreamDeletion(short code) {
            this.producer.closeAfterStreamDeletion(code);
        }

        @Override
        public boolean isOpen() {
            return this.producer.isOpen();
        }
    }

    private static interface AgentTracker {
        public void assign(byte var1, Client var2, ClientProducersManager var3);

        public boolean identifiable();

        public byte id();

        public void unavailable();

        public void running();

        public void cancel();

        public void closeAfterStreamDeletion(short var1);

        public String stream();

        public String reference();

        public boolean isOpen();
    }
}

