/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.perf;

import com.rabbitmq.stream.perf.Monitoring;
import com.rabbitmq.stream.perf.MonitoringContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import picocli.CommandLine;

class PrometheusEndpointMonitoring
implements Monitoring {
    @CommandLine.Option(names={"--prometheus"}, description={"Enable HTTP Prometheus metrics endpoint"}, defaultValue="false")
    private boolean enabled;
    private volatile PrometheusMeterRegistry registry;

    PrometheusEndpointMonitoring() {
    }

    @Override
    public void configure(MonitoringContext context) {
        if (this.enabled) {
            this.registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            context.meterRegistry().add((MeterRegistry)this.registry);
            context.addHttpEndpoint("metrics", "Prometheus metrics", exchange -> {
                exchange.getResponseHeaders().set("Content-Type", "text/plain");
                byte[] content = this.registry.scrape().getBytes(StandardCharsets.UTF_8);
                exchange.sendResponseHeaders(200, content.length);
                try (OutputStream out = exchange.getResponseBody();){
                    out.write(content);
                }
            });
        }
    }
}

