/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.codec;

import com.rabbitmq.stream.Codec;
import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageBuilder;
import com.rabbitmq.stream.Properties;
import com.rabbitmq.stream.StreamException;
import com.rabbitmq.stream.amqp.Symbol;
import com.rabbitmq.stream.amqp.UnsignedByte;
import com.rabbitmq.stream.amqp.UnsignedInteger;
import com.rabbitmq.stream.amqp.UnsignedLong;
import com.rabbitmq.stream.amqp.UnsignedShort;
import com.rabbitmq.stream.codec.SwiftMqMessageBuilder;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.AddressString;
import com.swiftmq.amqp.v100.generated.messaging.message_format.ApplicationProperties;
import com.swiftmq.amqp.v100.generated.messaging.message_format.Data;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageAnnotations;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdBinary;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdIF;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdString;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdUlong;
import com.swiftmq.amqp.v100.generated.messaging.message_format.MessageIdUuid;
import com.swiftmq.amqp.v100.generated.transport.definitions.SequenceNo;
import com.swiftmq.amqp.v100.messaging.AMQPMessage;
import com.swiftmq.amqp.v100.types.AMQPArray;
import com.swiftmq.amqp.v100.types.AMQPBinary;
import com.swiftmq.amqp.v100.types.AMQPBoolean;
import com.swiftmq.amqp.v100.types.AMQPByte;
import com.swiftmq.amqp.v100.types.AMQPChar;
import com.swiftmq.amqp.v100.types.AMQPDouble;
import com.swiftmq.amqp.v100.types.AMQPFloat;
import com.swiftmq.amqp.v100.types.AMQPInt;
import com.swiftmq.amqp.v100.types.AMQPList;
import com.swiftmq.amqp.v100.types.AMQPLong;
import com.swiftmq.amqp.v100.types.AMQPMap;
import com.swiftmq.amqp.v100.types.AMQPNull;
import com.swiftmq.amqp.v100.types.AMQPShort;
import com.swiftmq.amqp.v100.types.AMQPString;
import com.swiftmq.amqp.v100.types.AMQPSymbol;
import com.swiftmq.amqp.v100.types.AMQPTimestamp;
import com.swiftmq.amqp.v100.types.AMQPType;
import com.swiftmq.amqp.v100.types.AMQPUnsignedByte;
import com.swiftmq.amqp.v100.types.AMQPUnsignedInt;
import com.swiftmq.amqp.v100.types.AMQPUnsignedLong;
import com.swiftmq.amqp.v100.types.AMQPUnsignedShort;
import com.swiftmq.amqp.v100.types.AMQPUuid;
import com.swiftmq.tools.util.DataByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SwiftMqCodec
implements Codec {
    static final Data EMPTY_BODY = new Data(new byte[0]);

    private static Object convertAmqpMapValue(AMQPType value) {
        if (value instanceof AMQPBoolean) {
            return ((AMQPBoolean)value).getValue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (value instanceof AMQPByte) {
            return ((AMQPByte)value).getValue();
        }
        if (value instanceof AMQPUnsignedByte) {
            return UnsignedByte.valueOf((byte)((AMQPUnsignedByte)value).getValue());
        }
        if (value instanceof AMQPShort) {
            return (short)((AMQPShort)value).getValue();
        }
        if (value instanceof AMQPUnsignedShort) {
            return UnsignedShort.valueOf((short)((AMQPUnsignedShort)value).getValue());
        }
        if (value instanceof AMQPInt) {
            return ((AMQPInt)value).getValue();
        }
        if (value instanceof AMQPUnsignedInt) {
            return UnsignedInteger.valueOf(((AMQPUnsignedInt)value).getValue());
        }
        if (value instanceof AMQPLong) {
            return ((AMQPLong)value).getValue();
        }
        if (value instanceof AMQPUnsignedLong) {
            return UnsignedLong.valueOf(((AMQPUnsignedLong)value).getValue());
        }
        if (value instanceof AMQPFloat) {
            return Float.valueOf(((AMQPFloat)value).getValue());
        }
        if (value instanceof AMQPDouble) {
            return ((AMQPDouble)value).getValue();
        }
        if (value instanceof AMQPBinary) {
            return ((AMQPBinary)value).getValue();
        }
        if (value instanceof AMQPString) {
            return ((AMQPString)value).getValue();
        }
        if (value instanceof AMQPChar) {
            return Character.valueOf((char)(((AMQPChar)value).getValue() & 0xFFFF));
        }
        if (value instanceof AMQPTimestamp) {
            return ((AMQPTimestamp)value).getValue();
        }
        if (value instanceof AMQPUuid) {
            return ((AMQPUuid)value).getValue();
        }
        if (value instanceof AMQPSymbol) {
            return ((AMQPSymbol)value).getValue();
        }
        if (value instanceof AMQPList) {
            try {
                List source = ((AMQPList)value).getValue();
                ArrayList<Object> target = new ArrayList<Object>(source.size());
                for (AMQPType o : source) {
                    target.add(SwiftMqCodec.convertAmqpMapValue(o));
                }
                return target;
            }
            catch (IOException e) {
                throw new StreamException("Error while reading SwiftMQ list", e);
            }
        }
        if (value instanceof AMQPMap) {
            try {
                Map source = ((AMQPMap)value).getValue();
                LinkedHashMap<Object, Object> target = new LinkedHashMap<Object, Object>(source.size());
                for (Map.Entry entry : source.entrySet()) {
                    target.put(SwiftMqCodec.convertAmqpMapValue((AMQPType)entry.getKey()), SwiftMqCodec.convertAmqpMapValue((AMQPType)entry.getValue()));
                }
                return target;
            }
            catch (IOException e) {
                throw new StreamException("Error while reading SwiftMQ map", e);
            }
        }
        if (value instanceof AMQPArray) {
            try {
                AMQPType[] source = ((AMQPArray)value).getValue();
                Object target = Array.newInstance(source.length == 0 ? Object.class : SwiftMqCodec.convertAmqpMapValue(source[0]).getClass(), source.length);
                for (int i = 0; i < source.length; ++i) {
                    Array.set(target, i, SwiftMqCodec.convertAmqpMapValue(source[i]));
                }
                return target;
            }
            catch (IOException e) {
                throw new StreamException("Error while reading SwiftMQ array", e);
            }
        }
        if (value instanceof AMQPNull) {
            return null;
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("Type not supported: " + String.valueOf(value.getClass()));
    }

    private static Map<String, Object> createApplicationProperties(AMQPMessage amqpMessage) {
        if (amqpMessage.getApplicationProperties() != null) {
            Map applicationProperties;
            try {
                applicationProperties = amqpMessage.getApplicationProperties().getValue();
            }
            catch (IOException e) {
                throw new StreamException("Error while reading application properties", e);
            }
            return SwiftMqCodec.createMapFromAmqpMap(applicationProperties);
        }
        return null;
    }

    private static Map<String, Object> createMessageAnnotations(AMQPMessage amqpMessage) {
        if (amqpMessage.getMessageAnnotations() != null) {
            Map messageAnnotations;
            try {
                messageAnnotations = amqpMessage.getMessageAnnotations().getValue();
            }
            catch (IOException e) {
                throw new StreamException("Error while reading message annotations", e);
            }
            return SwiftMqCodec.createMapFromAmqpMap(messageAnnotations);
        }
        return null;
    }

    private static Map<String, Object> createMapFromAmqpMap(Map<AMQPType, AMQPType> map) {
        LinkedHashMap<String, Object> result;
        if (map != null) {
            result = new LinkedHashMap<String, Object>(map.size());
            for (Map.Entry<AMQPType, AMQPType> entry : map.entrySet()) {
                result.put(entry.getKey().getValueString(), SwiftMqCodec.convertAmqpMapValue(entry.getValue()));
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public MessageBuilder messageBuilder() {
        return new SwiftMqMessageBuilder();
    }

    @Override
    public Codec.EncodedMessage encode(Message message) {
        AMQPMessage outboundMessage;
        if (message instanceof SwiftMqAmqpMessageWrapper) {
            outboundMessage = ((SwiftMqAmqpMessageWrapper)message).message;
        } else {
            outboundMessage = new AMQPMessage();
            if (message.getProperties() != null) {
                boolean bl;
                Properties headers = message.getProperties();
                com.swiftmq.amqp.v100.generated.messaging.message_format.Properties properties = new com.swiftmq.amqp.v100.generated.messaging.message_format.Properties();
                boolean bl2 = false;
                if (headers.getMessageId() != null) {
                    if (headers.getMessageId() instanceof String) {
                        properties.setMessageId((MessageIdIF)new MessageIdString(headers.getMessageIdAsString()));
                    } else if (headers.getMessageId().getClass().isPrimitive() || headers.getMessageId() instanceof Long) {
                        properties.setMessageId((MessageIdIF)new MessageIdUlong(headers.getMessageIdAsLong()));
                    } else if (headers.getMessageId().getClass().isArray()) {
                        properties.setMessageId((MessageIdIF)new MessageIdBinary(headers.getMessageIdAsBinary()));
                    } else if (headers.getMessageId() instanceof UUID) {
                        properties.setMessageId((MessageIdIF)new MessageIdUuid(headers.getMessageIdAsUuid()));
                    } else {
                        throw new IllegalStateException("Type not supported for message ID:" + String.valueOf(properties.getMessageId().getClass()));
                    }
                    boolean bl3 = true;
                }
                if (headers.getUserId() != null) {
                    properties.setUserId(new AMQPBinary(headers.getUserId()));
                    boolean bl4 = true;
                }
                if (headers.getTo() != null) {
                    properties.setTo((AddressIF)new AddressString(headers.getTo()));
                    boolean bl5 = true;
                }
                if (headers.getSubject() != null) {
                    properties.setSubject(new AMQPString(headers.getSubject()));
                    boolean bl6 = true;
                }
                if (headers.getReplyTo() != null) {
                    properties.setReplyTo((AddressIF)new AddressString(headers.getReplyTo()));
                    boolean bl7 = true;
                }
                if (headers.getCorrelationId() != null) {
                    if (headers.getCorrelationId() instanceof String) {
                        properties.setCorrelationId((MessageIdIF)new MessageIdString(headers.getCorrelationIdAsString()));
                    } else if (headers.getCorrelationId().getClass().isPrimitive() || headers.getCorrelationId() instanceof Long) {
                        properties.setCorrelationId((MessageIdIF)new MessageIdUlong(headers.getCorrelationIdAsLong()));
                    } else if (headers.getCorrelationId().getClass().isArray()) {
                        properties.setCorrelationId((MessageIdIF)new MessageIdBinary(headers.getCorrelationIdAsBinary()));
                    } else if (headers.getCorrelationId() instanceof UUID) {
                        properties.setCorrelationId((MessageIdIF)new MessageIdUuid(headers.getCorrelationIdAsUuid()));
                    } else {
                        throw new IllegalStateException("Type not supported for correlation ID:" + String.valueOf(properties.getCorrelationId().getClass()));
                    }
                    boolean bl8 = true;
                }
                if (headers.getContentType() != null) {
                    properties.setContentType(new AMQPSymbol(headers.getContentType()));
                    boolean bl9 = true;
                }
                if (headers.getContentEncoding() != null) {
                    properties.setContentEncoding(new AMQPSymbol(headers.getContentEncoding()));
                    boolean bl10 = true;
                }
                if (headers.getAbsoluteExpiryTime() > 0L) {
                    properties.setAbsoluteExpiryTime(new AMQPTimestamp(headers.getAbsoluteExpiryTime()));
                    boolean bl11 = true;
                }
                if (headers.getCreationTime() > 0L) {
                    properties.setCreationTime(new AMQPTimestamp(headers.getCreationTime()));
                    boolean bl12 = true;
                }
                if (headers.getGroupId() != null) {
                    properties.setGroupId(new AMQPString(headers.getGroupId()));
                    boolean bl13 = true;
                }
                if (headers.getGroupSequence() >= 0L) {
                    properties.setGroupSequence(new SequenceNo(headers.getGroupSequence()));
                    boolean bl14 = true;
                }
                if (headers.getReplyToGroupId() != null) {
                    properties.setReplyToGroupId(new AMQPString(headers.getReplyToGroupId()));
                    bl = true;
                }
                if (bl) {
                    outboundMessage.setProperties(properties);
                }
            }
            if (message.getApplicationProperties() != null && !message.getApplicationProperties().isEmpty()) {
                LinkedHashMap<AMQPString, AMQPType> applicationProperties = new LinkedHashMap<AMQPString, AMQPType>(message.getApplicationProperties().size());
                for (Map.Entry entry : message.getApplicationProperties().entrySet()) {
                    applicationProperties.put(new AMQPString((String)entry.getKey()), SwiftMqCodec.convertToSwiftMqType(entry.getValue()));
                }
                try {
                    outboundMessage.setApplicationProperties(new ApplicationProperties(applicationProperties));
                }
                catch (IOException e) {
                    throw new StreamException("Error while setting application properties", e);
                }
            }
            if (message.getMessageAnnotations() != null && !message.getMessageAnnotations().isEmpty()) {
                LinkedHashMap<AMQPSymbol, AMQPType> messageAnnotations = new LinkedHashMap<AMQPSymbol, AMQPType>(message.getMessageAnnotations().size());
                for (Map.Entry<String, Object> entry : message.getMessageAnnotations().entrySet()) {
                    messageAnnotations.put(new AMQPSymbol(entry.getKey()), SwiftMqCodec.convertToSwiftMqType(entry.getValue()));
                }
                try {
                    outboundMessage.setMessageAnnotations(new MessageAnnotations(messageAnnotations));
                }
                catch (IOException e) {
                    throw new StreamException("Error while setting message annotations", e);
                }
            }
            if (message.getBodyAsBinary() == null) {
                outboundMessage.addData(EMPTY_BODY);
            } else {
                outboundMessage.addData(new Data(message.getBodyAsBinary()));
            }
        }
        try {
            int bufferSize = outboundMessage.getData() != null && !outboundMessage.getData().isEmpty() ? ((Data)outboundMessage.getData().get(0)).getPredictedSize() : 8192;
            DataByteArrayOutputStream output = new DataByteArrayOutputStream(bufferSize);
            outboundMessage.writeContent((DataOutput)output);
            return new Codec.EncodedMessage(output.getCount(), output.getBuffer());
        }
        catch (IOException e) {
            throw new StreamException("Error while writing AMQP 1.0 message to output stream", e);
        }
    }

    protected static AMQPType convertToSwiftMqType(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? AMQPBoolean.TRUE : AMQPBoolean.FALSE;
        }
        if (value instanceof Byte) {
            return new AMQPByte(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new AMQPShort((int)((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new AMQPInt(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new AMQPLong(((Long)value).longValue());
        }
        if (value instanceof UnsignedByte) {
            return new AMQPUnsignedByte((int)((UnsignedByte)value).byteValue());
        }
        if (value instanceof UnsignedShort) {
            return new AMQPUnsignedShort((int)((UnsignedShort)value).shortValue());
        }
        if (value instanceof UnsignedInteger) {
            return new AMQPUnsignedInt((long)((UnsignedInteger)value).intValue());
        }
        if (value instanceof UnsignedLong) {
            return new AMQPUnsignedLong(((UnsignedLong)value).longValue());
        }
        if (value instanceof Float) {
            return new AMQPFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new AMQPDouble(((Double)value).doubleValue());
        }
        if (value instanceof byte[]) {
            return new AMQPBinary((byte[])value);
        }
        if (value instanceof String) {
            return new AMQPString((String)value);
        }
        if (value instanceof Character) {
            return new AMQPChar((int)((Character)value).charValue());
        }
        if (value instanceof Date) {
            return new AMQPTimestamp(((Date)value).getTime());
        }
        if (value instanceof Symbol) {
            return new AMQPSymbol(value.toString());
        }
        if (value instanceof UUID) {
            return new AMQPUuid((UUID)value);
        }
        if (value instanceof List) {
            List source = (List)value;
            ArrayList<AMQPType> target = new ArrayList<AMQPType>(source.size());
            for (Object o : source) {
                target.add(SwiftMqCodec.convertToSwiftMqType(o));
            }
            try {
                return new AMQPList(target);
            }
            catch (IOException e) {
                throw new StreamException("Error while creating SwiftMQ list", e);
            }
        }
        if (value instanceof Map) {
            Map source = (Map)value;
            LinkedHashMap<AMQPType, AMQPType> target = new LinkedHashMap<AMQPType, AMQPType>(source.size());
            for (Map.Entry entry : source.entrySet()) {
                target.put(SwiftMqCodec.convertToSwiftMqType(entry.getKey()), SwiftMqCodec.convertToSwiftMqType(entry.getValue()));
            }
            try {
                return new AMQPMap(target);
            }
            catch (IOException e) {
                throw new StreamException("Error while creating SwiftMQ map", e);
            }
        }
        if (value instanceof Object[]) {
            Object[] source = (Object[])value;
            AMQPType[] target = new AMQPType[source.length];
            for (int i = 0; i < source.length; ++i) {
                target[i] = SwiftMqCodec.convertToSwiftMqType(source[i]);
            }
            try {
                int code = source.length == 0 ? 255 : SwiftMqCodec.toSwiftMqTypeCode(source[0]);
                return new AMQPArray(code, target);
            }
            catch (IOException e) {
                throw new StreamException("Error while creating SwiftMQ list", e);
            }
        }
        if (value == null) {
            return AMQPNull.NULL;
        }
        throw new IllegalArgumentException("Type not supported: " + String.valueOf(value.getClass()));
    }

    protected static int toSwiftMqTypeCode(Object value) {
        if (value instanceof Boolean) {
            return 86;
        }
        if (value instanceof Byte) {
            return 81;
        }
        if (value instanceof Short) {
            return 97;
        }
        if (value instanceof Integer) {
            int v = (Integer)value;
            return v < -128 || v > 127 ? 113 : 84;
        }
        if (value instanceof Long) {
            long v = (Long)value;
            return v < -128L || v > 127L ? 129 : 85;
        }
        if (value instanceof UnsignedByte) {
            return 80;
        }
        if (value instanceof UnsignedShort) {
            return 96;
        }
        if (value instanceof UnsignedInteger) {
            return 112;
        }
        if (value instanceof UnsignedLong) {
            return 128;
        }
        if (value instanceof Float) {
            return 114;
        }
        if (value instanceof Double) {
            return 130;
        }
        if (value instanceof byte[]) {
            return ((byte[])value).length > 255 ? 176 : 160;
        }
        if (value instanceof String) {
            return value.toString().getBytes(StandardCharsets.UTF_8).length > 255 ? 177 : 161;
        }
        if (value instanceof Character) {
            return 115;
        }
        if (value instanceof Date) {
            return 131;
        }
        if (value instanceof Symbol) {
            return value.toString().getBytes(StandardCharsets.US_ASCII).length > 255 ? 179 : 163;
        }
        if (value instanceof UUID) {
            return 152;
        }
        if (value instanceof List) {
            List l = (List)value;
            if (l.isEmpty()) {
                return 69;
            }
            if (l.size() > 255) {
                return 208;
            }
            return 192;
        }
        if (value instanceof Map) {
            Map source = (Map)value;
            return source.size() * 2 > 255 ? 209 : 193;
        }
        if (value instanceof Object[]) {
            Object[] source = (Object[])value;
            if (source.length > 255) {
                return 240;
            }
            return 224;
        }
        if (value == null) {
            return 64;
        }
        throw new IllegalArgumentException("Type not supported: " + String.valueOf(value.getClass()));
    }

    @Override
    public Message decode(byte[] data) {
        return this.createMessage(data);
    }

    protected Object extractBody(AMQPMessage amqpMessage) {
        Object body = amqpMessage.getData() != null ? amqpMessage.getData() : (amqpMessage.getAmqpValue() != null ? amqpMessage.getAmqpValue() : (amqpMessage.getAmqpSequence() != null ? amqpMessage.getAmqpSequence() : null));
        return body;
    }

    protected Properties createProperties(AMQPMessage amqpMessage) {
        if (amqpMessage.getProperties() != null) {
            return new SwiftMqProperties(amqpMessage.getProperties());
        }
        return null;
    }

    protected Message createMessage(byte[] data) {
        AMQPMessage amqpMessage;
        try {
            amqpMessage = new AMQPMessage(data);
        }
        catch (Exception e) {
            throw new StreamException("Error while decoding AMQP 1.0 message", e);
        }
        Object body = this.extractBody(amqpMessage);
        Properties properties = this.createProperties(amqpMessage);
        Map<String, Object> applicationProperties = SwiftMqCodec.createApplicationProperties(amqpMessage);
        Map<String, Object> messageAnnotations = SwiftMqCodec.createMessageAnnotations(amqpMessage);
        return new SwiftMqMessage(amqpMessage, body, properties, applicationProperties, messageAnnotations);
    }

    static class SwiftMqAmqpMessageWrapper
    implements Message {
        private final boolean hasPublishingId;
        private final long publishingId;
        private final AMQPMessage message;
        private Properties properties;
        private Map<String, Object> applicationProperties;
        private Map<String, Object> messageAnnotations;

        SwiftMqAmqpMessageWrapper(boolean hasPublishingId, long publishingId, AMQPMessage message) {
            this.hasPublishingId = hasPublishingId;
            this.publishingId = publishingId;
            this.message = message;
        }

        @Override
        public boolean hasPublishingId() {
            return this.hasPublishingId;
        }

        @Override
        public long getPublishingId() {
            return this.publishingId;
        }

        @Override
        public byte[] getBodyAsBinary() {
            return ((Data)this.message.getData().get(0)).getValue();
        }

        @Override
        public Object getBody() {
            return this.message.getData();
        }

        @Override
        public Properties getProperties() {
            if (this.properties != null) {
                return this.properties;
            }
            if (this.message.getProperties() != null) {
                this.properties = new SwiftMqProperties(this.message.getProperties());
                return this.properties;
            }
            return null;
        }

        @Override
        public Map<String, Object> getApplicationProperties() {
            if (this.applicationProperties != null) {
                return this.applicationProperties;
            }
            if (this.message.getApplicationProperties() != null) {
                this.applicationProperties = SwiftMqCodec.createApplicationProperties(this.message);
                return this.applicationProperties;
            }
            return null;
        }

        @Override
        public Map<String, Object> getMessageAnnotations() {
            if (this.messageAnnotations != null) {
                return this.messageAnnotations;
            }
            if (this.message.getMessageAnnotations() != null) {
                this.messageAnnotations = SwiftMqCodec.createMessageAnnotations(this.message);
                return this.messageAnnotations;
            }
            return null;
        }

        @Override
        public Message annotate(String key, Object value) {
            MessageAnnotations annotations = this.message.getMessageAnnotations();
            try {
                LinkedHashMap<AMQPSymbol, AMQPType> map;
                if (annotations == null) {
                    map = new LinkedHashMap<AMQPSymbol, AMQPType>();
                    annotations = new MessageAnnotations(map);
                    this.message.setMessageAnnotations(annotations);
                } else {
                    map = annotations.getValue();
                }
                map.put(new AMQPSymbol(key), SwiftMqCodec.convertToSwiftMqType(value));
                annotations.setValue(map);
            }
            catch (IOException e) {
                throw new StreamException("Error while annotating SwiftMQ message", e);
            }
            return this;
        }

        @Override
        public Message copy() {
            AMQPMessage copy = new AMQPMessage();
            copy.setProperties(this.message.getProperties());
            if (this.message.getData() != null) {
                this.message.getData().forEach(arg_0 -> ((AMQPMessage)copy).addData(arg_0));
            }
            copy.setApplicationProperties(this.message.getApplicationProperties());
            MessageAnnotations annotations = this.message.getMessageAnnotations();
            if (annotations != null) {
                LinkedHashMap annotationCopy = null;
                try {
                    annotationCopy = new LinkedHashMap(annotations.getValue().size());
                    annotationCopy.putAll(annotations.getValue());
                    copy.setMessageAnnotations(new MessageAnnotations(annotationCopy));
                }
                catch (IOException e) {
                    throw new StreamException("Error while copying SwiftMQ message annotations", e);
                }
            }
            return new SwiftMqAmqpMessageWrapper(this.hasPublishingId, this.publishingId, copy);
        }
    }

    private static final class SwiftMqProperties
    implements Properties {
        private static final long NULL_GROUP_SEQUENCE = -1L;
        private final com.swiftmq.amqp.v100.generated.messaging.message_format.Properties amqpProperties;

        private SwiftMqProperties(com.swiftmq.amqp.v100.generated.messaging.message_format.Properties amqpProperties) {
            this.amqpProperties = amqpProperties;
        }

        @Override
        public Object getMessageId() {
            return this.amqpProperties.getMessageId();
        }

        @Override
        public String getMessageIdAsString() {
            return this.amqpProperties.getMessageId().getValueString();
        }

        @Override
        public long getMessageIdAsLong() {
            return ((MessageIdUlong)this.amqpProperties.getMessageId()).getValue();
        }

        @Override
        public byte[] getMessageIdAsBinary() {
            return ((MessageIdBinary)this.amqpProperties.getMessageId()).getValue();
        }

        @Override
        public UUID getMessageIdAsUuid() {
            return ((MessageIdUuid)this.amqpProperties.getMessageId()).getValue();
        }

        @Override
        public byte[] getUserId() {
            return this.amqpProperties.getUserId().getValue();
        }

        @Override
        public String getTo() {
            return this.amqpProperties.getTo().getValueString();
        }

        @Override
        public String getSubject() {
            return this.amqpProperties.getSubject().getValue();
        }

        @Override
        public String getReplyTo() {
            return this.amqpProperties.getReplyTo().getValueString();
        }

        @Override
        public Object getCorrelationId() {
            return this.amqpProperties.getCorrelationId();
        }

        @Override
        public String getCorrelationIdAsString() {
            return ((MessageIdString)this.amqpProperties.getCorrelationId()).getValue();
        }

        @Override
        public long getCorrelationIdAsLong() {
            return ((MessageIdUlong)this.amqpProperties.getCorrelationId()).getValue();
        }

        @Override
        public byte[] getCorrelationIdAsBinary() {
            return ((MessageIdBinary)this.amqpProperties.getCorrelationId()).getValue();
        }

        @Override
        public UUID getCorrelationIdAsUuid() {
            return ((MessageIdUuid)this.amqpProperties.getCorrelationId()).getValue();
        }

        @Override
        public String getContentType() {
            return this.amqpProperties.getContentType().getValue();
        }

        @Override
        public String getContentEncoding() {
            return this.amqpProperties.getContentEncoding().getValue();
        }

        @Override
        public long getAbsoluteExpiryTime() {
            return this.amqpProperties.getAbsoluteExpiryTime().getValue();
        }

        @Override
        public long getCreationTime() {
            return this.amqpProperties.getCreationTime().getValue();
        }

        @Override
        public String getGroupId() {
            return this.amqpProperties.getGroupId().getValue();
        }

        @Override
        public long getGroupSequence() {
            return this.amqpProperties.getGroupSequence() == null ? -1L : this.amqpProperties.getGroupSequence().getValue();
        }

        @Override
        public String getReplyToGroupId() {
            return this.amqpProperties.getReplyToGroupId().getValue();
        }
    }

    private static final class SwiftMqMessage
    implements Message {
        private final AMQPMessage amqpMessage;
        private final Object body;
        private final Properties properties;
        private final Map<String, Object> applicationProperties;
        private final Map<String, Object> messageAnnotations;

        private SwiftMqMessage(AMQPMessage amqpMessage, Object body, Properties properties, Map<String, Object> applicationProperties, Map<String, Object> messageAnnotations) {
            this.amqpMessage = amqpMessage;
            this.body = body;
            this.properties = properties;
            this.applicationProperties = applicationProperties;
            this.messageAnnotations = messageAnnotations;
        }

        @Override
        public boolean hasPublishingId() {
            return false;
        }

        @Override
        public long getPublishingId() {
            return 0L;
        }

        @Override
        public byte[] getBodyAsBinary() {
            if (this.amqpMessage.getData() != null) {
                return ((Data)this.amqpMessage.getData().get(0)).getValue();
            }
            if (this.amqpMessage.getAmqpValue() != null) {
                AMQPType value = this.amqpMessage.getAmqpValue().getValue();
                if (value instanceof AMQPBinary) {
                    return ((AMQPBinary)value).getValue();
                }
                if (value instanceof AMQPArray) {
                    try {
                        AMQPType[] array = ((AMQPArray)value).getValue();
                        if (array.length > 0 && array[0] instanceof AMQPByte) {
                            byte[] result = new byte[array.length];
                            for (int i = 0; i < array.length; ++i) {
                                result[i] = ((AMQPByte)array[i]).getValue();
                            }
                            return result;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (this.amqpMessage.getData() == null && this.amqpMessage.getAmqpValue() == null) {
                return null;
            }
            throw new IllegalStateException("Body cannot by returned as array of bytes. Use #getBody() to get native representation.");
        }

        @Override
        public Object getBody() {
            if (this.amqpMessage.getData() != null) {
                return this.amqpMessage.getData();
            }
            if (this.amqpMessage.getAmqpValue() != null) {
                return this.amqpMessage.getAmqpValue();
            }
            return null;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public Map<String, Object> getApplicationProperties() {
            return this.applicationProperties;
        }

        @Override
        public Map<String, Object> getMessageAnnotations() {
            return this.messageAnnotations;
        }
    }
}

