/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.impl.Utils;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConcurrencyUtils {
    private static final Logger LOGGER;
    private static final ThreadFactory THREAD_FACTORY;

    private ConcurrencyUtils() {
    }

    static ThreadFactory defaultThreadFactory() {
        return THREAD_FACTORY;
    }

    private static boolean isJava21OrMore() {
        String version = System.getProperty("java.version").replace("-beta", "");
        return Utils.versionCompare(version, "21.0") >= 0;
    }

    static {
        ThreadFactory tf;
        LOGGER = LoggerFactory.getLogger(ConcurrencyUtils.class);
        if (ConcurrencyUtils.isJava21OrMore()) {
            LOGGER.debug("Running Java 21 or more, using virtual threads");
            try {
                Class builderClass = Arrays.stream(Thread.class.getDeclaredClasses()).filter(c -> "Builder".equals(c.getSimpleName())).findFirst().get();
                Object builder = Thread.class.getDeclaredMethod("ofVirtual", new Class[0]).invoke(null, new Object[0]);
                tf = (ThreadFactory)builderClass.getDeclaredMethod("factory", new Class[0]).invoke(builder, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                LOGGER.debug("Error when creating virtual thread factory on Java 21+: {}", (Object)e.getMessage());
                LOGGER.debug("Falling back to default thread factory");
                tf = Executors.defaultThreadFactory();
            }
        } else {
            tf = Executors.defaultThreadFactory();
        }
        THREAD_FACTORY = tf;
    }
}

