/*
 * Decompiled with CFR 0.152.
 */
package com.rabidgremlin.mutters.opennlp.intent;

import com.rabidgremlin.mutters.core.SlotMatcher;
import com.rabidgremlin.mutters.core.Tokenizer;
import com.rabidgremlin.mutters.core.ml.AbstractMachineLearningIntentMatcher;
import java.net.URL;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;

public class OpenNLPIntentMatcher
extends AbstractMachineLearningIntentMatcher {
    private final DoccatModel model;
    private static final float MIN_MATCH_SCORE = 0.75f;

    public OpenNLPIntentMatcher(String intentModel, Tokenizer tokenizer, SlotMatcher slotMatcher) {
        this(Thread.currentThread().getContextClassLoader().getResource(intentModel), tokenizer, slotMatcher, 0.75f, -1.0f);
    }

    public OpenNLPIntentMatcher(String intentModel, Tokenizer tokenizer, SlotMatcher slotMatcher, float minMatchScore, float maybeMatchScore) {
        this(Thread.currentThread().getContextClassLoader().getResource(intentModel), tokenizer, slotMatcher, minMatchScore, maybeMatchScore);
    }

    public OpenNLPIntentMatcher(URL intentModelUrl, Tokenizer tokenizer, SlotMatcher slotMatcher, float minMatchScore, float maybeMatchScore) {
        super(tokenizer, slotMatcher, minMatchScore, maybeMatchScore);
        try {
            this.model = new DoccatModel(intentModelUrl);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load intent model", e);
        }
    }

    protected SortedMap<Double, SortedSet<String>> generateSortedScoreMap(String[] utteranceTokens) {
        DocumentCategorizerME intentCategorizer = new DocumentCategorizerME(this.model);
        SortedMap scores = intentCategorizer.sortedScoreMap(utteranceTokens);
        TreeMap<Double, SortedSet<String>> sortedScores = new TreeMap<Double, SortedSet<String>>();
        scores.forEach((score, intents) -> {
            SortedSet cfr_ignored_0 = sortedScores.put((Double)score, new TreeSet(intents));
        });
        return sortedScores;
    }
}

